/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;

public class TokenStream {
    static final int TSF_NEWLINES = 1;
    static final int TSF_FUNCTION = 2;
    static final int TSF_RETURN_EXPR = 4;
    static final int TSF_RETURN_VOID = 8;
    static final int TSF_REGEXP = 16;
    static final int TSF_DIRTYLINE = 32;
    private static final int EOF_CHAR = -1;
    int flags;
    String regExpFlags;
    private String sourceName;
    private String line;
    private boolean fromEval;
    private int pushbackToken;
    private int tokenno;
    private int op;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private static final int EOL_HINT_MASK = 57296;
    private int lineStart = 0;
    private int lineno;
    private int lineEndChar = -1;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    private int sourceCursor;
    CompilerEnvirons compilerEnv;

    public TokenStream(CompilerEnvirons compilerEnvirons, Reader reader, String string, String string2, int n) {
        this.compilerEnv = compilerEnvirons;
        this.pushbackToken = 0;
        this.sourceName = string2;
        this.lineno = n;
        this.flags = 0;
        if (reader != null) {
            if (string != null) {
                Kit.codeBug();
            }
            this.sourceReader = reader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (string == null) {
                Kit.codeBug();
            }
            this.sourceString = string;
            this.sourceEnd = string.length();
        }
        this.sourceCursor = 0;
    }

    public String tokenToString(int n) {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private int stringToKeyword(String string) {
        String string2 = string;
        int n = 0;
        String string3 = null;
        block0 : switch (string2.length()) {
            case 2: {
                char c = string2.charAt(1);
                if (c == 'f') {
                    if (string2.charAt(0) != 'i') break;
                    return 90;
                }
                if (c == 'n') {
                    if (string2.charAt(0) != 'i') break;
                    return 54;
                }
                if (c != 'o' || string2.charAt(0) != 'd') break;
                return 96;
            }
            case 3: {
                switch (string2.charAt(0)) {
                    case 'f': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'o') break;
                        return 97;
                    }
                    case 'i': {
                        if (string2.charAt(2) != 't' || string2.charAt(1) != 'n') break;
                        return 105;
                    }
                    case 'n': {
                        if (string2.charAt(2) != 'w' || string2.charAt(1) != 'e') break;
                        return 31;
                    }
                    case 't': {
                        if (string2.charAt(2) != 'y' || string2.charAt(1) != 'r') break;
                        return 69;
                    }
                    case 'v': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'a') break;
                        return 100;
                    }
                }
                break;
            }
            case 4: {
                switch (string2.charAt(0)) {
                    case 'b': {
                        string3 = "byte";
                        n = 105;
                        break;
                    }
                    case 'c': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'a') break;
                            return 93;
                        }
                        if (c != 'r' || string2.charAt(2) != 'a' || string2.charAt(1) != 'h') break;
                        return 105;
                    }
                    case 'e': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'l') break;
                            return 91;
                        }
                        if (c != 'm' || string2.charAt(2) != 'u' || string2.charAt(1) != 'n') break;
                        return 105;
                    }
                    case 'g': {
                        string3 = "goto";
                        n = 105;
                        break;
                    }
                    case 'l': {
                        string3 = "long";
                        n = 105;
                        break;
                    }
                    case 'n': {
                        string3 = "null";
                        n = 44;
                        break;
                    }
                    case 't': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 'u' || string2.charAt(1) != 'r') break;
                            return 47;
                        }
                        if (c != 's' || string2.charAt(2) != 'i' || string2.charAt(1) != 'h') break;
                        return 45;
                    }
                    case 'v': {
                        string3 = "void";
                        n = 104;
                        break;
                    }
                    case 'w': {
                        string3 = "with";
                        n = 101;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (string2.charAt(2)) {
                    case 'a': {
                        string3 = "class";
                        n = 105;
                        break;
                    }
                    case 'e': {
                        string3 = "break";
                        n = 98;
                        break;
                    }
                    case 'i': {
                        string3 = "while";
                        n = 95;
                        break;
                    }
                    case 'l': {
                        string3 = "false";
                        n = 46;
                        break;
                    }
                    case 'n': {
                        char c = string2.charAt(0);
                        if (c == 'c') {
                            string3 = "const";
                            n = 105;
                            break;
                        }
                        if (c != 'f') break;
                        string3 = "final";
                        n = 105;
                        break;
                    }
                    case 'o': {
                        char c = string2.charAt(0);
                        if (c == 'f') {
                            string3 = "float";
                            n = 105;
                            break;
                        }
                        if (c != 's') break;
                        string3 = "short";
                        n = 105;
                        break;
                    }
                    case 'p': {
                        string3 = "super";
                        n = 105;
                        break;
                    }
                    case 'r': {
                        string3 = "throw";
                        n = 53;
                        break;
                    }
                    case 't': {
                        string3 = "catch";
                        n = 102;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "native";
                        n = 105;
                        break;
                    }
                    case 'e': {
                        char c = string2.charAt(0);
                        if (c == 'd') {
                            string3 = "delete";
                            n = 32;
                            break;
                        }
                        if (c != 'r') break;
                        string3 = "return";
                        n = 5;
                        break;
                    }
                    case 'h': {
                        string3 = "throws";
                        n = 105;
                        break;
                    }
                    case 'm': {
                        string3 = "import";
                        n = 89;
                        break;
                    }
                    case 'o': {
                        string3 = "double";
                        n = 105;
                        break;
                    }
                    case 't': {
                        string3 = "static";
                        n = 105;
                        break;
                    }
                    case 'u': {
                        string3 = "public";
                        n = 105;
                        break;
                    }
                    case 'w': {
                        string3 = "switch";
                        n = 92;
                        break;
                    }
                    case 'x': {
                        string3 = "export";
                        n = 88;
                        break;
                    }
                    case 'y': {
                        string3 = "typeof";
                        n = 33;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "package";
                        n = 105;
                        break block0;
                    }
                    case 'e': {
                        string3 = "default";
                        n = 94;
                        break block0;
                    }
                    case 'i': {
                        string3 = "finally";
                        n = 103;
                        break block0;
                    }
                    case 'o': {
                        string3 = "boolean";
                        n = 105;
                        break block0;
                    }
                    case 'r': {
                        string3 = "private";
                        n = 105;
                        break block0;
                    }
                    case 'x': {
                        string3 = "extends";
                        n = 105;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string2.charAt(0)) {
                    case 'a': {
                        string3 = "abstract";
                        n = 105;
                        break block0;
                    }
                    case 'c': {
                        string3 = "continue";
                        n = 99;
                        break block0;
                    }
                    case 'd': {
                        string3 = "debugger";
                        n = 105;
                        break block0;
                    }
                    case 'f': {
                        string3 = "function";
                        n = 87;
                        break block0;
                    }
                    case 'v': {
                        string3 = "volatile";
                        n = 105;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = string2.charAt(0);
                if (c == 'i') {
                    string3 = "interface";
                    n = 105;
                    break;
                }
                if (c == 'p') {
                    string3 = "protected";
                    n = 105;
                    break;
                }
                if (c != 't') break;
                string3 = "transient";
                n = 105;
                break;
            }
            case 10: {
                char c = string2.charAt(1);
                if (c == 'm') {
                    string3 = "implements";
                    n = 105;
                    break;
                }
                if (c != 'n') break;
                string3 = "instanceof";
                n = 55;
                break;
            }
            case 12: {
                string3 = "synchronized";
                n = 105;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            return 0;
        }
        if (n != 0) return n & 0xFF;
        return 0;
    }

    public final void reportCurrentLineError(String string) {
        this.compilerEnv.reportSyntaxError(string, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public final void reportCurrentLineWarning(String string) {
        this.compilerEnv.reportSyntaxWarning(string, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final int getLineno() {
        return this.lineno;
    }

    public final int getOp() {
        return this.op;
    }

    public final String getString() {
        return this.string;
    }

    public final double getNumber() {
        return this.number;
    }

    public final int getTokenno() {
        return this.tokenno;
    }

    public final boolean eof() {
        return this.hitEOF;
    }

    public final boolean matchToken(int n) throws IOException {
        int n2 = this.getToken();
        if (n2 == n) {
            return true;
        }
        --this.tokenno;
        this.pushbackToken = n2;
        return false;
    }

    public final void ungetToken(int n) {
        if (this.pushbackToken != 0 && n != -1) {
            Kit.codeBug();
        }
        this.pushbackToken = n;
        --this.tokenno;
    }

    public final int peekToken() throws IOException {
        int n;
        this.pushbackToken = n = this.getToken();
        --this.tokenno;
        return n;
    }

    public final int peekTokenSameLine() throws IOException {
        int n;
        this.flags |= 1;
        this.pushbackToken = n = this.getToken();
        --this.tokenno;
        this.flags &= 0xFFFFFFFE;
        return n;
    }

    public final int getToken() throws IOException {
        int n;
        ++this.tokenno;
        if (this.pushbackToken != 0) {
            n = this.pushbackToken;
            this.pushbackToken = 0;
            if (n != 1 || (this.flags & 1) != 0) {
                return n;
            }
        }
        block38: while (true) {
            int n2;
            int n3;
            if ((n3 = this.getChar()) == -1) {
                return 0;
            }
            if (n3 == 10) {
                this.flags &= 0xFFFFFFDF;
                if ((this.flags & 1) == 0) continue;
                return 1;
            }
            if (TokenStream.isJSSpace(n3)) continue;
            if (n3 != 45) {
                this.flags |= 0x20;
            }
            int n4 = 0;
            if (n3 == 92) {
                n3 = this.getChar();
                if (n3 == 117) {
                    n = 1;
                    n4 = 1;
                    this.stringBufferTop = 0;
                } else {
                    n = 0;
                    this.ungetChar(n3);
                    n3 = 92;
                }
            } else {
                n = Character.isJavaIdentifierStart((char)n3) ? 1 : 0;
                if (n != 0) {
                    this.stringBufferTop = 0;
                    this.addToString(n3);
                }
            }
            if (n != 0) {
                int n5;
                n2 = n4;
                while (true) {
                    if (n4 != 0) {
                        int n6 = 0;
                        for (n5 = 0; n5 != 4 && (n6 = n6 << 4 | TokenStream.xDigitToInt(n3 = this.getChar())) >= 0; ++n5) {
                        }
                        if (n6 < 0) {
                            this.reportCurrentLineError(Context.getMessage0("msg.invalid.escape"));
                            return -1;
                        }
                        this.addToString(n6);
                        n4 = 0;
                        continue;
                    }
                    n3 = this.getChar();
                    if (n3 == 92) {
                        n3 = this.getChar();
                        if (n3 == 117) {
                            n4 = 1;
                            n2 = 1;
                            continue;
                        }
                        this.reportCurrentLineError(Context.getMessage0("msg.illegal.character"));
                        return -1;
                    }
                    if (n3 == -1 || !Character.isJavaIdentifierPart((char)n3)) break;
                    this.addToString(n3);
                }
                this.ungetChar(n3);
                String string = this.getStringFromBuffer();
                if (n2 == 0 && (n5 = this.stringToKeyword(string)) != 0) {
                    if (n5 != 105) {
                        return n5;
                    }
                    if (!this.compilerEnv.reservedKeywordAsIdentifier) {
                        return n5;
                    }
                    this.reportCurrentLineWarning(Context.getMessage1("msg.reserved.keyword", string));
                }
                this.string = (String)this.allStrings.intern(string);
                return 39;
            }
            if (TokenStream.isDigit(n3) || n3 == 46 && TokenStream.isDigit(this.peekChar())) {
                double d;
                this.stringBufferTop = 0;
                n2 = 10;
                if (n3 == 48) {
                    n3 = this.getChar();
                    if (n3 == 120 || n3 == 88) {
                        n2 = 16;
                        n3 = this.getChar();
                    } else if (TokenStream.isDigit(n3)) {
                        n2 = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (n2 == 16) {
                    while (0 <= TokenStream.xDigitToInt(n3)) {
                        this.addToString(n3);
                        n3 = this.getChar();
                    }
                } else {
                    while (48 <= n3 && n3 <= 57) {
                        if (n2 == 8 && n3 >= 56) {
                            this.reportCurrentLineWarning(Context.getMessage1("msg.bad.octal.literal", n3 == 56 ? "8" : "9"));
                            n2 = 10;
                        }
                        this.addToString(n3);
                        n3 = this.getChar();
                    }
                }
                boolean bl = true;
                if (n2 == 10 && (n3 == 46 || n3 == 101 || n3 == 69)) {
                    bl = false;
                    if (n3 == 46) {
                        do {
                            this.addToString(n3);
                        } while (TokenStream.isDigit(n3 = this.getChar()));
                    }
                    if (n3 == 101 || n3 == 69) {
                        this.addToString(n3);
                        n3 = this.getChar();
                        if (n3 == 43 || n3 == 45) {
                            this.addToString(n3);
                            n3 = this.getChar();
                        }
                        if (!TokenStream.isDigit(n3)) {
                            this.reportCurrentLineError(Context.getMessage0("msg.missing.exponent"));
                            return -1;
                        }
                        do {
                            this.addToString(n3);
                        } while (TokenStream.isDigit(n3 = this.getChar()));
                    }
                }
                this.ungetChar(n3);
                String string = this.getStringFromBuffer();
                if (n2 == 10 && !bl) {
                    try {
                        d = Double.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.reportCurrentLineError(Context.getMessage1("msg.caught.nfe", numberFormatException.getMessage()));
                        return -1;
                    }
                } else {
                    d = ScriptRuntime.stringToNumber(string, 0, n2);
                }
                this.number = d;
                return 40;
            }
            if (n3 == 34 || n3 == 39) {
                n2 = n3;
                this.stringBufferTop = 0;
                n3 = this.getChar();
                block45: while (n3 != n2) {
                    if (n3 == 10 || n3 == -1) {
                        this.ungetChar(n3);
                        this.reportCurrentLineError(Context.getMessage0("msg.unterminated.string.lit"));
                        return -1;
                    }
                    if (n3 == 92) {
                        n3 = this.getChar();
                        switch (n3) {
                            case 98: {
                                n3 = 8;
                                break;
                            }
                            case 102: {
                                n3 = 12;
                                break;
                            }
                            case 110: {
                                n3 = 10;
                                break;
                            }
                            case 114: {
                                n3 = 13;
                                break;
                            }
                            case 116: {
                                n3 = 9;
                                break;
                            }
                            case 118: {
                                n3 = 11;
                                break;
                            }
                            case 117: {
                                int n7;
                                int n8 = this.stringBufferTop;
                                this.addToString(117);
                                int n9 = 0;
                                for (n7 = 0; n7 != 4; ++n7) {
                                    n3 = this.getChar();
                                    if ((n9 = n9 << 4 | TokenStream.xDigitToInt(n3)) < 0) continue block45;
                                    this.addToString(n3);
                                }
                                this.stringBufferTop = n8;
                                n3 = n9;
                                break;
                            }
                            case 120: {
                                n3 = this.getChar();
                                int n9 = TokenStream.xDigitToInt(n3);
                                if (n9 < 0) {
                                    this.addToString(120);
                                    continue block45;
                                }
                                int n7 = n3;
                                n3 = this.getChar();
                                if ((n9 = n9 << 4 | TokenStream.xDigitToInt(n3)) < 0) {
                                    this.addToString(120);
                                    this.addToString(n7);
                                    continue block45;
                                }
                                n3 = n9;
                                break;
                            }
                            default: {
                                if (48 > n3 || n3 >= 56) break;
                                int n7 = n3 - 48;
                                n3 = this.getChar();
                                if (48 <= n3 && n3 < 56) {
                                    n7 = 8 * n7 + n3 - 48;
                                    n3 = this.getChar();
                                    if (48 <= n3 && n3 < 56 && n7 <= 31) {
                                        n7 = 8 * n7 + n3 - 48;
                                        n3 = this.getChar();
                                    }
                                }
                                this.ungetChar(n3);
                                n3 = n7;
                            }
                        }
                    }
                    this.addToString(n3);
                    n3 = this.getChar();
                }
                String string = this.getStringFromBuffer();
                this.string = (String)this.allStrings.intern(string);
                return 41;
            }
            switch (n3) {
                case 59: {
                    return 70;
                }
                case 91: {
                    return 71;
                }
                case 93: {
                    return 72;
                }
                case 123: {
                    return 73;
                }
                case 125: {
                    return 74;
                }
                case 40: {
                    return 75;
                }
                case 41: {
                    return 76;
                }
                case 44: {
                    return 77;
                }
                case 63: {
                    return 80;
                }
                case 58: {
                    return 81;
                }
                case 46: {
                    return 86;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 82;
                    }
                    if (this.matchChar(61)) {
                        this.op = 10;
                        return 79;
                    }
                    return 10;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        this.op = 11;
                        return 79;
                    }
                    return 11;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 83;
                    }
                    if (this.matchChar(61)) {
                        this.op = 12;
                        return 79;
                    }
                    return 12;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 48;
                        }
                        return 13;
                    }
                    return 78;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 49;
                        }
                        return 14;
                    }
                    return 27;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                this.skipLine();
                                continue block38;
                            }
                            this.ungetChar(45);
                        }
                        this.ungetChar(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            this.op = 19;
                            return 79;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 16;
                    }
                    return 15;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                this.op = 21;
                                return 79;
                            }
                            return 21;
                        }
                        if (this.matchChar(61)) {
                            this.op = 20;
                            return 79;
                        }
                        return 20;
                    }
                    if (this.matchChar(61)) {
                        return 18;
                    }
                    return 17;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        this.op = 24;
                        return 79;
                    }
                    return 24;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        this.skipLine();
                        continue block38;
                    }
                    if (this.matchChar(42)) {
                        n2 = 0;
                        while (true) {
                            if ((n3 = this.getChar()) == -1) {
                                this.reportCurrentLineError(Context.getMessage0("msg.unterminated.comment"));
                                return -1;
                            }
                            if (n3 == 42) {
                                n2 = 1;
                                continue;
                            }
                            if (n3 == 47) {
                                if (n2 == 0) continue;
                                continue block38;
                            }
                            n2 = 0;
                        }
                    }
                    if ((this.flags & 0x10) != 0) {
                        this.stringBufferTop = 0;
                        while ((n3 = this.getChar()) != 47) {
                            if (n3 == 10 || n3 == -1) {
                                this.ungetChar(n3);
                                this.reportCurrentLineError(Context.getMessage0("msg.unterminated.re.lit"));
                                return -1;
                            }
                            if (n3 == 92) {
                                this.addToString(n3);
                                n3 = this.getChar();
                            }
                            this.addToString(n3);
                        }
                        n2 = this.stringBufferTop;
                        while (true) {
                            if (this.matchChar(103)) {
                                this.addToString(103);
                                continue;
                            }
                            if (this.matchChar(105)) {
                                this.addToString(105);
                                continue;
                            }
                            if (!this.matchChar(109)) break;
                            this.addToString(109);
                        }
                        if (TokenStream.isAlpha(this.peekChar())) {
                            this.reportCurrentLineError(Context.getMessage0("msg.invalid.re.flag"));
                            return -1;
                        }
                        this.string = new String(this.stringBuffer, 0, n2);
                        this.regExpFlags = new String(this.stringBuffer, n2, this.stringBufferTop - n2);
                        return 50;
                    }
                    if (this.matchChar(61)) {
                        this.op = 25;
                        return 79;
                    }
                    return 25;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        this.op = 26;
                        return 79;
                    }
                    return 26;
                }
                case 126: {
                    return 28;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        this.op = 22;
                        return 79;
                    }
                    if (this.matchChar(43)) {
                        return 84;
                    }
                    return 22;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        this.op = 23;
                        n3 = 79;
                    } else if (this.matchChar(45)) {
                        if (0 == (this.flags & 0x20) && this.matchChar(62)) {
                            this.skipLine();
                            continue block38;
                        }
                        n3 = 85;
                    } else {
                        n3 = 23;
                    }
                    this.flags |= 0x20;
                    return n3;
                }
            }
            break;
        }
        this.reportCurrentLineError(Context.getMessage0("msg.illegal.character"));
        return -1;
    }

    private static boolean isAlpha(int n) {
        if (n <= 90) {
            return 65 <= n;
        }
        return 97 <= n && n <= 122;
    }

    static boolean isDigit(int n) {
        return 48 <= n && n <= 57;
    }

    static int xDigitToInt(int n) {
        if (n <= 57) {
            if (0 <= (n -= 48)) {
                return n;
            }
        } else if (n <= 70) {
            if (65 <= n) {
                return n - 55;
            }
        } else if (n <= 102 && 97 <= n) {
            return n - 87;
        }
        return -1;
    }

    public static boolean isJSSpace(int n) {
        if (n <= 127) {
            return n == 32 || n == 9 || n == 12 || n == 11;
        }
        return n == 160 || Character.getType((char)n) == 12;
    }

    public static boolean isJSLineTerminator(int n) {
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    private static boolean isJSFormatChar(int n) {
        return n > 127 && Character.getType((char)n) == 16;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        if (n2 == this.stringBuffer.length) {
            char[] cArray = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, cArray, 0, n2);
            this.stringBuffer = cArray;
        }
        this.stringBuffer[n2] = (char)n;
        this.stringBufferTop = n2 + 1;
    }

    private void ungetChar(int n) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = n;
    }

    private boolean matchChar(int n) throws IOException {
        int n2 = this.getChar();
        if (n2 == n) {
            return true;
        }
        this.ungetChar(n2);
        return false;
    }

    private int peekChar() throws IOException {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    private int getChar() throws IOException {
        int n;
        block11: {
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    n = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    n = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && n == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block11;
                }
                if (!TokenStream.isJSFormatChar(n)) break;
            }
            if ((n & 0xDFD0) == 0 && TokenStream.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        return n;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && n != 10) {
        }
        this.ungetChar(n);
    }

    public final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    public final String getLine() {
        if (this.sourceString != null) {
            int n;
            if (this.lineEndChar >= 0) {
                --n;
            } else {
                char c;
                for (n = this.sourceCursor; !(n == this.sourceEnd || ((c = this.sourceString.charAt(n)) & 0xDFD0) == 0 && TokenStream.isJSLineTerminator(c)); ++n) {
                }
            }
            return this.sourceString.substring(this.lineStart, n);
        }
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        } else {
            while (true) {
                char c;
                int n2;
                if ((n2 = this.lineStart + n) == this.sourceEnd) {
                    try {
                        if (!this.fillSourceBuffer()) {
                        }
                    }
                    catch (IOException iOException) {}
                    break;
                    n2 = this.lineStart + n;
                }
                if (((c = this.sourceBuffer[n2]) & 0xDFD0) == 0 && TokenStream.isJSLineTerminator(c)) break;
                ++n;
            }
        }
        return new String(this.sourceBuffer, this.lineStart, n);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] cArray = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceEnd);
                this.sourceBuffer = cArray;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }
}

