/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean inFunction;
    private boolean hasFinally;
    private CompilerEnvirons compilerEnv;

    public NodeTransformer(CompilerEnvirons compilerEnvirons) {
        this.compilerEnv = compilerEnvirons;
    }

    public final void transform(ScriptOrFnNode scriptOrFnNode) {
        this.transformCompilationUnit(scriptOrFnNode);
        for (int i = 0; i != scriptOrFnNode.getFunctionCount(); ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            this.transform(functionNode);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode scriptOrFnNode) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.inFunction = scriptOrFnNode.getType() == 87;
        this.hasFinally = false;
        this.transformCompilationUnit_r(scriptOrFnNode, scriptOrFnNode);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode scriptOrFnNode, Node node) {
        Node node2 = null;
        while (true) {
            Node node3 = null;
            if (node2 == null) {
                node2 = node.getFirstChild();
            } else {
                node3 = node2;
                node2 = node2.getNext();
            }
            if (node2 == null) break;
            int n = node2.getType();
            block0 : switch (n) {
                case 110: {
                    Object object;
                    Node node4;
                    Node.Jump jump = (Node.Jump)node2;
                    String string = jump.getLabel();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        node4 = (Node)this.loops.get(i);
                        if (node4.getType() != 110 || !string.equals(object = ((Node.Jump)node4).getLabel())) continue;
                        this.reportError(Context.getMessage1("msg.dup.label", string), node2, scriptOrFnNode);
                        break block0;
                    }
                    Node.Target target = new Node.Target();
                    for (node4 = node2.getNext(); node4 != null && (node4.getType() == 110 || node4.getType() == 111); node4 = node4.getNext()) {
                    }
                    if (node4 == null) break;
                    node.addChildAfter(target, node4);
                    jump.target = target;
                    if (node4.getType() == 112) {
                        jump.setContinue(((Node.Jump)node4).getContinue());
                    } else if (node4.getType() == 124 && (object = node4.getFirstChild()) != null && ((Node)object).getType() == 112) {
                        jump.setContinue(((Node.Jump)object).getContinue());
                    }
                    this.loops.push(node2);
                    this.loopEnds.push(target);
                    break;
                }
                case 92: {
                    Node.Target target = new Node.Target();
                    node.addChildAfter(target, node2);
                    Node node5 = node2;
                    Node node6 = node2.getFirstChild().next;
                    while (node6 != null) {
                        Node node7 = node6.next;
                        node2.removeChild(node6);
                        node.addChildAfter(node6, node5);
                        node5 = node6;
                        node6 = node7;
                    }
                    ((Node.Jump)node2).target = target;
                    this.loops.push(node2);
                    this.loopEnds.push(target);
                    node2.putProp(8, new ObjArray());
                    break;
                }
                case 93: 
                case 94: {
                    Node node8 = (Node)this.loops.peek();
                    if (n == 93) {
                        ObjArray objArray = (ObjArray)node8.getProp(8);
                        objArray.add(node2);
                        break;
                    }
                    node8.putProp(9, node2);
                    break;
                }
                case 112: {
                    this.loops.push(node2);
                    this.loopEnds.push(((Node.Jump)node2).target);
                    break;
                }
                case 101: {
                    if (this.inFunction) {
                        ((FunctionNode)scriptOrFnNode).setRequiresActivation(true);
                    }
                    this.loops.push(node2);
                    Node node9 = node2.getNext();
                    if (node9.getType() != 4) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(node9);
                    break;
                }
                case 69: {
                    Node.Jump jump = (Node.Jump)node2;
                    Node.Target target = jump.getFinally();
                    if (target == null) break;
                    this.hasFinally = true;
                    this.loops.push(node2);
                    this.loopEnds.push(target);
                    break;
                }
                case 4: 
                case 111: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node2) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    Node node10;
                    Node node11;
                    if (!this.hasFinally) break;
                    Node node12 = node2.getFirstChild();
                    boolean bl = false;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node node13;
                        Node node14 = (Node)this.loops.get(i);
                        int n2 = node14.getType();
                        if (n2 != 69 && n2 != 101) continue;
                        if (!bl) {
                            bl = true;
                            if (node12 != null) {
                                node2.setType(2);
                                this.transformCompilationUnit_r(scriptOrFnNode, node2);
                                node13 = new Node(67);
                                node.addChildAfter(node13, node2);
                                node3 = node2;
                                node2 = node13;
                            }
                        }
                        if (n2 == 69) {
                            node11 = new Node.Jump(115);
                            node10 = ((Node.Jump)node14).getFinally();
                            ((Node.Jump)node11).target = node10;
                            node13 = node11;
                        } else {
                            node13 = new Node(4);
                        }
                        node3 = NodeTransformer.addBeforeCurrent(node, node3, node2, node13);
                    }
                    break;
                }
                case 98: 
                case 99: {
                    Node node10;
                    Node node11;
                    Object object;
                    Node.Jump jump = (Node.Jump)node2;
                    Node node15 = null;
                    String string = jump.getLabel();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        object = (Node)this.loops.get(i);
                        int n3 = ((Node)object).getType();
                        if (n3 == 101) {
                            node11 = new Node(4);
                            node3 = NodeTransformer.addBeforeCurrent(node, node3, node2, node11);
                            continue;
                        }
                        if (n3 == 69) {
                            node11 = (Node.Jump)object;
                            node10 = new Node.Jump(115);
                            node10.target = ((Node.Jump)node11).getFinally();
                            node3 = NodeTransformer.addBeforeCurrent(node, node3, node2, node10);
                            continue;
                        }
                        if (n3 == 110) {
                            if (string == null || !string.equals(((Node.Jump)(node11 = (Node.Jump)object)).getLabel())) continue;
                            node15 = node11;
                            break;
                        }
                        if (n3 == 112) {
                            if (string != null) continue;
                            node15 = (Node.Jump)object;
                            break;
                        }
                        if (n3 != 92 || string != null || n != 98) continue;
                        node15 = (Node.Jump)object;
                        break;
                    }
                    object = node15 == null ? null : (n == 98 ? node15.target : node15.getContinue());
                    if (node15 == null || object == null) {
                        node11 = null;
                        String string2 = string == null ? Context.getMessage0(n == 99 ? "msg.continue.outside" : "msg.bad.break") : (node15 != null ? Context.getMessage0("msg.continue.nonloop") : Context.getMessage1("msg.undef.label", string));
                        this.reportError(string2, node2, scriptOrFnNode);
                        break;
                    }
                    jump.setType(6);
                    jump.target = object;
                    break;
                }
                case 38: {
                    int n4 = NodeTransformer.getSpecialCallType(scriptOrFnNode, node2);
                    if (n4 != 0) {
                        node2.putIntProp(17, n4);
                    }
                    this.visitCall(node2, scriptOrFnNode);
                    break;
                }
                case 31: {
                    int n5 = NodeTransformer.getSpecialCallType(scriptOrFnNode, node2);
                    if (n5 != 0) {
                        node2.putIntProp(17, n5);
                    }
                    this.visitNew(node2, scriptOrFnNode);
                    break;
                }
                case 86: {
                    Node node16 = node2.getLastChild();
                    node16.setType(41);
                    break;
                }
                case 113: {
                    node2.setType(this.inFunction ? 51 : 2);
                    break;
                }
                case 100: {
                    Object object;
                    Node node17 = new Node(107);
                    for (Node node18 = node2.getFirstChild(); node18 != null; node18 = node18.getNext()) {
                        Node node19 = node18;
                        if (node19.getType() == 39) continue;
                        Kit.codeBug();
                        if (!node19.hasChildren()) continue;
                        Node node20 = node19.getFirstChild();
                        node19.removeChild(node20);
                        node19.setType(52);
                        node19 = new Node(9, node19, node20);
                        object = new Node(51, node19, node2.getLineno());
                        node17.addChildToBack((Node)object);
                    }
                    node2 = NodeTransformer.replaceCurrent(node, node3, node2, node17);
                    break;
                }
                case 9: 
                case 32: {
                    Node node21;
                    if (!this.inFunction || this.inWithStatement() || (node21 = node2.getFirstChild()) == null || node21.getType() != 52) break;
                    String string = node21.getString();
                    if (this.isActivationNeeded(string)) {
                        ((FunctionNode)scriptOrFnNode).setRequiresActivation(true);
                    }
                    if (!scriptOrFnNode.hasParamOrVar(string)) break;
                    if (n == 9) {
                        node2.setType(60);
                        node21.setType(41);
                        break;
                    }
                    Node node22 = new Node(46);
                    node2 = NodeTransformer.replaceCurrent(node, node3, node2, node22);
                    break;
                }
                case 34: {
                    String string;
                    if (!this.inFunction) break;
                    Node node23 = node2.getFirstChild().getNext();
                    String string3 = string = node23 == null ? "" : node23.getString();
                    if (!this.isActivationNeeded(string) && (!string.equals("length") || this.compilerEnv.getLanguageVersion() != 120)) break;
                    ((FunctionNode)scriptOrFnNode).setRequiresActivation(true);
                    break;
                }
                case 39: {
                    if (!this.inFunction || this.inWithStatement()) break;
                    String string = node2.getString();
                    if (this.isActivationNeeded(string)) {
                        ((FunctionNode)scriptOrFnNode).setRequiresActivation(true);
                    }
                    if (!scriptOrFnNode.hasParamOrVar(string)) break;
                    node2.setType(59);
                    break;
                }
            }
            this.transformCompilationUnit_r(scriptOrFnNode, node2);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode scriptOrFnNode) {
    }

    protected void visitCall(Node node, ScriptOrFnNode scriptOrFnNode) {
    }

    protected boolean inWithStatement() {
        for (int i = this.loops.size() - 1; i >= 0; --i) {
            Node node = (Node)this.loops.get(i);
            if (node.getType() != 101) continue;
            return true;
        }
        return false;
    }

    private static int getSpecialCallType(Node node, Node node2) {
        String string;
        Node node3 = node2.getFirstChild();
        int n = 0;
        if (node3.getType() == 39) {
            String string2 = node3.getString();
            if (string2.equals("eval")) {
                n = 1;
            } else if (string2.equals("With")) {
                n = 2;
            }
        } else if (node3.getType() == 34 && (string = node3.getLastChild().getString()).equals("eval")) {
            n = 1;
        }
        if (n != 0 && node.getType() == 87) {
            ((FunctionNode)node).setRequiresActivation(true);
        }
        return n;
    }

    private static Node addBeforeCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.addChildToFront(node4);
        } else {
            if (node3 != node2.getNext()) {
                Kit.codeBug();
            }
            node.addChildAfter(node4, node2);
        }
        return node4;
    }

    private static Node replaceCurrent(Node node, Node node2, Node node3, Node node4) {
        if (node2 == null) {
            if (node3 != node.getFirstChild()) {
                Kit.codeBug();
            }
            node.replaceChild(node3, node4);
        } else if (node2.next == node3) {
            node.replaceChildAfter(node2, node4);
        } else {
            node.replaceChild(node3, node4);
        }
        return node4;
    }

    private void reportError(String string, Node node, ScriptOrFnNode scriptOrFnNode) {
        int n = node.getLineno();
        String string2 = scriptOrFnNode.getSourceName();
        this.compilerEnv.reportSyntaxError(string, string2, n, null, 0);
    }

    private boolean isActivationNeeded(String string) {
        if ("arguments".equals(string)) {
            return true;
        }
        return this.compilerEnv.activationNames != null && this.compilerEnv.activationNames.containsKey(string);
    }
}

