/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    MemberBox[] ctors;

    JavaMembers(Scriptable scriptable, Class clazz) {
        this.cl = clazz;
        this.reflect(scriptable);
    }

    boolean has(String string, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string);
        if (v != null) {
            return true;
        }
        return null != this.findExplicitFunction(string, bl);
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object3 = hashtable.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        Context context = Context.getContext();
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                object2 = beanProperty.getter.invoke(object, null);
                clazz = beanProperty.getter.method().getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrap(context, scriptable, object2, clazz);
    }

    public void put(Scriptable scriptable, String string, Object object, Object object2, boolean bl) {
        Object object3;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object4 = hashtable.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)hashtable.get(string);
            object4 = ((FieldAndMethods)object3).field;
        }
        if (object4 instanceof BeanProperty) {
            object3 = (BeanProperty)object4;
            if (((BeanProperty)object3).setter == null) {
                throw this.reportMemberNotFound(string);
            }
            Class clazz = ((BeanProperty)object3).setter.argTypes[0];
            Object[] objectArray = new Object[]{NativeJavaObject.coerceType(clazz, object2, true)};
            try {
                ((BeanProperty)object3).setter.invoke(object, objectArray);
            }
            catch (Exception exception) {
                throw Context.throwAsScriptRuntimeEx(exception);
            }
        }
        if (!(object4 instanceof Field)) {
            object3 = object4 == null ? "msg.java.internal.private" : "msg.java.method.assign";
            throw Context.reportRuntimeError1((String)object3, string);
        }
        object3 = (Field)object4;
        Object object5 = NativeJavaObject.coerceType(((Field)object3).getType(), object2, true);
        try {
            ((Field)object3).set(object, object5);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Context.reportRuntimeError3("msg.java.internal.field.type", object2.getClass().getName(), object3, object.getClass().getName());
        }
    }

    Object[] getIds(boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        int n = hashtable.size();
        Object[] objectArray = new Object[n];
        Enumeration enumeration = hashtable.keys();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = enumeration.nextElement();
        }
        return objectArray;
    }

    static String javaSignature(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        String string = clazz.getName();
        String string2 = "[]";
        if (n == 1) {
            return string.concat(string2);
        }
        int n2 = string.length() + n * string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        while (n != 0) {
            --n;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String liveConnectSignature(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(JavaMembers.javaSignature(classArray[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private MemberBox findExplicitFunction(String string, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        int n = string.indexOf(40);
        if (n < 0) {
            return null;
        }
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        MemberBox[] memberBoxArray = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            memberBoxArray = this.ctors;
        } else {
            String string2 = string.substring(0, n);
            object2 = hashtable.get(string2);
            if (!bl && object2 == null) {
                object2 = this.staticMembers.get(string2);
            }
            if (object2 instanceof NativeJavaMethod) {
                object = (NativeJavaMethod)object2;
                memberBoxArray = ((NativeJavaMethod)object).methods;
            }
        }
        if (memberBoxArray != null) {
            for (int i = 0; i < memberBoxArray.length; ++i) {
                object2 = memberBoxArray[i].argTypes;
                object = JavaMembers.liveConnectSignature(object2);
                if (n + ((String)object).length() != string.length() || !string.regionMatches(n, (String)object, 0, ((String)object).length())) continue;
                return memberBoxArray[i];
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        BaseFunction baseFunction = null;
        MemberBox memberBox = this.findExplicitFunction(string, bl);
        if (memberBox != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (memberBox.isCtor()) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor(memberBox);
                nativeJavaConstructor.setPrototype(scriptable2);
                baseFunction = nativeJavaConstructor;
                hashtable.put(string, nativeJavaConstructor);
            } else {
                String string2 = memberBox.getName();
                baseFunction = (BaseFunction)hashtable.get(string2);
                if (baseFunction instanceof NativeJavaMethod && ((NativeJavaMethod)baseFunction).methods.length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod(memberBox, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    hashtable.put(string, nativeJavaMethod);
                    baseFunction = nativeJavaMethod;
                }
            }
        }
        return baseFunction;
    }

    private void reflect(Scriptable scriptable) {
        this.reflectMethods(scriptable);
        this.reflectFields(scriptable);
        this.makeBeanProperties(scriptable, false);
        this.makeBeanProperties(scriptable, true);
        this.reflectCtors(scriptable);
    }

    private void reflectMethods(Scriptable scriptable) {
        Method[] methodArray = this.cl.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            ObjArray objArray;
            String string;
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (!Modifier.isPublic(n)) continue;
            boolean bl = Modifier.isStatic(n);
            Hashtable hashtable = bl ? this.staticMembers : this.members;
            Object v = hashtable.get(string = method.getName());
            if (v == null) {
                hashtable.put(string, method);
                continue;
            }
            if (v instanceof ObjArray) {
                objArray = (ObjArray)v;
            } else {
                if (!(v instanceof Method)) {
                    Kit.codeBug();
                }
                objArray = new ObjArray();
                objArray.add(v);
                hashtable.put(string, objArray);
            }
            objArray.add(method);
        }
        JavaMembers.initNativeMethods(this.staticMembers, scriptable);
        JavaMembers.initNativeMethods(this.members, scriptable);
    }

    private void reflectFields(Scriptable scriptable) {
        Field[] fieldArray = this.cl.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object;
            String string;
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n)) continue;
            boolean bl = Modifier.isStatic(n);
            Hashtable hashtable = bl ? this.staticMembers : this.members;
            Object v = hashtable.get(string = field.getName());
            if (v == null) {
                hashtable.put(string, field);
                continue;
            }
            if (v instanceof NativeJavaMethod) {
                object = (NativeJavaMethod)v;
                FieldAndMethods fieldAndMethods = new FieldAndMethods(((NativeJavaMethod)object).methods, field);
                fieldAndMethods.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
                this.getFieldAndMethodsTable(bl).put(string, fieldAndMethods);
                hashtable.put(string, fieldAndMethods);
                continue;
            }
            if (v instanceof Field) {
                object = (Field)v;
                if (!((Field)object).getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                hashtable.put(string, field);
                continue;
            }
            Kit.codeBug();
        }
    }

    private void makeBeanProperties(Scriptable scriptable, boolean bl) {
        String string;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Hashtable<String, BeanProperty> hashtable2 = new Hashtable<String, BeanProperty>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object v;
            String string2;
            string = (String)enumeration.nextElement();
            boolean bl2 = string.startsWith("get");
            boolean bl3 = string.startsWith("is");
            if (!bl2 && !bl3 || (string2 = string.substring(bl2 ? 3 : 2)).length() == 0) continue;
            String string3 = string2;
            char c = string2.charAt(0);
            if (Character.isUpperCase(c)) {
                if (string2.length() == 1) {
                    string3 = string2.toLowerCase();
                } else {
                    char c2 = string2.charAt(1);
                    if (!Character.isUpperCase(c2)) {
                        string3 = Character.toLowerCase(c) + string2.substring(1);
                    }
                }
            }
            if (hashtable.containsKey(string3) || !((v = hashtable.get(string)) instanceof NativeJavaMethod)) continue;
            NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)v;
            MemberBox memberBox = JavaMembers.extractGetMethod(nativeJavaMethod.methods, bl);
            if (memberBox == null) continue;
            NativeJavaMethod nativeJavaMethod2 = null;
            MemberBox memberBox2 = null;
            String string4 = "set".concat(string2);
            if (hashtable.containsKey(string4) && (v = hashtable.get(string4)) instanceof NativeJavaMethod) {
                nativeJavaMethod2 = (NativeJavaMethod)v;
                object = memberBox.method().getReturnType();
                memberBox2 = JavaMembers.extractSetMethod((Class)object, nativeJavaMethod2.methods, bl);
            }
            object = new BeanProperty(memberBox, memberBox2);
            hashtable2.put(string3, (BeanProperty)object);
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object v = hashtable2.get(string);
            hashtable.put(string, v);
        }
    }

    private void reflectCtors(Scriptable scriptable) {
        Constructor<?>[] constructorArray = this.cl.getConstructors();
        int n = constructorArray.length;
        this.ctors = new MemberBox[n];
        ClassCache classCache = ClassCache.get(scriptable);
        for (int i = 0; i != n; ++i) {
            this.ctors[i] = new MemberBox(constructorArray[i], classCache);
        }
    }

    private static void initNativeMethods(Hashtable hashtable, Scriptable scriptable) {
        Enumeration enumeration = hashtable.keys();
        ClassCache classCache = ClassCache.get(scriptable);
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            MemberBox[] memberBoxArray;
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Method) {
                memberBoxArray = new MemberBox[]{new MemberBox((Method)v, classCache)};
            } else {
                serializable = (ObjArray)v;
                int n = ((ObjArray)serializable).size();
                if (n < 2) {
                    Kit.codeBug();
                }
                memberBoxArray = new MemberBox[n];
                for (int i = 0; i != n; ++i) {
                    Method method = (Method)((ObjArray)serializable).get(i);
                    memberBoxArray[i] = new MemberBox(method, classCache);
                }
            }
            serializable = new NativeJavaMethod(memberBoxArray);
            if (scriptable != null) {
                ((ScriptableObject)serializable).setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
            }
            hashtable.put(string, serializable);
        }
    }

    private Hashtable getFieldAndMethodsTable(boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
            if (bl) {
                this.staticFieldAndMethods = hashtable;
            } else {
                this.fieldAndMethods = hashtable;
            }
        }
        return hashtable;
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 0; i < memberBoxArray.length; ++i) {
            MemberBox memberBox = memberBoxArray[i];
            if (memberBox.argTypes.length != 0 || bl && !memberBox.isStatic()) continue;
            Class<?> clazz = memberBox.method().getReturnType();
            if (clazz == Void.TYPE) break;
            return memberBox;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class clazz, MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 1; i <= 2; ++i) {
            for (int j = 0; j < memberBoxArray.length; ++j) {
                Class[] classArray;
                MemberBox memberBox = memberBoxArray[j];
                if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || (classArray = memberBox.argTypes).length != 1) continue;
                if (i == 1) {
                    if (classArray[0] != clazz) continue;
                    return memberBox;
                }
                if (i != 2) {
                    Kit.codeBug();
                }
                if (!classArray[0].isAssignableFrom(clazz)) continue;
                return memberBox;
            }
        }
        return null;
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            return null;
        }
        int n = hashtable.size();
        Hashtable<String, FieldAndMethods> hashtable3 = new Hashtable<String, FieldAndMethods>(n);
        Enumeration enumeration = hashtable.elements();
        while (n-- > 0) {
            FieldAndMethods fieldAndMethods = (FieldAndMethods)enumeration.nextElement();
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashtable3.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashtable3;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class clazz, Class clazz2) {
        JavaMembers javaMembers;
        ClassCache classCache = ClassCache.get(scriptable);
        Hashtable hashtable = classCache.classTable;
        Class clazz3 = clazz;
        while (true) {
            if ((javaMembers = (JavaMembers)hashtable.get(clazz3)) != null) {
                return javaMembers;
            }
            try {
                javaMembers = new JavaMembers(scriptable, clazz3);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    clazz3 = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    if (clazz3.isInterface()) {
                        clazz4 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                clazz3 = clazz4;
                continue;
            }
            break;
        }
        if (classCache.isCachingEnabled()) {
            hashtable.put(clazz3, javaMembers);
        }
        return javaMembers;
    }

    RuntimeException reportMemberNotFound(String string) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string);
    }
}

