/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

class IRFactory {
    private Parser parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(118);
    }

    void initScript(ScriptOrFnNode scriptOrFnNode, Object object) {
        Node node = ((Node)object).getFirstChild();
        if (node != null) {
            scriptOrFnNode.addChildrenToBack(node);
        }
    }

    Object createLeaf(int n) {
        return new Node(n);
    }

    Object createLeaf(int n, int n2) {
        return new Node(n, n2);
    }

    Object createSwitch(int n) {
        return new Node.Jump(92, n);
    }

    Object createVariables(int n) {
        return new Node(100, n);
    }

    Object createExprStatement(Object object, int n) {
        return new Node(113, (Node)object, n);
    }

    Object createExprStatementNoReturn(Object object, int n) {
        return new Node(51, (Node)object, n);
    }

    Object createName(String string) {
        return Node.newString(39, string);
    }

    Object createString(String string) {
        return Node.newString(string);
    }

    Object createNumber(double d) {
        return Node.newNumber(d);
    }

    Object createCatch(String string, Object object, Object object2, int n) {
        if (object == null) {
            object = new Node(106);
        }
        return new Node(102, (Node)this.createName(string), (Node)object, (Node)object2, n);
    }

    Object createThrow(Object object, int n) {
        return new Node(53, (Node)object, n);
    }

    Object createReturn(Object object, int n) {
        return object == null ? new Node(5, n) : new Node(5, (Node)object, n);
    }

    Object createLabel(String string, int n) {
        Node.Jump jump = new Node.Jump(110, n);
        jump.setLabel(string);
        return jump;
    }

    Object createBreak(String string, int n) {
        Node.Jump jump = new Node.Jump(98, n);
        if (string != null) {
            jump.setLabel(string);
        }
        return jump;
    }

    Object createContinue(String string, int n) {
        Node.Jump jump = new Node.Jump(99, n);
        if (string != null) {
            jump.setLabel(string);
        }
        return jump;
    }

    Object createBlock(int n) {
        return new Node(107, n);
    }

    FunctionNode createFunction(String string) {
        return new FunctionNode(string);
    }

    Object initFunction(FunctionNode functionNode, int n, Object object, int n2) {
        Node node;
        String string;
        Node node2;
        Node node3 = (Node)object;
        functionNode.setFunctionType(n2);
        functionNode.addChildToBack(node3);
        int n3 = functionNode.getFunctionCount();
        if (n3 != 0) {
            functionNode.setRequiresActivation(true);
            for (int i = 0; i != n3; ++i) {
                String string2;
                node2 = functionNode.getFunctionNode(i);
                if (((FunctionNode)node2).getFunctionType() != 3 || (string2 = ((FunctionNode)node2).getFunctionName()) == null || string2.length() == 0) continue;
                functionNode.removeParamOrVar(string2);
            }
        }
        if (n2 == 2 && (string = functionNode.getFunctionName()) != null && string.length() != 0 && !functionNode.hasParamOrVar(string)) {
            functionNode.addVar(string);
            node2 = new Node(51, new Node(60, Node.newString(string), new Node(66)));
            node3.addChildrenToFront(node2);
        }
        if ((node = node3.getLastChild()) == null || node.getType() != 5) {
            node3.addChildToBack(new Node(5));
        }
        node2 = Node.newString(87, functionNode.getFunctionName());
        node2.putIntProp(1, n);
        return node2;
    }

    void addChildToBack(Object object, Object object2) {
        ((Node)object).addChildToBack((Node)object2);
    }

    Object createWhile(Object object, Object object2, int n) {
        return this.createLoop(1, (Node)object2, (Node)object, null, null, n);
    }

    Object createDoWhile(Object object, Object object2, int n) {
        return this.createLoop(0, (Node)object, (Node)object2, null, null, n);
    }

    Object createFor(Object object, Object object2, Object object3, Object object4, int n) {
        return this.createLoop(2, (Node)object4, (Node)object2, (Node)object, (Node)object3, n);
    }

    private Node createLoop(int n, Node node, Node node2, Node node3, Node node4, int n2) {
        Node.Target target = new Node.Target();
        Node.Target target2 = new Node.Target();
        if (n == 2 && node2.getType() == 106) {
            node2 = new Node(47);
        }
        Node.Jump jump = new Node.Jump(7, node2);
        jump.target = target;
        Node.Target target3 = new Node.Target();
        Node.Jump jump2 = new Node.Jump(112, n2);
        jump2.addChildToBack(target);
        jump2.addChildrenToBack(node);
        if (n == 1 || n == 2) {
            jump2.addChildrenToBack(new Node(106, n2));
        }
        jump2.addChildToBack(target2);
        jump2.addChildToBack(jump);
        jump2.addChildToBack(target3);
        jump2.target = target3;
        Node.Target target4 = target2;
        if (n == 1 || n == 2) {
            Node.Jump jump3 = new Node.Jump(6);
            jump3.target = target2;
            jump2.addChildToFront(jump3);
            if (n == 2) {
                if (node3.getType() != 106) {
                    if (node3.getType() != 100) {
                        node3 = new Node(51, node3);
                    }
                    jump2.addChildToFront(node3);
                }
                Node.Target target5 = new Node.Target();
                jump2.addChildAfter(target5, node);
                if (node4.getType() != 106) {
                    node4 = (Node)this.createUnary(51, node4);
                    jump2.addChildAfter(node4, target5);
                }
                target4 = target5;
            }
        }
        jump2.setContinue(target4);
        return jump2;
    }

    Object createForIn(Object object, Object object2, Object object3, int n) {
        Node node;
        Node node2 = (Node)object;
        Node node3 = (Node)object2;
        int n2 = node2.getType();
        Node node4 = node2;
        switch (n2) {
            case 34: 
            case 36: 
            case 39: {
                break;
            }
            case 100: {
                node = node2.getLastChild();
                if (node2.getFirstChild() != node) {
                    this.parser.reportError("msg.mult.index");
                }
                node4 = Node.newString(39, node.getString());
                break;
            }
            default: {
                this.parser.reportError("msg.bad.for.in.lhs");
                return node3;
            }
        }
        node = new Node(124);
        Node node5 = new Node(63, node3);
        node5.putProp(4, node);
        Node node6 = new Node(64);
        node6.putProp(4, node);
        Node node7 = new Node(65);
        node7.putProp(4, node);
        Node node8 = new Node(107);
        Node node9 = (Node)this.createAssignment(node4, node7);
        node8.addChildToBack(new Node(51, node9));
        node8.addChildToBack((Node)object3);
        Node node10 = (Node)this.createWhile(node6, node8, n);
        node10.addChildToFront(node5);
        if (n2 == 100) {
            node10.addChildToFront(node2);
        }
        node.addChildToBack(node10);
        return node;
    }

    Object createTryCatchFinally(Object object, Object object2, Object object3, int n) {
        Node node;
        Node node2;
        Node node3 = (Node)object;
        boolean bl = false;
        Node node4 = null;
        if (object3 != null) {
            node4 = (Node)object3;
            boolean bl2 = bl = node4.getType() != 107 || node4.hasChildren();
        }
        if (node3.getType() == 107 && !node3.hasChildren() && !bl) {
            return node3;
        }
        Node node5 = (Node)object2;
        boolean bl3 = node5.hasChildren();
        if (!bl && !bl3) {
            return node3;
        }
        Node node6 = new Node(124);
        Node.Jump jump = new Node.Jump(69, node3, n);
        jump.putProp(4, node6);
        Node.Target target = null;
        if (bl) {
            target = new Node.Target();
            jump.setFinally(target);
            node2 = new Node.Jump(115);
            ((Node.Jump)node2).target = target;
            jump.addChildToBack(node2);
        }
        node2 = new Node.Target();
        Node.Jump jump2 = new Node.Jump(6);
        jump2.target = node2;
        jump.addChildToBack(jump2);
        if (bl3) {
            Node node7;
            node = new Node.Target();
            jump.target = node;
            jump.addChildToBack(node);
            Node.Target target2 = new Node.Target();
            boolean bl4 = false;
            for (Node node8 = node5.getFirstChild(); node8 != null; node8 = node8.getNext()) {
                Node node9;
                int n2 = node8.getLineno();
                node7 = node8.getFirstChild();
                Node node10 = node7.getNext();
                Node node11 = node10.getNext();
                node8.removeChild(node7);
                node8.removeChild(node10);
                node8.removeChild(node11);
                node11.addChildToBack(new Node(4));
                Node.Jump jump3 = new Node.Jump(6);
                jump3.target = target2;
                node11.addChildToBack(jump3);
                if (node10.getType() == 106) {
                    node9 = node11;
                    bl4 = true;
                } else {
                    node9 = (Node)this.createIf(node10, node11, null, n2);
                }
                Node node12 = Node.newString(62, node7.getString());
                node12.addChildToBack(this.createUseLocal(node6));
                Node node13 = (Node)this.createWith(node12, node9, n2);
                jump.addChildToBack(node13);
            }
            if (!bl4) {
                Node node14 = new Node(53, this.createUseLocal(node6));
                jump.addChildToBack(node14);
            }
            jump.addChildToBack(target2);
            if (bl) {
                Node.Jump jump4 = new Node.Jump(115);
                jump4.target = target;
                jump.addChildToBack(jump4);
                node7 = new Node.Jump(6);
                ((Node.Jump)node7).target = node2;
                jump.addChildToBack(node7);
            }
        }
        if (bl) {
            jump.addChildToBack(target);
            node = new Node(103, node4);
            node.putProp(4, node6);
            jump.addChildToBack(node);
        }
        jump.addChildToBack(node2);
        node6.addChildToBack(jump);
        return node6;
    }

    Object createWith(Object object, Object object2, int n) {
        Node node = new Node(107, n);
        node.addChildToBack(new Node(3, (Node)object));
        Node node2 = new Node(101, (Node)object2, n);
        node.addChildrenToBack(node2);
        node.addChildToBack(new Node(4));
        return node;
    }

    Object createArrayLiteral(Object object) {
        Node node;
        Node node2 = new Node(31, Node.newString(39, "Array"));
        Node node3 = new Node(123, node2);
        Node node4 = null;
        int n = 0;
        for (node = ((Node)object).getFirstChild(); node != null; node = node.getNext()) {
            node4 = node;
            if (node4.getType() == 61) {
                ++n;
                continue;
            }
            Node node5 = new Node(37, new Node(120), Node.newNumber(n), node4);
            ++n;
            node3.addChildToBack(node5);
        }
        if (this.parser.compilerEnv.languageVersion == 120) {
            if (node4 != null && node4.getType() == 61) {
                node = new Node(35, new Node(120), Node.newString("length"), Node.newNumber(n));
                node3.addChildToBack(node);
            }
        } else {
            node2.addChildToBack(Node.newNumber(n));
        }
        return node3;
    }

    Object createObjectLiteral(Object object) {
        Node node = new Node(31, Node.newString(39, "Object"));
        Node node2 = new Node(123, node);
        for (Node node3 = ((Node)object).getFirstChild(); node3 != null; node3 = node3.getNext()) {
            Node node4 = node3;
            node3 = node3.getNext();
            int n = node4.getType() == 39 ? 35 : 37;
            Node node5 = node3;
            Node node6 = new Node(n, new Node(120), node4, node5);
            node2.addChildToBack(node6);
        }
        return node2;
    }

    Object createRegExp(int n) {
        Node node = new Node(50);
        node.putIntProp(7, n);
        return node;
    }

    Object createIf(Object object, Object object2, Object object3, int n) {
        Node node = (Node)object;
        int n2 = IRFactory.isAlwaysDefinedBoolean(node);
        if (n2 == 1) {
            return object2;
        }
        if (n2 == -1) {
            if (object3 != null) {
                return object3;
            }
            return new Node(107, n);
        }
        Node node2 = new Node(107, n);
        Node.Target target = new Node.Target();
        Node.Jump jump = new Node.Jump(8, node);
        jump.target = target;
        node2.addChildToBack(jump);
        node2.addChildrenToBack((Node)object2);
        if (object3 != null) {
            Node.Target target2;
            Node.Jump jump2 = new Node.Jump(6);
            jump2.target = target2 = new Node.Target();
            node2.addChildToBack(jump2);
            node2.addChildToBack(target);
            node2.addChildrenToBack((Node)object3);
            node2.addChildToBack(target2);
        } else {
            node2.addChildToBack(target);
        }
        return node2;
    }

    Object createCondExpr(Object object, Object object2, Object object3) {
        Node node = (Node)object;
        int n = IRFactory.isAlwaysDefinedBoolean(node);
        if (n == 1) {
            return object2;
        }
        if (n == -1) {
            return object3;
        }
        return new Node(80, node, (Node)object2, (Node)object3);
    }

    Object createUnary(int n, Object object) {
        Node node = (Node)object;
        int n2 = node.getType();
        switch (n) {
            case 32: {
                Node node2;
                Node node3;
                if (n2 == 39) {
                    node.setType(52);
                    node3 = node;
                    node2 = Node.newString(node.getString());
                } else if (n2 == 34 || n2 == 36) {
                    node3 = node.getFirstChild();
                    node2 = node.getLastChild();
                    node.removeChild(node3);
                    node.removeChild(node2);
                } else {
                    return new Node(47);
                }
                return new Node(n, node3, node2);
            }
            case 33: {
                if (n2 != 39) break;
                node.setType(119);
                return node;
            }
            case 28: {
                if (n2 != 40) break;
                int n3 = ScriptRuntime.toInt32(node.getDouble());
                node.setDouble(~n3);
                return node;
            }
            case 30: {
                if (n2 != 40) break;
                node.setDouble(-node.getDouble());
                return node;
            }
            case 27: {
                int n4 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n4 == 0) break;
                int n5 = n4 == 1 ? 46 : 47;
                if (n2 == 47 || n2 == 46) {
                    node.setType(n5);
                    return node;
                }
                return new Node(n5);
            }
        }
        return new Node(n, node);
    }

    Object createIncDec(int n, boolean bl, Object object) {
        Node node = (Node)object;
        int n2 = node.getType();
        if (n2 == 39) {
            if (bl) {
                return new Node(n, node);
            }
            Node node2 = (Node)this.createNumber(1.0);
            String string = node.getString();
            Node node3 = Node.newString(39, string);
            node3 = new Node(29, node3);
            int n3 = n == 84 ? 22 : 23;
            Node node4 = new Node(n3, node3, node2);
            Node node5 = Node.newString(52, string);
            return new Node(9, node5, node4);
        }
        if (n2 == 34 || n2 == 36) {
            if (bl) {
                return new Node(n, node);
            }
            Node node6 = (Node)this.createNumber(1.0);
            return this.createAssignmentOp(n == 84 ? 22 : 23, node, node6, true);
        }
        this.parser.reportError("msg.bad.lhs.assign");
        return object;
    }

    Object createBinary(int n, Object object, Object object2) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        switch (n) {
            case 86: {
                n = 34;
                node2.setType(41);
                String string = node2.getString();
                int n2 = string.length();
                int n3 = 0;
                if (n2 == 9) {
                    if (string.equals("__proto__")) {
                        n3 = 1;
                    }
                } else if (n2 == 10 && string.equals("__parent__")) {
                    n3 = 2;
                }
                if (n3 == 0) break;
                Node node3 = new Node(n, node);
                node3.putIntProp(11, n3);
                return node3;
            }
            case 71: {
                n = 36;
                break;
            }
            case 22: {
                if (node.type == 41) {
                    String string;
                    if (node2.type == 41) {
                        string = node2.getString();
                    } else {
                        if (node2.type != 40) break;
                        string = ScriptRuntime.numberToString(node2.getDouble(), 10);
                    }
                    String string2 = node.getString();
                    node.setString(string2.concat(string));
                    return node;
                }
                if (node.type != 40) break;
                if (node2.type == 40) {
                    node.setDouble(node.getDouble() + node2.getDouble());
                    return node;
                }
                if (node2.type != 41) break;
                String string = ScriptRuntime.numberToString(node.getDouble(), 10);
                String string3 = node2.getString();
                node2.setString(string.concat(string3));
                return node2;
            }
            case 23: {
                if (node.type == 40) {
                    double d = node.getDouble();
                    if (node2.type == 40) {
                        node.setDouble(d - node2.getDouble());
                        return node;
                    }
                    if (d != 0.0) break;
                    return new Node(30, node2);
                }
                if (node2.type != 40 || node2.getDouble() != 0.0) break;
                return new Node(29, node);
            }
            case 24: {
                if (node.type == 40) {
                    double d = node.getDouble();
                    if (node2.type == 40) {
                        node.setDouble(d * node2.getDouble());
                        return node;
                    }
                    if (d != 1.0) break;
                    return new Node(29, node2);
                }
                if (node2.type != 40 || node2.getDouble() != 1.0) break;
                return new Node(29, node);
            }
            case 25: {
                if (node2.type != 40) break;
                double d = node2.getDouble();
                if (node.type == 40) {
                    node.setDouble(node.getDouble() / d);
                    return node;
                }
                if (d != 1.0) break;
                return new Node(29, node);
            }
            case 83: {
                int n4 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n4 == -1) {
                    return new Node(46);
                }
                if (n4 == 1) {
                    return node2;
                }
                int n5 = IRFactory.isAlwaysDefinedBoolean(node2);
                if (n5 == -1) {
                    if (IRFactory.hasSideEffects(node)) break;
                    return new Node(46);
                }
                if (n5 != 1) break;
                return node;
            }
            case 82: {
                int n6 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n6 == 1) {
                    return new Node(47);
                }
                if (n6 == -1) {
                    return node2;
                }
                int n7 = IRFactory.isAlwaysDefinedBoolean(node2);
                if (n7 == 1) {
                    if (IRFactory.hasSideEffects(node)) break;
                    return new Node(47);
                }
                if (n7 != -1) break;
                return node;
            }
        }
        return new Node(n, node, node2);
    }

    Object createAssignment(Object object, Object object2) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        int n = node.getType();
        switch (n) {
            case 39: {
                node.setType(52);
                return new Node(9, node, node2);
            }
            case 34: 
            case 36: {
                int n2;
                Node node3 = node.getFirstChild();
                Node node4 = node.getLastChild();
                if (n == 34) {
                    n2 = 35;
                    int n3 = node.getIntProp(11, 0);
                    if (n3 != 0) {
                        Node node5 = new Node(35, node3, node2);
                        node5.putIntProp(11, n3);
                        return node5;
                    }
                } else {
                    n2 = 37;
                }
                return new Node(n2, node3, node4, node2);
            }
        }
        this.parser.reportError("msg.bad.lhs.assign");
        return node;
    }

    Object createAssignmentOp(int n, Object object, Object object2) {
        return this.createAssignmentOp(n, (Node)object, (Node)object2, false);
    }

    private Node createAssignmentOp(int n, Node node, Node node2, boolean bl) {
        int n2 = node.getType();
        switch (n2) {
            case 39: {
                String string = node.getString();
                Node node3 = Node.newString(39, string);
                if (bl) {
                    node3 = new Node(29, node3);
                }
                Node node4 = new Node(n, node3, node2);
                Node node5 = Node.newString(52, string);
                return new Node(9, node5, node4);
            }
            case 34: 
            case 36: {
                Node node6 = node.getFirstChild();
                Node node7 = node.getLastChild();
                int n3 = n2 == 34 ? 121 : 122;
                Node node8 = new Node(120);
                if (bl) {
                    node8 = new Node(29, node8);
                }
                Node node9 = new Node(n, node8, node2);
                return new Node(n3, node6, node7, node9);
            }
        }
        this.parser.reportError("msg.bad.lhs.assign");
        return node;
    }

    Node createUseLocal(Node node) {
        if (124 != node.getType()) {
            Kit.codeBug();
        }
        Node node2 = new Node(57);
        node2.putProp(4, node);
        return node2;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 44: 
            case 46: 
            case 61: {
                return -1;
            }
            case 47: {
                return 1;
            }
            case 40: {
                double d = node.getDouble();
                if (d == d && d != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasSideEffects(Node node) {
        switch (node.getType()) {
            case 9: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 84: 
            case 85: {
                return true;
            }
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!IRFactory.hasSideEffects(node2)) continue;
            return true;
        }
        return false;
    }
}

