/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.ScriptRuntime;

public class CompilerEnvirons {
    private ErrorReporter errorReporter = DefaultErrorReporter.instance;
    private int syntaxErrorCount = 0;
    private boolean fromEval = false;
    int languageVersion = 0;
    boolean generateDebugInfo = true;
    boolean useDynamicScope = false;
    boolean reservedKeywordAsIdentifier = false;
    boolean allowMemberExprAsFunctionName = false;
    private int optimizationLevel = 0;
    private boolean generatingSource = true;
    Hashtable activationNames;

    public void initFromContext(Context context) {
        this.setErrorReporter(context.getErrorReporter());
        this.languageVersion = context.getLanguageVersion();
        this.useDynamicScope = context.hasCompileFunctionsWithDynamicScope();
        this.generateDebugInfo = !context.isGeneratingDebugChanged() || context.isGeneratingDebug();
        this.reservedKeywordAsIdentifier = context.hasFeature(3);
        this.allowMemberExprAsFunctionName = context.hasFeature(2);
        this.optimizationLevel = context.getOptimizationLevel();
        this.generatingSource = context.isGeneratingSource();
        this.activationNames = context.activationNames;
    }

    public final int getSyntaxErrorCount() {
        return this.syntaxErrorCount;
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public final void reportSyntaxError(String string, String string2, int n, String string3, int n2) {
        ++this.syntaxErrorCount;
        if (this.fromEval) {
            throw ScriptRuntime.constructError("SyntaxError", string, string2, n, string3, n2);
        }
        this.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public final void reportSyntaxWarning(String string, String string2, int n, String string3, int n2) {
        this.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public final boolean isFromEval() {
        return this.fromEval;
    }

    public void setFromEval(boolean bl) {
        this.fromEval = bl;
    }

    public final int getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(int n) {
        Context.checkLanguageVersion(n);
        this.languageVersion = n;
    }

    public final boolean isGenerateDebugInfo() {
        return this.generateDebugInfo;
    }

    public void setGenerateDebugInfo(boolean bl) {
        this.generateDebugInfo = bl;
    }

    public final boolean isUseDynamicScope() {
        return this.useDynamicScope;
    }

    public void setUseDynamicScope(boolean bl) {
        this.useDynamicScope = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int n) {
        Context.checkOptimizationLevel(n);
        this.optimizationLevel = n;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }
}

