/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class LinesComponent
extends JComponent
implements Accessible,
SettingsChangeListener {
    private JEditorPane editorPane;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight = 1;
    private float lineHeightCorrection = 1.0f;
    private Map coloringMap;
    private boolean init = false;
    private int numberWidth;
    private boolean showLineNumbers = true;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private Insets lineNumberMargin;
    private int lineNumberDigitWidth;
    private int lineAscent;
    private LinkedList linesList;
    private int activeLine = -1;
    private static final long serialVersionUID = -4861542695772182147L;

    public LinesComponent(JEditorPane pane) {
        this.editorPane = pane;
        this.font = this.editorPane.getFont();
        this.foreColor = this.editorPane.getForeground();
        this.backgroundColor = this.editorPane.getBackground();
        this.setLineNumberDigitWidth(10);
        this.setLineNumberMargin(new Insets(2, 2, 2, 4));
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.init();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        this.createLines();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)LinesComponent.class, (String)"ACSN_Lines_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)LinesComponent.class, (String)"ACSD_Lines_Component"));
    }

    private void createLines() {
        this.linesList = new LinkedList();
        StyledDocument doc = (StyledDocument)this.editorPane.getDocument();
        int lastOffset = doc.getEndPosition().getOffset();
        int lineCnt = NbDocument.findLineNumber((StyledDocument)doc, (int)lastOffset);
        for (int i = 0; i < lineCnt; ++i) {
            this.linesList.add("" + (i + 1));
        }
    }

    public void addEmptyLines(int line, int count) {
        boolean appending = line > this.linesList.size();
        for (int i = 0; i < count; ++i) {
            if (appending) {
                this.linesList.add("");
                continue;
            }
            this.linesList.add(line, "");
        }
    }

    public void insertNumbers(int line, int startNum, int count) {
        boolean appending;
        boolean bl = appending = line >= this.linesList.size();
        if (appending) {
            int i = 0;
            while (i < count) {
                this.linesList.add(Integer.toString(startNum));
                ++i;
                ++startNum;
            }
        } else {
            int toAdd = Math.max(line + count - this.linesList.size(), 0);
            count -= toAdd;
            int i = 0;
            while (i < count) {
                this.linesList.set(line, Integer.toString(startNum));
                ++i;
                ++startNum;
                ++line;
            }
            i = 0;
            while (i < toAdd) {
                this.linesList.add(Integer.toString(startNum));
                ++i;
                ++startNum;
            }
        }
    }

    public void removeNumbers(int line, int count) {
        boolean appending;
        boolean bl = appending = line >= this.linesList.size();
        if (appending) {
            for (int i = 0; i < count; ++i) {
                this.linesList.add("");
            }
        } else {
            int toAdd = Math.max(line + count - this.linesList.size(), 0);
            count -= toAdd;
            int i = 0;
            while (i < count) {
                this.linesList.set(line, "");
                ++i;
                ++line;
            }
            for (i = 0; i < toAdd; ++i) {
                this.linesList.add("");
            }
        }
    }

    public void shrink(int numLines) {
        while (this.linesList.size() > numLines) {
            this.linesList.remove(numLines);
        }
    }

    private void updateState(Graphics g) {
        Class<?> kitClass = this.editorPane.getEditorKit().getClass();
        Object value = Settings.getValue(kitClass, (String)"line-height-correction");
        if (!(value instanceof Float) || ((Float)value).floatValue() < 0.0f) {
            value = SettingsDefaults.defaultLineHeightCorrection;
        }
        this.lineHeightCorrection = ((Float)value).floatValue();
        Map cm = this.getColoringMap();
        Object colValue = cm.get("line-number");
        Coloring col = null;
        col = colValue != null && colValue instanceof Coloring ? (Coloring)colValue : SettingsDefaults.defaultLineNumberColoring;
        this.foreColor = col.getForeColor();
        if (this.foreColor == null) {
            this.foreColor = ((Coloring)cm.get("default")).getForeColor();
        }
        this.backgroundColor = col.getBackColor();
        if (this.backgroundColor == null) {
            this.backgroundColor = ((Coloring)cm.get("default")).getBackColor();
        }
        this.font = col.getFont();
        if (this.font == null) {
            this.font = ((Coloring)cm.get("default")).getFont();
        }
        FontMetrics fm = g.getFontMetrics(this.font);
        this.updateLineHeight(g);
        this.showLineNumbers = true;
        this.init = true;
        if (this.highestLineNumber <= this.getLineCount()) {
            this.highestLineNumber = this.getLineCount();
        }
        int maxWidth = 1;
        char[] digit = new char[1];
        for (int i = 0; i <= 9; ++i) {
            digit[0] = (char)(48 + i);
            maxWidth = Math.max(maxWidth, fm.charsWidth(digit, 0, 1));
        }
        this.setLineNumberDigitWidth(maxWidth);
        this.resize();
    }

    private void updateLineHeight(Graphics g) {
        Map cm = this.getColoringMap();
        Iterator i = cm.entrySet().iterator();
        int maxHeight = 1;
        int maxAscent = 0;
        while (i.hasNext()) {
            FontMetrics fm;
            Font font;
            Map.Entry me = i.next();
            String coloringName = (String)me.getKey();
            Coloring c = (Coloring)me.getValue();
            if (c == null || (font = c.getFont()) == null || (c.getFontMode() & 4) == 0 || (fm = g.getFontMetrics(font)) == null) continue;
            maxHeight = Math.max(maxHeight, fm.getHeight());
            maxAscent = Math.max(maxAscent, fm.getAscent());
        }
        this.lineHeight = (int)((float)maxHeight * this.lineHeightCorrection);
        this.lineAscent = (int)((float)maxAscent * this.lineHeightCorrection);
    }

    private Map getColoringMap() {
        if (this.coloringMap == null) {
            this.coloringMap = EditorUIHelper.getSharedColoringMapFor(this.editorPane.getEditorKit().getClass());
        }
        return this.coloringMap;
    }

    protected void resize() {
        Dimension dim = new Dimension();
        dim.width = this.getWidthDimension();
        dim.height = this.getHeightDimension();
        dim.height += 300 * this.lineHeight;
        this.numberWidth = this.getLineNumberWidth();
        this.setPreferredSize(dim);
        this.revalidate();
    }

    protected int getLineCount() {
        return this.linesList.size();
    }

    protected int getDigitCount(int number) {
        return Integer.toString(number).length();
    }

    protected int getLineNumberWidth() {
        int newWidth = 0;
        Insets insets = this.getLineNumberMargin();
        if (insets != null) {
            newWidth += insets.left + insets.right;
        }
        return newWidth += (this.getDigitCount(this.highestLineNumber) + 1) * this.getLineNumberDigitWidth();
    }

    protected int getWidthDimension() {
        int newWidth = 0;
        if (this.showLineNumbers) {
            newWidth += this.getLineNumberWidth();
        }
        return newWidth;
    }

    protected int getHeightDimension() {
        return this.highestLineNumber * this.lineHeight;
    }

    public void paintComponent(Graphics g) {
        int lastLine;
        int line;
        super.paintComponent(g);
        if (!this.init) {
            this.updateState(g);
        }
        Rectangle drawHere = g.getClipBounds();
        g.setColor(this.backgroundColor);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(this.font);
        g.setColor(this.foreColor);
        FontMetrics fm = FontMetricsCache.getFontMetrics((Font)this.font, (Component)this);
        int rightMargin = 0;
        Insets margin = this.getLineNumberMargin();
        if (margin != null) {
            rightMargin = margin.right;
        }
        if ((line = (int)((float)drawHere.y / (float)this.lineHeight)) > 0) {
            --line;
        }
        int y = line * this.lineHeight;
        if (this.showLineNumbers && (lastLine = (int)((float)(drawHere.y + drawHere.height) / (float)this.lineHeight) + 1) > this.highestLineNumber) {
            int prevHighest = this.highestLineNumber;
            this.highestLineNumber = lastLine;
            if (this.getDigitCount(this.highestLineNumber) > this.getDigitCount(prevHighest)) {
                this.resize();
                return;
            }
        }
        while (y + this.lineHeight / 2 <= drawHere.y + drawHere.height) {
            if (this.showLineNumbers) {
                String lineStr = null;
                if (line < this.linesList.size()) {
                    lineStr = (String)this.linesList.get(line);
                }
                if (lineStr == null) {
                    lineStr = "";
                }
                String activeSymbol = "*";
                int lineNumberWidth = fm.stringWidth(lineStr);
                if (line == this.activeLine - 1) {
                    lineStr = lineStr + activeSymbol;
                }
                int activeSymbolWidth = fm.stringWidth(activeSymbol);
                g.drawString(lineStr, this.numberWidth - (lineNumberWidth += activeSymbolWidth) - rightMargin, y + this.getLineAscent());
            }
            y += this.lineHeight;
            ++line;
        }
    }

    public void changedLine(int line) {
        if (!this.init) {
            return;
        }
        if (line > 0) {
            --line;
        }
        int y = line * this.lineHeight;
        this.repaint(0, y, (int)this.getSize().getWidth(), 3 * this.lineHeight);
        this.checkSize();
    }

    public void changedAll() {
        if (!this.init) {
            return;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int count = this.getLineCount();
        if (count > this.highestLineNumber) {
            this.highestLineNumber = count;
        }
        Dimension dim = this.getPreferredSize();
        if (this.getWidthDimension() > dim.width || this.getHeightDimension() > dim.height) {
            this.resize();
        }
    }

    public Insets getLineNumberMargin() {
        return this.lineNumberMargin;
    }

    public void setLineNumberMargin(Insets lineNumberMargin) {
        this.lineNumberMargin = lineNumberMargin;
    }

    public int getLineNumberDigitWidth() {
        return this.lineNumberDigitWidth;
    }

    public void setLineNumberDigitWidth(int lineNumberDigitWidth) {
        this.lineNumberDigitWidth = lineNumberDigitWidth;
    }

    public int getLineAscent() {
        return this.lineAscent;
    }

    public void setLineAscent(int lineAscent) {
        this.lineAscent = lineAscent;
    }

    public int getActiveLine() {
        return this.activeLine;
    }

    public void setActiveLine(int activeLine) {
        this.activeLine = activeLine;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.coloringMap = null;
        this.init = false;
        this.repaint();
    }

    private static class EditorUIHelper
    extends EditorUI {
        public static Map getSharedColoringMapFor(Class kitClass) {
            return EditorUIHelper.getSharedColoringMap((Class)kitClass);
        }
    }
}

