/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Cache {
    private static Map cache;

    Cache() {
    }

    public static void put(SuggestionContext ctx, List result) {
        FileObject fo = ctx.getFileObject();
        String name = Cache.createKey(fo);
        if (name == null) {
            return;
        }
        if (result == null || result.isEmpty()) {
            long timestamp = fo.lastModified().getTime();
            Cache.cache().put(name, new long[]{timestamp, System.currentTimeMillis()});
        } else {
            Cache.cache().remove(name);
        }
    }

    public static List get(SuggestionContext ctx) {
        FileObject fo = ctx.getFileObject();
        String name = Cache.createKey(fo);
        if (name == null) {
            return null;
        }
        Object hit = Cache.cache().get(name);
        if (hit != null) {
            if (((long[])hit)[0] >= fo.lastModified().getTime()) {
                return Collections.EMPTY_LIST;
            }
            Cache.cache().remove(name);
        }
        return null;
    }

    private static String createKey(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static Map cache() {
        if (cache == null) {
            Cache.load();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        ObjectInputStream ois = null;
        try {
            File file = Cache.getCacheFile(false);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            ois = new ObjectInputStream(in);
            if (ois.readInt() == 1) {
                cache = (Map)ois.readObject();
            }
        }
        catch (IOException io) {
        }
        catch (ClassNotFoundException e) {
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
        if (cache == null) {
            cache = new HashMap(1113);
        }
        long staleTime = System.currentTimeMillis() - 1468800000L;
        if (Settings.getDefault().getModificationTime() > staleTime) {
            staleTime = Settings.getDefault().getModificationTime();
        }
        Iterator it = cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (((long[])entry.getValue())[1] >= staleTime) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        if (cache == null) {
            return;
        }
        try {
            File file = Cache.getCacheFile(true);
            OutputStream os = new FileOutputStream(file);
            os = new BufferedOutputStream(os);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeInt(1);
            oos.writeObject(cache);
            oos.close();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            cache = null;
        }
    }

    private static File getCacheFile(boolean create) throws IOException {
        String loc = System.getProperty("netbeans.user") + File.separatorChar + "var" + File.separatorChar + "cache" + File.separatorChar + "all-todos.ser";
        File file = new File(loc);
        if (create && !file.exists()) {
            File parent = file.getParentFile();
            parent.mkdirs();
            file.createNewFile();
        }
        return file;
    }
}

