/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.predicates.clazz.AnnotatedAsRemote;
import org.netbeans.modules.javacore.api.JavaModel;

public class BeanUsesLBIasLBI
extends AbstractRule {
    List<String> incorrectLBIs = new ArrayList<String>();

    public String getId() {
        return "BeanUsesLBIasLBI";
    }

    protected String getMessageKey() {
        return "MSG_BeanUsesRBIasLBI";
    }

    protected Object[] getMessageParameters() {
        return this.incorrectLBIs.toArray();
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.isSessionBean() && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Set<String> lbis = ctx.getLBIs();
            for (String lbi : lbis) {
                JavaClass jc;
                Type type = JavaModel.getDefaultExtent().getType().resolve(lbi);
                if (!(type instanceof JavaClass) || !new AnnotatedAsRemote().evaluate((Object)(jc = (JavaClass)JavaClass.class.cast(type)))) continue;
                this.incorrectLBIs.add(lbi);
            }
            if (!this.incorrectLBIs.isEmpty()) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }

    public void reset() {
        this.incorrectLBIs.clear();
    }
}

