/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.checks;

import java.io.IOException;
import java.util.MissingResourceException;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitNotPresent
extends ProblemFinder {
    public void parseDocument() {
        PersistenceScope[] scopes;
        if (!this.getIsEntityClass()) {
            return;
        }
        FileObject fo = NbEditorUtilities.getFileObject((Document)this.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        for (PersistenceScope scope : scopes = PersistenceUtils.getPersistenceScopes((Project)project)) {
            if (!scope.getClassPath().contains(fo)) continue;
            try {
                PersistenceUnit[] pus;
                FileObject persistenceXML = scope.getPersistenceXml();
                if (persistenceXML == null || (pus = PersistenceMetadata.getDefault().getRoot(persistenceXML).getPersistenceUnit()) == null || pus.length <= 0) continue;
                return;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.generateWarning();
    }

    private void generateWarning() throws MissingResourceException {
        JavaClass javaClass = this.getMainJavaClass();
        Annotation elementToAnnotate = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.persistence.Entity");
        if (elementToAnnotate == null) {
            elementToAnnotate = javaClass;
        }
        JEEVerificationContextInfo contextInfo = new JEEVerificationContextInfo(javaClass);
        JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("missing_persistence_unit", NbBundle.getMessage(this.getClass(), (String)"MSG_MissingPersistenceUnitHint"), contextInfo, JEEVerificationProblemMark.Severity.WARNING);
        this.attachProblemMarkToElement(problemMark, (Element)elementToAnnotate);
        this.addProblemMark(problemMark);
    }
}

