/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes.elements;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.j2ee.common.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.j2ee.common.ui.nodes.editors.MethodParameterArrayEditor;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class ElementNode {
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_EXCEPTIONS = "exceptions";

    static String getString(String key) {
        return NbBundle.getMessage(ElementNode.class, (String)key);
    }

    public static void setModel(Element el, FeatureDescriptor fd) {
        JavaModelPackage model = JavaMetamodel.getManager().getJavaExtent(el);
        fd.setValue("JavaModelPackage", model);
    }

    public static JavaModelPackage getModel(FeatureDescriptor fd) {
        JavaModelPackage model = (JavaModelPackage)fd.getValue("JavaModelPackage");
        if (model == null) {
            model = JavaMetamodel.getManager().getDefaultExtent();
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("missing JavaModelPackage"));
        }
        return model;
    }

    public static Node.Property createParametersProperty(CallableFeature element, boolean canW) {
        ParametersProperty prop = new ParametersProperty(element, canW);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    public static Node.Property createExceptionsProperty(CallableFeature element, boolean canW) {
        ExceptionsProperty prop = new ExceptionsProperty(element, canW);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    static abstract class ElementProp
    extends PropertySupport {
        private Reference editor = null;

        public ElementProp(String name, Class type, boolean canW) {
            super(name, type, ElementNode.getString("PROP_" + name), ElementNode.getString("HINT_" + name), true, canW);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(ElementNode.getString("MSG_Cannot_Write"));
            }
        }

        public final PropertyEditor getPropertyEditor() {
            PropertyEditor pe;
            if (this.editor == null || (pe = (PropertyEditor)this.editor.get()) == null) {
                pe = this.createPropertyEditor();
                this.editor = new SoftReference<PropertyEditor>(pe);
            }
            return pe;
        }

        protected PropertyEditor createPropertyEditor() {
            return super.getPropertyEditor();
        }
    }

    private static final class ExceptionsProperty
    extends ElementProp {
        private final CallableFeature element;

        public ExceptionsProperty(CallableFeature element, boolean canW) {
            super(ElementNode.PROP_EXCEPTIONS, MultipartId[].class, canW);
            this.element = element;
        }

        protected PropertyEditor createPropertyEditor() {
            return new IdentifierArrayEditor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() {
            MultipartId[] ret = null;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    List l = this.element.getExceptionNames();
                    ret = l.toArray(new MultipartId[l.size()]);
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
            catch (JmiException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof MultipartId[])) {
                throw new IllegalArgumentException();
            }
            boolean fail = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List exs = this.element.getExceptionNames();
                    exs.clear();
                    exs.addAll(Arrays.asList((MultipartId[])val));
                    fail = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                }
            }
            catch (JmiException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                throw iae;
            }
        }
    }

    private static final class ParametersProperty
    extends ElementProp {
        private final CallableFeature element;

        private ParametersProperty(CallableFeature element, boolean canW) {
            super(ElementNode.PROP_PARAMETERS, Parameter[].class, canW);
            this.element = element;
        }

        public Object getValue() {
            List l = this.element.getParameters();
            return l.toArray(new Parameter[l.size()]);
        }

        public PropertyEditor createPropertyEditor() {
            return new MethodParameterArrayEditor(this.canWrite());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof Parameter[])) {
                throw new IllegalArgumentException();
            }
            boolean fail = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List l = this.element.getParameters();
                    l.clear();
                    l.addAll(Arrays.asList((Parameter[])val));
                    fail = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                }
            }
            catch (JmiException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                throw iae;
            }
        }
    }
}

