/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes;

import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Action;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.ComponentMethodViewStrategy;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MethodNode
extends FilterNode
implements MDRChangeListener,
OpenCookie {
    private Method method;
    private ComponentMethodViewStrategy cmvs;
    private Collection interfaces;
    private JavaClass implBean;

    public MethodNode(Method method, JavaClass implBean, Collection interfaces, ComponentMethodViewStrategy cmvs) {
        this(method, implBean, interfaces, cmvs, new InstanceContent());
    }

    private MethodNode(Method method, JavaClass implBean, Collection interfaces, ComponentMethodViewStrategy cmvs, InstanceContent ic) {
        super(MethodNode.createMethodElementNode(method), FilterNode.Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        ic.add((Object)this);
        ic.add((Object)method);
        this.disableDelegation(64);
        this.method = method;
        this.implBean = implBean;
        this.interfaces = interfaces;
        this.cmvs = cmvs;
        ((MDRChangeSource)method).addListener((MDRChangeListener)this);
    }

    private static Node createMethodElementNode(Method method) {
        SourceNodeFactory snf = SourceNodes.getExplorerFactory();
        return snf.createMethodNode(method);
    }

    public Image getIcon(int type) {
        Image badge = this.cmvs.getBadge(this.method, this.interfaces);
        Image icon = this.cmvs.getIcon(this.method, this.interfaces);
        if (badge != null) {
            return Utilities.mergeImages((Image)icon, (Image)badge, (int)7, (int)7);
        }
        return icon;
    }

    public boolean canDestroy() {
        return !("findByPrimaryKey".equals(this.method.getName()) ? this.isEntityBeanMethod() : Modifier.isAbstract(this.method.getModifiers()) && (this.isGetter(this.method) || this.isSetter(this.method)) && this.isEntityBeanMethod());
    }

    public void destroy() throws IOException {
        ((MDRChangeSource)this.method).removeListener((MDRChangeListener)this);
        this.cmvs.deleteImplMethod(this.method, this.implBean, this.interfaces);
        super.destroy();
    }

    public void change(MDRChangeEvent e) {
        this.fireIconChange();
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> l = new ArrayList<Action>(Arrays.asList(this.getOriginal().getActions(context)));
        return l.toArray(new Action[l.size()]);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    private void refreshImplBean() {
    }

    public void open() {
        this.refreshImplBean();
        OpenCookie cookie = this.cmvs.getOpenCookie(this.method, this.implBean, this.interfaces);
        if (cookie != null) {
            cookie.open();
            Method methodInImplBean = JMIUtils.findInClass(this.method, this.implBean);
            JMIUtils.openInEditor((Element)(methodInImplBean == null ? this.method : methodInImplBean));
        }
    }

    private boolean isEntityBeanMethod() {
        this.refreshImplBean();
        JavaClass entityBean = (JavaClass)((JavaModelPackage)this.implBean.refImmediatePackage()).getJavaClass().resolve("javax.ejb.EntityBean");
        return this.implBean.isSubTypeOf((ClassDefinition)entityBean);
    }

    private boolean isGetter(Method method) {
        boolean isVoid;
        Type type = method.getType();
        boolean bl = isVoid = type instanceof PrimitiveType && ((PrimitiveType)type).getKind().equals(PrimitiveTypeKindEnum.VOID);
        return method.getName().indexOf("get") == 0 && !isVoid && method.getParameters().size() == 0;
    }

    private boolean isSetter(Method method) {
        boolean isVoid;
        Type type = method.getType();
        boolean bl = isVoid = type instanceof PrimitiveType && ((PrimitiveType)type).getKind().equals(PrimitiveTypeKindEnum.VOID);
        return method.getName().indexOf("set") == 0 && isVoid && method.getParameters().size() == 1;
    }
}

