/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.netbeans.lib.editor.util.AbstractCharSequence;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.PriorityDocumentListenerList;

public final class DocumentUtilities {
    private static final Object TYPING_MODIFICATION_DOCUMENT_PROPERTY = new Object();
    public static final Element MODIFICATION_TEXT_ELEMENT = ModificationTextElement.INSTANCE;

    private DocumentUtilities() {
    }

    public static void addDocumentListener(Document doc, DocumentListener listener, DocumentListenerPriority priority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)doc.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.add(listener, priority.getPriority());
        } else {
            doc.addDocumentListener(listener);
        }
    }

    public static void removeDocumentListener(Document doc, DocumentListener listener, DocumentListenerPriority priority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)doc.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.remove(listener, priority.getPriority());
        } else {
            doc.removeDocumentListener(listener);
        }
    }

    public static DocumentListener initPriorityListening(Document doc) {
        if (doc.getProperty(PriorityDocumentListenerList.class) != null) {
            throw new IllegalStateException("PriorityDocumentListenerList already initialized for doc=" + doc);
        }
        PriorityDocumentListenerList instance = new PriorityDocumentListenerList();
        doc.putProperty(PriorityDocumentListenerList.class, instance);
        return instance;
    }

    public static void setTypingModification(Document doc, boolean typingModification) {
        doc.putProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY, typingModification);
    }

    public static boolean isTypingModification(DocumentEvent evt) {
        Boolean b = (Boolean)evt.getDocument().getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return b != null ? b : false;
    }

    public static boolean isTypingModification(Document doc) {
        Boolean b = (Boolean)doc.getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return b != null ? b : false;
    }

    public static CharSequence getText(Document doc) {
        CharSequence text = (CharSequence)doc.getProperty(CharSequence.class);
        if (text == null) {
            text = new DocumentCharSequence(doc);
            doc.putProperty(CharSequence.class, text);
        }
        return text;
    }

    public static CharSequence getText(Document doc, int offset, int length) throws BadLocationException {
        CharSequence text = (CharSequence)doc.getProperty(CharSequence.class);
        if (text == null) {
            text = new DocumentCharSequence(doc);
            doc.putProperty(CharSequence.class, text);
        }
        try {
            return text.subSequence(offset, offset + length);
        }
        catch (IndexOutOfBoundsException e) {
            int badOffset = offset;
            if (offset >= 0 && offset + length > text.length()) {
                badOffset = length;
            }
            throw new BadLocationException(e.getMessage(), badOffset);
        }
    }

    public static String getModificationText(DocumentEvent evt) {
        DocumentEvent.ElementChange change = evt.getChange(MODIFICATION_TEXT_ELEMENT);
        return change != null ? change.toString() : null;
    }

    private static final class ModificationTextElement
    implements Element {
        static final ModificationTextElement INSTANCE = new ModificationTextElement();

        private ModificationTextElement() {
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public Element getElement(int index) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "Helper element for modification text providing";
        }

        public Document getDocument() {
            return null;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class DocumentCharSequence
    extends AbstractCharSequence.StringLike {
        private final Segment segment = new Segment();
        private final Document doc;

        DocumentCharSequence(Document doc) {
            this.doc = doc;
        }

        public int length() {
            return this.doc.getLength();
        }

        public synchronized char charAt(int index) {
            try {
                this.doc.getText(index, 1, this.segment);
            }
            catch (BadLocationException e) {
                throw new IndexOutOfBoundsException(e.getMessage() + " at offset=" + e.offsetRequested());
            }
            return this.segment.array[this.segment.offset];
        }
    }
}

