/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathSupport {
    public static final String ELEMENT_INCLUDED_LIBRARIES = "included-library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set<String> wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;

    public ClassPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] wellKnownPaths, String libraryPrefix, String librarySuffix, String antArtifactPrefix) {
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = wellKnownPaths == null ? null : new HashSet<String>(Arrays.asList(wellKnownPaths));
        this.libraryPrefix = libraryPrefix;
        this.librarySuffix = librarySuffix;
        this.antArtifactPrefix = antArtifactPrefix;
    }

    public Iterator<Item> itemsIterator(String propertyValue, String includedLibrariesElement) {
        return this.itemsList(propertyValue, includedLibrariesElement).iterator();
    }

    public List<Item> itemsList(String propertyValue, String includedLibrariesElement) {
        List includedItems = includedLibrariesElement != null ? ClassPathSupport.getIncludedLibraries(this.antProjectHelper, includedLibrariesElement) : Collections.emptyList();
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<Item> items = new ArrayList<Item>(pe.length);
        for (int i = 0; i < pe.length; ++i) {
            Item item;
            String property = ClassPathSupport.getAntPropertyName(pe[i]);
            if (this.isWellKnownPath(pe[i])) {
                item = Item.create(pe[i], false);
            } else if (this.isLibrary(pe[i])) {
                String libraryName = pe[i].substring(this.libraryPrefix.length(), pe[i].lastIndexOf(46));
                Library library = LibraryManager.getDefault().getLibrary(libraryName);
                item = library == null ? Item.createBroken(1, pe[i], includedItems.contains(property)) : Item.create(library, pe[i], includedItems.contains(property));
            } else if (this.isAntArtifact(pe[i])) {
                Object[] ret = this.referenceHelper.findArtifactAndLocation(pe[i]);
                if (ret[0] == null || ret[1] == null) {
                    item = Item.createBroken(2, pe[i], includedItems.contains(property));
                } else {
                    File artifactFile;
                    AntArtifact artifact = (AntArtifact)ret[0];
                    URI uri = (URI)ret[1];
                    File usedFile = this.antProjectHelper.resolveFile(this.evaluator.evaluate(pe[i]));
                    item = usedFile.equals(artifactFile = new File(artifact.getScriptLocation().toURI().resolve(uri).normalize())) ? Item.create(artifact, uri, pe[i], includedItems.contains(property)) : Item.createBroken(2, pe[i], includedItems.contains(property));
                }
            } else {
                String eval = this.evaluator.evaluate(pe[i]);
                File f = null;
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? Item.createBroken(0, pe[i], includedItems.contains(property)) : Item.create(f, pe[i], includedItems.contains(property));
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator classpath, String includedLibrariesElement) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> includedLibraries = new ArrayList<String>();
        LinkedList<Item> cp = new LinkedList<Item>();
        while (classpath.hasNext()) {
            Item item = (Item)classpath.next();
            cp.add(item);
            String reference = null;
            switch (item.getType()) {
                case 0: {
                    reference = item.getReference();
                    if (item.isBroken() || reference != null) break;
                    File file = item.getFile();
                    reference = this.referenceHelper.createForeignFileReference(file, null);
                    item.setReference(reference);
                    break;
                }
                case 1: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    Library library = item.getLibrary();
                    if (reference != null || library == null) break;
                    reference = this.getLibraryReference(item);
                    item.setReference(reference);
                    break;
                }
                case 2: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    AntArtifact artifact = item.getArtifact();
                    if (reference != null || artifact == null) break;
                    reference = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                    item.setReference(reference);
                    break;
                }
                case 3: {
                    reference = item.getReference();
                }
            }
            if (reference == null) continue;
            result.add(reference);
            if (includedLibrariesElement == null || !item.isIncludedInDeployment()) continue;
            includedLibraries.add(ClassPathSupport.getAntPropertyName(reference));
        }
        if (includedLibrariesElement != null) {
            ClassPathSupport.putIncludedLibraries(includedLibraries, cp, this.antProjectHelper, includedLibrariesElement);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = i < result.size() - 1 ? (String)result.get(i) + ":" : (String)result.get(i);
        }
        return items;
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.libraryPrefix + item.getLibrary().getName() + this.librarySuffix;
    }

    private boolean isWellKnownPath(String property) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(property);
    }

    private boolean isAntArtifact(String property) {
        return this.antArtifactPrefix == null ? false : property.startsWith(this.antArtifactPrefix);
    }

    private boolean isLibrary(String property) {
        if (this.libraryPrefix != null && property.startsWith(this.libraryPrefix)) {
            return this.librarySuffix == null ? true : property.endsWith(this.librarySuffix);
        }
        return false;
    }

    private static List<String> getIncludedLibraries(AntProjectHelper antProjectHelper, String includedLibrariesElement) {
        assert (antProjectHelper != null);
        assert (includedLibrariesElement != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList libs = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", includedLibrariesElement);
        ArrayList<String> libraries = new ArrayList<String>(libs.getLength());
        for (int i = 0; i < libs.getLength(); ++i) {
            Element item = (Element)libs.item(i);
            libraries.add(ClassPathSupport.findText(item));
        }
        return libraries;
    }

    private static void putIncludedLibraries(List<String> libraries, List<Item> classpath, AntProjectHelper antProjectHelper, String includedLibrariesElement) {
        assert (libraries != null);
        assert (antProjectHelper != null);
        assert (includedLibrariesElement != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList libs = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", includedLibrariesElement);
        while (libs.getLength() > 0) {
            Node n = libs.item(0);
            n.getParentNode().removeChild(n);
        }
        Document doc = data.getOwnerDocument();
        for (String libraryName : libraries) {
            for (Item item : classpath) {
                String libraryPropName = "${" + libraryName + "}";
                if (!libraryPropName.equals(item.getReference())) continue;
                data.appendChild(ClassPathSupport.createLibraryElement(doc, libraryName, item, includedLibrariesElement));
            }
        }
        antProjectHelper.putPrimaryConfigurationData(data, true);
    }

    private static Element createLibraryElement(Document doc, String pathItem, Item item, String includedLibrariesElement) {
        Element libraryElement = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", includedLibrariesElement);
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        AppClientProjectProperties.getFilesForItem(item, files, dirs);
        if (files.size() > 0) {
            libraryElement.setAttribute(ATTR_FILES, "" + files.size());
        }
        if (dirs.size() > 0) {
            libraryElement.setAttribute(ATTR_DIRS, "" + dirs.size());
        }
        libraryElement.appendChild(doc.createTextNode(pathItem));
        return libraryElement;
    }

    private static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static boolean relativizeLibraryClassPath(EditableProperties ep, AntProjectHelper aph, String libCpProperty) {
        String value = PropertyUtils.getGlobalProperties().getProperty(libCpProperty);
        if (value == null) {
            return false;
        }
        String[] paths = PropertyUtils.tokenizePath((String)value);
        StringBuffer sb = new StringBuffer();
        File projectDir = FileUtil.toFile((FileObject)aph.getProjectDirectory());
        for (int i = 0; i < paths.length; ++i) {
            File f = aph.resolveFile(paths[i]);
            if (!CollocationQuery.areCollocated((File)f, (File)projectDir)) {
                return false;
            }
            sb.append(PropertyUtils.relativizeFile((File)projectDir, (File)f));
            if (i + 1 >= paths.length) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() == 0) {
            return false;
        }
        ep.setProperty(libCpProperty, sb.toString());
        ep.setComment(libCpProperty, new String[]{"# Property " + libCpProperty + " is set here just to make sharing of project simpler.", "# The library definition has always preference over this property."}, false);
        return true;
    }

    public static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        private boolean includedInDeployment;
        private String raw;

        private Item(int type, Object object, String property, boolean included, String raw) {
            this.type = type;
            this.object = object;
            this.property = property;
            this.includedInDeployment = included;
            this.raw = raw;
        }

        private Item(int type, Object object, URI artifactURI, String property, boolean included) {
            this(type, object, property, included, null);
            this.artifactURI = artifactURI;
        }

        public static Item create(Library library, String property, boolean included) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            String libraryName = library.getName();
            return new Item(1, (Object)library, property, included, "${libs." + libraryName + ".classpath}");
        }

        public static Item create(AntArtifact artifact, URI artifactURI, String property, boolean included) {
            if (artifactURI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, (Object)artifact, artifactURI, property, included);
        }

        public static Item create(File file, String property, boolean included) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, (Object)file, property, included, null);
        }

        public static Item create(String property, boolean included) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, property, included, null);
        }

        public static Item createBroken(int type, String property, boolean included) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(type, (Object)BROKEN, property, included, null);
        }

        public String getRaw() {
            return this.raw;
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (this.isBroken()) {
                return null;
            }
            return (Library)this.object;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            if (this.isBroken()) {
                return null;
            }
            return (File)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            if (this.isBroken()) {
                return null;
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public String getReference() {
            return this.property;
        }

        public void setReference(String property) {
            this.property = property;
        }

        public boolean isIncludedInDeployment() {
            return this.includedInDeployment;
        }

        public void setIncludedInDeployment(boolean includedInDeployment) {
            this.includedInDeployment = includedInDeployment;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public String toString() {
            return "artifactURI=" + this.artifactURI + ", type=" + this.type + ", property=" + this.property + ", includedInDeployment=" + this.includedInDeployment + ", raw=" + this.raw + ", object=" + this.object;
        }

        public int hashCode() {
            int hash = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 2: {
                    hash += this.getArtifact().getType().hashCode();
                    hash += this.getArtifact().getScriptLocation().hashCode();
                    hash += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash += this.object.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object itemObject) {
            if (!(itemObject instanceof Item)) {
                return false;
            }
            Item item = (Item)itemObject;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }
    }
}

