/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;

public class Utils {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    public static String toClasspathString(File[] classpathEntries) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpath.append(classpathEntries[i].getAbsolutePath());
            if (i + 1 >= classpathEntries.length) continue;
            classpath.append(':');
        }
        return classpath.toString();
    }

    public static AppClient getAppClient(AppClientProject project) {
        AppClient result = null;
        try {
            Car apiCar = project.getAPICar();
            if (apiCar.getDeploymentDescriptor() != null || apiCar.getJ2eePlatformVersion().equals("1.5")) {
                result = DDProvider.getDefault().getMergedDDRoot((MetadataUnit)apiCar);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return result;
    }

    private static void setSteps(WizardDescriptor.Panel[] panels, String[] steps, String[] resultSteps, int offset) {
        int n = steps == null ? 0 : steps.length;
        for (int i = 0; i < panels.length; ++i) {
            String step;
            JComponent component = (JComponent)panels[i].getComponent();
            String string = step = i < n ? steps[i] : null;
            if (step == null) {
                step = component.getName();
            }
            component.putClientProperty(WIZARD_PANEL_CONTENT_DATA, resultSteps);
            component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, i);
            component.getAccessibleContext().setAccessibleDescription(step);
            resultSteps[i + offset] = step;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panels, String[] steps) {
        Utils.setSteps(panels, steps, steps, 0);
    }
}

