/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import org.netbeans.modules.xml.catalog.Util;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class CatalogEntry {
    private final String publicID;
    private final CatalogReader catalog;

    public CatalogEntry(String publicID, CatalogReader catalog) {
        this.publicID = publicID;
        this.catalog = catalog;
    }

    CatalogReader getCatalog() {
        return this.catalog;
    }

    public String getSystemID() {
        String patchedSystemId;
        String sid = this.catalog.getSystemID(this.publicID);
        if (sid == null && this.catalog instanceof EntityResolver) {
            try {
                InputSource in = ((EntityResolver)((Object)this.catalog)).resolveEntity(this.publicID, null);
                if (in != null) {
                    sid = in.getSystemId();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((patchedSystemId = sid) != null) {
            patchedSystemId = patchedSystemId.replaceAll("\\+", "%20");
            patchedSystemId = patchedSystemId.replaceAll("\\ ", "%20");
            return patchedSystemId;
        }
        return null;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getPublicIDValue() {
        String id = this.getPublicID();
        if (id.startsWith("PUBLIC:")) {
            return id.substring(7);
        }
        if (id.startsWith("URI:")) {
            return id.substring(4);
        }
        if (id.startsWith("SYSTEM:")) {
            return "";
        }
        if (id.startsWith("SCHEMA:")) {
            return "";
        }
        return id;
    }

    public String getSystemIDValue() {
        String id = this.getPublicID();
        if (id.startsWith("SYSTEM:")) {
            return id.substring(7);
        }
        if (id.startsWith("SCHEMA:")) {
            return id.substring(7);
        }
        return "";
    }

    public String getUriValue() {
        return this.getSystemID();
    }

    public String getName() {
        String id = this.getPublicID();
        if (id.startsWith("PUBLIC:")) {
            return Util.THIS.getString("TXT_publicEntry", id.substring(7));
        }
        if (id.startsWith("SYSTEM:")) {
            return Util.THIS.getString("TXT_systemEntry", id.substring(7));
        }
        if (id.startsWith("URI:")) {
            return Util.THIS.getString("TXT_publicEntry", id.substring(4));
        }
        if (id.startsWith("SCHEMA:")) {
            return Util.THIS.getString("TXT_systemEntry", id.substring(7));
        }
        return Util.THIS.getString("TXT_publicEntry", id);
    }

    public String toString() {
        return this.publicID + " => " + this.getSystemID();
    }
}

