/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicApplication;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class EarDeploymentConfiguration
extends WLDeploymentConfiguration {
    private File file;
    private WeblogicApplication weblogicApplication;

    public EarDeploymentConfiguration(DeployableObject deployableObject) {
        super(deployableObject);
    }

    public void init(File file) {
        this.file = file;
        this.getWeblogicApplication();
        if (this.dataObject == null) {
            try {
                this.dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
    }

    public synchronized WeblogicApplication getWeblogicApplication() {
        if (this.weblogicApplication == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicApplication = WeblogicApplication.createGraph(this.file);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.weblogicApplication = this.genereateweblogicApplication();
                    this.writefile(this.file, this.weblogicApplication);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.weblogicApplication;
    }

    public void save(OutputStream os) throws ConfigurationException {
        WeblogicApplication weblogicApplication = this.getWeblogicApplication();
        if (weblogicApplication == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            weblogicApplication.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    private WeblogicApplication genereateweblogicApplication() {
        return new WeblogicApplication();
    }
}

