/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.xam.XDMAccess;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMListener
implements PropertyChangeListener {
    private AbstractDocumentModel model;
    private boolean inSync;
    private Document oldDocument;
    private Map<Integer, SyncUnit> syncUnits = new HashMap<Integer, SyncUnit>();

    public XDMListener(AbstractDocumentModel model) {
        this.model = model;
    }

    private XDMModel getXDMModel() {
        return ((XDMAccess)this.model.getAccess()).getXDMModel();
    }

    void startSync() {
        this.inSync = true;
        this.syncUnits.clear();
        this.oldDocument = this.getXDMModel().getCurrentDocument();
        this.getXDMModel().addPropertyChangeListener(this);
    }

    Document getOldDocument() {
        return this.oldDocument;
    }

    void endSync() {
        this.endSync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endSync(boolean processing) {
        this.getXDMModel().removePropertyChangeListener(this);
        try {
            if (processing) {
                for (SyncUnit unit : this.syncUnits.values()) {
                    this.model.processSyncUnit(unit);
                }
            }
        }
        finally {
            this.syncUnits.clear();
            this.inSync = false;
        }
    }

    private static Integer getID(ChangeInfo change) {
        if (change.getParent() == null) {
            return 0;
        }
        org.netbeans.modules.xml.xdm.nodes.Element parent = (org.netbeans.modules.xml.xdm.nodes.Element)change.getParent();
        return parent.getId();
    }

    private static Integer getID(DocumentComponent c) {
        if (c == null) {
            return 0;
        }
        org.netbeans.modules.xml.xdm.nodes.Element xdmElement = (org.netbeans.modules.xml.xdm.nodes.Element)((AbstractDocumentComponent)c).getPeer();
        return xdmElement.getId();
    }

    protected void processChange(ChangeInfo change) {
        Integer unitID = XDMListener.getID(change);
        SyncUnit existing = this.syncUnits.get(unitID);
        SyncUnit su = this.model.prepareSyncUnit(change, existing);
        if (su == null) {
            return;
        }
        Integer reviewedID = XDMListener.getID(su.getTarget());
        existing = this.syncUnits.get(reviewedID);
        if (existing == null) {
            if (unitID.equals(reviewedID)) {
                this.syncUnits.put(reviewedID, su);
            } else {
                existing = this.syncUnits.get(reviewedID);
                if (existing != null) {
                    existing.merge(su);
                } else {
                    this.syncUnits.put(reviewedID, su);
                }
            }
        } else if (existing != su) {
            if (unitID.equals(reviewedID)) {
                existing.merge(su);
            } else {
                this.syncUnits.remove(unitID);
                existing = this.syncUnits.get(reviewedID);
                if (existing != null) {
                    existing.merge(su);
                } else {
                    this.syncUnits.put(reviewedID, su);
                }
            }
        }
    }

    protected void processEvent(Node eventNode, List<Node> pathToRoot, boolean isAdded) {
        if (pathToRoot.size() == 1) {
            assert (pathToRoot.get(0) instanceof Document);
            if (!(eventNode instanceof org.netbeans.modules.xml.xdm.nodes.Element)) {
                return;
            }
            assert (eventNode.getId() == 1);
            if (!isAdded) {
                return;
            }
            DocumentComponent rootComponent = null;
            String errorMessage = null;
            try {
                rootComponent = this.model.createRootComponent((Element)((org.netbeans.modules.xml.xdm.nodes.Element)eventNode));
            }
            catch (IllegalArgumentException e) {
                errorMessage = e.getMessage();
            }
            if (rootComponent == null) {
                errorMessage = errorMessage != null ? errorMessage : "Unexpected root element " + AbstractDocumentComponent.getQName((org.w3c.dom.Node)eventNode);
                throw new IllegalArgumentException(new IOException(errorMessage));
            }
            this.model.firePropertyChangeEvent(new PropertyChangeEvent(this.model, "state", Model.State.NOT_SYNCED, Model.State.VALID));
        } else {
            assert (eventNode.getId() != pathToRoot.get(0).getId()) : "event node has same id as parent";
            pathToRoot = new ArrayList<Node>(pathToRoot);
            pathToRoot.add(0, eventNode);
            ChangeInfo change = this.model.prepareChangeInfo(XDMListener.toDomNodes(pathToRoot));
            change.setAdded(isAdded);
            this.processChange(change);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Node now;
        if (!this.inSync) {
            return;
        }
        NodeInfo oldInfo = (NodeInfo)event.getOldValue();
        NodeInfo newInfo = (NodeInfo)event.getNewValue();
        Node old = oldInfo != null ? oldInfo.getNode() : null;
        Node node = now = newInfo != null ? newInfo.getNode() : null;
        if (old != null) {
            this.processEvent(old, oldInfo.getNewAncestors(), false);
        }
        if (now != null) {
            this.processEvent(now, newInfo.getNewAncestors(), true);
        }
    }

    static List<org.w3c.dom.Node> toDomNodes(List<Node> nodes) {
        ArrayList<org.w3c.dom.Node> domNodes = new ArrayList<org.w3c.dom.Node>();
        for (Node n : nodes) {
            domNodes.add(n);
        }
        return domNodes;
    }
}

