/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class DefaultSettings
implements Settings,
ModelListener,
CategoryListener,
Runnable {
    private static final String SETTINGS_ROOT_FOLDER = "PaletteSettings";
    private static final String NODE_ATTR_PREFIX = "psa_";
    private static final String NULL_VALUE = "null";
    private static final String XML_ROOT = "root";
    private static final String XML_CATEGORY = "category";
    private static final String XML_ITEM = "item";
    private static final String XML_ATTR_NAME = "name";
    private static final String[] KNOWN_PROPERTIES;
    private static final int ICON_SIZE_ATTR_INDEX = 0;
    private static final int IS_EXPANDED_ATTR_INDEX = 1;
    private static final int IS_VISIBLE_ATTR_INDEX = 2;
    private static final int SHOW_ITEM_NAMES_ATTR_INDEX = 3;
    private Model model;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private FileLock settingsFileLock;
    private RequestProcessor requestProcessor = new RequestProcessor("PaletteSettings");
    private static Logger ERR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultSettings(Model model) {
        this.model = model;
        model.addModelListener(this);
        Category[] categories = model.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            categories[i].addCategoryListener(this);
        }
        this.load();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public boolean isVisible(Item item) {
        Node node = this.getNode(item.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Item item, boolean visible) {
        Node node = this.getNode(item.getLookup());
        this.set(node, "isVisible", visible, true);
    }

    public boolean isVisible(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Category category, boolean visible) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isVisible", visible, true);
    }

    public boolean isNodeVisible(Node node) {
        return this.get(node, "isVisible", true);
    }

    public void setNodeVisible(Node node, boolean visible) {
        this.set(node, "isVisible", visible, true);
    }

    public boolean isExpanded(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isExpanded", false);
    }

    public void setExpanded(Category category, boolean expanded) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isExpanded", expanded, false);
    }

    public int getIconSize() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "iconSize", 1);
    }

    public void setIconSize(int iconSize) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "iconSize", iconSize, 1);
    }

    public void setShowItemNames(boolean showNames) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "showItemNames", showNames, true);
    }

    public boolean getShowItemNames() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "showItemNames", true);
    }

    private Node getNode(Lookup lkp) {
        return (Node)lkp.lookup(Node.class);
    }

    private boolean get(Node node, String attrName, boolean defaultValue) {
        Object value = this.get(node, attrName, (Object)defaultValue);
        return null == value ? defaultValue : Boolean.valueOf(value.toString());
    }

    private int get(Node node, String attrName, int defaultValue) {
        Object value = this.get(node, attrName, new Integer(defaultValue));
        try {
            if (null != value) {
                return Integer.parseInt(value.toString());
            }
        }
        catch (NumberFormatException nfE) {
            // empty catch block
        }
        return defaultValue;
    }

    private Object get(Node node, String attrName, Object defaultValue) {
        Object res = null;
        if (null != node && (null == (res = node.getValue(NODE_ATTR_PREFIX + attrName)) || NULL_VALUE.equals(res))) {
            res = this.getNodeDefaultValue(node, attrName);
        }
        if (null == res) {
            res = defaultValue;
        }
        return res;
    }

    private Object getNodeDefaultValue(Node node, String attrName) {
        DataObject dobj;
        Object res = node.getValue(attrName);
        if (null == res && null != (dobj = (DataObject)node.getCookie(DataObject.class))) {
            res = dobj.getPrimaryFile().getAttribute(attrName);
        }
        return res;
    }

    private void set(Node node, String attrName, boolean newValue, boolean defaultValue) {
        this.set(node, attrName, (Object)newValue, (Object)defaultValue);
    }

    private void set(Node node, String attrName, int newValue, int defaultValue) {
        this.set(node, attrName, new Integer(newValue), new Integer(defaultValue));
    }

    private void set(Node node, String attrName, Object newValue, Object defaultValue) {
        if (null == node) {
            return;
        }
        Object oldValue = this.get(node, attrName, defaultValue);
        if (oldValue.equals(newValue)) {
            return;
        }
        node.setValue(NODE_ATTR_PREFIX + attrName, newValue);
        this.requestProcessor.post((Runnable)this);
        this.propertySupport.firePropertyChange(attrName, oldValue, newValue);
    }

    public void categoryModified(Category src) {
        this.requestProcessor.post((Runnable)this);
    }

    public void run() {
        this.store();
    }

    public void categoriesRemoved(Category[] removedCategories) {
        for (int i = 0; i < removedCategories.length; ++i) {
            removedCategories[i].removeCategoryListener(this);
        }
        this.requestProcessor.post((Runnable)this);
    }

    public void categoriesAdded(Category[] addedCategories) {
        for (int i = 0; i < addedCategories.length; ++i) {
            addedCategories[i].addCategoryListener(this);
        }
        this.requestProcessor.post((Runnable)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void categoriesReordered() {
    }

    private void load() {
        try {
            FileObject fo = this.findSettingsFile();
            if (null == fo || !fo.isValid() || !fo.canRead()) {
                return;
            }
            XMLReader reader = XMLUtil.createXMLReader();
            SettingsHandler handler = new SettingsHandler();
            reader.setContentHandler(handler);
            InputStream stream = null;
            try {
                stream = fo.getInputStream();
            }
            catch (FileNotFoundException fnfE) {
                // empty catch block
            }
            if (null == stream) {
                return;
            }
            InputSource input = new InputSource(stream);
            reader.parse(input);
            stream.close();
        }
        catch (SAXException saxE) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_LoadSettings"), saxE);
        }
        catch (IOException ioE) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_LoadSettings"), ioE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void store() {
        long startTime = System.currentTimeMillis();
        Node root = (Node)this.model.getRoot().lookup(Node.class);
        if (!$assertionsDisabled && null == root) {
            throw new AssertionError();
        }
        try {
            FileObject fo = this.findSettingsFile();
            if (null == fo) {
                fo = this.createSettingsFile();
            }
            if (null == fo) {
                return;
            }
            DefaultSettings defaultSettings = this;
            synchronized (defaultSettings) {
                if (null != this.settingsFileLock) return;
                this.settingsFileLock = fo.lock();
            }
            PrintWriter writer = new PrintWriter(fo.getOutputStream(this.settingsFileLock));
            writer.print("<root ");
            this.printAttributes(writer, root);
            writer.println('>');
            Node[] categories = root.getChildren().getNodes();
            for (int i = 0; i < categories.length; ++i) {
                this.printCategory(writer, categories[i]);
            }
            writer.println("</root>");
            writer.close();
            return;
        }
        catch (IOException ioE) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_StoreSettings"), ioE);
            return;
        }
        finally {
            if (null != this.settingsFileLock) {
                this.settingsFileLock.releaseLock();
            }
            this.settingsFileLock = null;
        }
    }

    private void printCategory(PrintWriter writer, Node category) {
        writer.print("\t<category ");
        this.printAttributes(writer, category);
        writer.println('>');
        Node[] items = category.getChildren().getNodes();
        for (int i = 0; i < items.length; ++i) {
            this.printItem(writer, items[i]);
        }
        writer.println("\t</category>");
    }

    private void printItem(PrintWriter writer, Node item) {
        boolean hasAttributes = false;
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            if (null == item.getValue(KNOWN_PROPERTIES[i])) continue;
            hasAttributes = true;
            break;
        }
        if (!hasAttributes) {
            return;
        }
        writer.print("\t\t<item ");
        this.printAttributes(writer, item);
        writer.println(" />");
    }

    private void printAttributes(PrintWriter writer, Node node) {
        writer.print(" name=\"");
        writer.print(node.getName());
        writer.print("\" ");
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            Object value = node.getValue(KNOWN_PROPERTIES[i]);
            if (null == value || NULL_VALUE.equals(value)) continue;
            writer.print(KNOWN_PROPERTIES[i]);
            writer.print("=\"");
            writer.print(value.toString());
            writer.print("\" ");
        }
    }

    private FileObject findSettingsFile() throws IOException {
        FileObject settingsRoot = this.findOrCreateSettingsFolder();
        return settingsRoot.getFileObject(this.model.getName(), "settings");
    }

    private FileObject createSettingsFile() throws IOException {
        FileObject settingsRoot = this.findOrCreateSettingsFolder();
        FileObject res = settingsRoot.getFileObject(this.model.getName(), "settings");
        if (null == res) {
            try {
                res = settingsRoot.createData(this.model.getName(), "settings");
            }
            catch (FileNotFoundException fnfE) {
                return null;
            }
        }
        return res;
    }

    private FileObject findOrCreateSettingsFolder() throws IOException {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject settingsRoot = fs.findResource(SETTINGS_ROOT_FOLDER);
        if (null == settingsRoot) {
            settingsRoot = fs.getRoot().createFolder(SETTINGS_ROOT_FOLDER);
        }
        return settingsRoot;
    }

    public int getItemWidth() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "itemWidth", -1);
    }

    static {
        $assertionsDisabled = !DefaultSettings.class.desiredAssertionStatus();
        KNOWN_PROPERTIES = new String[]{"psa_iconSize", "psa_isExpanded", "psa_isVisible", "psa_showItemNames"};
        ERR = Logger.getLogger("org.netbeans.modules.palette");
    }

    private class SettingsHandler
    extends DefaultHandler {
        private Node currentCategory = null;
        private Node rootNode;

        private SettingsHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Node item;
            String itemName;
            if (DefaultSettings.XML_ROOT.equals(qName)) {
                Node root = this.getRoot();
                this.extractAttribute(root, 3, attributes);
                this.extractAttribute(root, 0, attributes);
            } else if (DefaultSettings.XML_CATEGORY.equals(qName)) {
                Node root;
                Node category;
                String catName = attributes.getValue(DefaultSettings.XML_ATTR_NAME);
                if (null != catName && null != (category = (root = this.getRoot()).getChildren().findChild(catName))) {
                    this.currentCategory = category;
                    this.extractAttribute(category, 1, attributes);
                    this.extractAttribute(category, 2, attributes);
                }
            } else if (DefaultSettings.XML_ITEM.equals(qName) && null != (itemName = attributes.getValue(DefaultSettings.XML_ATTR_NAME)) && null != this.currentCategory && null != (item = this.currentCategory.getChildren().findChild(itemName))) {
                this.extractAttribute(item, 2, attributes);
            }
        }

        private void extractAttribute(Node node, int attrIndex, Attributes attributes) {
            if (null == node) {
                return;
            }
            String attrName = KNOWN_PROPERTIES[attrIndex];
            String value = attributes.getValue(attrName);
            if (null != value) {
                node.setValue(attrName, (Object)value);
            }
        }

        private Node getRoot() {
            if (null == this.rootNode) {
                this.rootNode = (Node)DefaultSettings.this.model.getRoot().lookup(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultSettings.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            }
            return this.rootNode;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (DefaultSettings.XML_CATEGORY.equals(qName)) {
                this.currentCategory = null;
            }
        }
    }
}

