/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabCellRenderer;
import org.openide.awt.HtmlRenderer;

public final class WinClassicViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final Color GTK_TABBED_PANE_BACKGROUND_1 = new Color(100, 100, 100);
    private static final Color GTK_TABBED_PANE_BACKGROUND_2 = new Color(255, 255, 255);
    private static final int BUMP_X_PAD = isGenericUI ? 0 : 3;
    private static final int BUMP_WIDTH = isGenericUI ? 0 : 3;
    private static final int TXT_X_PAD = isGenericUI ? 3 : BUMP_X_PAD + BUMP_WIDTH + 5;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 1;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinClassicViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinClassicViewTabDisplayerUI((TabDisplayer)c);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 19 : fm.getAscent() + 2 * fm.getDescent() + 2;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics g, JComponent c) {
        ColorUtil.setupAntialiasing(g);
        Color col = c.getBackground();
        if (col != null) {
            g.setColor(col);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paintOverallBorder(g, c);
        super.paint(g, c);
    }

    protected void paintOverallBorder(Graphics g, JComponent c) {
        if (isGenericUI) {
            return;
        }
        Rectangle r = c.getBounds();
        g.setColor(UIManager.getColor("InternalFrame.borderDarkShadow"));
        g.drawLine(0, r.height - 1, r.width - 1, r.height - 1);
    }

    protected Font getTxtFont() {
        Font result;
        if (isGenericUI && (result = UIManager.getFont("controlFont")) != null) {
            return result;
        }
        return super.getTxtFont();
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        --height;
        y -= 2;
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int txtWidth = width;
        if (this.isSelected(index)) {
            int space4Pin;
            AbstractViewTabDisplayerUI.PinButton pin = this.configurePinButton(index);
            boolean showPin = pin != null && pin.getOrientation() != TabDisplayer.ORIENTATION_INVISIBLE;
            int n = space4Pin = showPin ? this.pinButton.getWidth() + 1 : 0;
            if (this.displayer.isShowCloseButton()) {
                if (closeIcon == null) {
                    closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
                }
                String iconPath = this.findIconPath(index);
                Icon icon = closeIcon.obtainIcon(iconPath);
                int iconWidth = icon.getIconWidth();
                int space4Icon = iconWidth + 2 + space4Pin;
                txtWidth = width - space4Icon - TXT_X_PAD;
                this.getCloseIconRect(this.tempRect, index);
                icon.paintIcon(this.getDisplayer(), g, this.tempRect.x, this.tempRect.y);
            } else {
                this.tempRect.x = x + (width - 2);
                this.tempRect.y = !showPin ? 0 : this.displayer.getHeight() / 2 - this.pinButton.getPreferredSize().height / 2;
                txtWidth = width - 2 * TXT_X_PAD;
            }
            if (showPin) {
                if (this.tempRect.x - space4Pin < x + TXT_X_PAD - 1) {
                    this.pinButton.setVisible(false);
                } else {
                    this.pinButton.setVisible(true);
                    this.pinButton.setLocation(this.tempRect.x - space4Pin, this.tempRect.y);
                }
            } else if (this.pinButton != null) {
                this.pinButton.setVisible(false);
            }
        } else {
            txtWidth = width - 2 * TXT_X_PAD;
        }
        this.drawBump(g, index, x + 4, y + 6, BUMP_WIDTH, height - 8);
        Color txtC = UIManager.getColor("TabbedPane.foreground");
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + TXT_X_PAD), (int)(y + fm.getAscent() + 3), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)txtC, (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
        boolean isSelected = this.isSelected(index);
        g.translate(x, y);
        g.setColor(UIManager.getColor("InternalFrame.borderShadow"));
        g.drawLine(0, --height - 1, width - 2, height - 1);
        g.drawLine(width - 1, height - 1, width - 1, 0);
        g.setColor(isSelected ? UIManager.getColor("InternalFrame.borderHighlight") : UIManager.getColor("InternalFrame.borderLight"));
        g.drawLine(0, 0, 0, height - 1);
        g.drawLine(1, 0, width - 2, 0);
        g.translate(-x, -y);
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        ((Graphics2D)g).setPaint(this.getBackgroundPaint(g, index, x, y, width, --height));
        if (this.isFocused(index)) {
            g.fillRect(x, y, width, height);
        } else {
            g.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
    }

    private Paint getBackgroundPaint(Graphics g, int index, int x, int y, int width, int height) {
        boolean selected = this.isSelected(index);
        boolean focused = this.isFocused(index);
        boolean attention = this.isAttention(index);
        Paint result = null;
        result = focused && !attention ? ColorUtil.getGradientPaint(x, y, WinClassicViewTabDisplayerUI.getSelGradientColor(), x + width, y, WinClassicViewTabDisplayerUI.getSelGradientColor2()) : (selected && !attention ? UIManager.getColor("TabbedPane.background") : (attention ? WinClassicEditorTabCellRenderer.ATTENTION_COLOR : UIManager.getColor("tab_unsel_fill")));
        return result;
    }

    private String findIconPath(int index) {
        if (this.controller.isClosePressed() == index) {
            return "org/netbeans/swing/tabcontrol/resources/win_bigclose-pressed.gif";
        }
        if (this.controller.isMouseInCloseButton() == index) {
            return "org/netbeans/swing/tabcontrol/resources/win_bigclose-rollover.gif";
        }
        return "org/netbeans/swing/tabcontrol/resources/win_bigclose-normal.gif";
    }

    private void drawBump(Graphics g, int index, int x, int y, int width, int height) {
        Color shadowC;
        Color highlightC;
        Color bodyC;
        if (isGenericUI) {
            return;
        }
        if (this.isFocused(index)) {
            bodyC = new Color(210, 220, 243);
            highlightC = bodyC.brighter();
            shadowC = bodyC.darker();
        } else if (this.isSelected(index)) {
            highlightC = UIManager.getColor("InternalFrame.borderHighlight");
            bodyC = UIManager.getColor("InternalFrame.borderLight");
            shadowC = UIManager.getColor("InternalFrame.borderShadow");
        } else {
            highlightC = UIManager.getColor("InternalFrame.borderLight");
            bodyC = UIManager.getColor("tab_unsel_fill");
            shadowC = UIManager.getColor("InternalFrame.borderShadow");
        }
        int i = 0;
        while (i < width / 3) {
            g.setColor(highlightC);
            g.drawLine(x, y, x, y + height - 1);
            g.drawLine(x, y, x + 1, y);
            g.setColor(bodyC);
            g.drawLine(x + 1, y + 1, x + 1, y + height - 2);
            g.setColor(shadowC);
            g.drawLine(x + 2, y, x + 2, y + height - 1);
            g.drawLine(x, y + height - 1, x + 1, y + height - 1);
            ++i;
            x += 3;
        }
    }

    private Rectangle getCloseIconRect(Rectangle rect, int index) {
        TabLayoutModel tlm = this.getLayoutModel();
        int x = tlm.getX(index);
        int w = tlm.getW(index);
        String iconPath = this.findIconPath(index);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(iconPath);
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        rect.x = x + w - iconWidth - 2;
        rect.y = this.getCenteredIconY(icon, index) - 1;
        rect.width = iconWidth;
        rect.height = iconHeight;
        return rect;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> normalIcons = new HashMap<Object, String>(6);
        normalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-east.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-west.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-south.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-center.gif");
        HashMap<Object, String> pressedIcons = new HashMap<Object, String>(6);
        pressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-east.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-west.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-south.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-center.gif");
        HashMap<Object, String> rolloverIcons = new HashMap<Object, String>(6);
        rolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-east.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-west.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-south.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-center.gif");
        return new AbstractViewTabDisplayerUI.PinButton(normalIcons, pressedIcons, rolloverIcons);
    }

    private static final Color getSelGradientColor() {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            return GTK_TABBED_PANE_BACKGROUND_1;
        }
        return UIManager.getColor("winclassic_tab_sel_gradient");
    }

    private static final Color getSelGradientColor2() {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            return GTK_TABBED_PANE_BACKGROUND_2;
        }
        return UIManager.getColor("TabbedPane.background");
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            if (!WinClassicViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int index = WinClassicViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (index < 0 || !WinClassicViewTabDisplayerUI.this.isSelected(index)) {
                return -1;
            }
            return WinClassicViewTabDisplayerUI.this.getCloseIconRect(WinClassicViewTabDisplayerUI.this.tempRect, index).contains(point) ? index : -1;
        }

        protected boolean inPinButtonRect(Point p) {
            if (WinClassicViewTabDisplayerUI.this.pinButton == null || !WinClassicViewTabDisplayerUI.this.pinButton.isVisible()) {
                return false;
            }
            Point p2 = SwingUtilities.convertPoint(WinClassicViewTabDisplayerUI.this.displayer, p, WinClassicViewTabDisplayerUI.this.pinButton);
            return WinClassicViewTabDisplayerUI.this.pinButton.contains(p2);
        }
    }
}

