/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.openide.awt.HtmlRenderer;
import org.openide.windows.TopComponent;

public final class AquaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_LEFT_PAD = 5;
    private static final int ICON_X_RIGHT_PAD = 2;
    private static final int BUMP_X_PAD = 5;
    private static final int BUMP_Y_PAD = 4;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();
    private Rectangle pinButtonRect = new Rectangle();
    private static final ChicletWrapper chiclet = new ChicletWrapper();
    private boolean containsMouse = false;

    private AquaViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaViewTabDisplayerUI((TabDisplayer)c);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    protected void installPinButton() {
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 21 : fm.getAscent() + 2 * fm.getDescent() + 3;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics g, JComponent c) {
        ColorUtil.setupAntialiasing(g);
        super.paint(g, c);
        this.paintBottomBorder(g, c);
    }

    protected Font getTxtFont() {
        return this.getDisplayer().getFont();
    }

    private void paintBottomBorder(Graphics g, JComponent c) {
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int textW = width;
        if (this.isContainsMouse()) {
            int space4Pin;
            int iconX;
            int iconY;
            int iconWidth = 5;
            int iconHeight = 5;
            AbstractViewTabDisplayerUI.PinButton pinButton = this.configurePinButton(index);
            int gap = 2;
            if (this.displayer.isShowCloseButton()) {
                iconY = iconHeight > height ? -1 * ((iconHeight - height) / 2) : height / 2 - iconHeight / 2;
                iconX = x + width - (iconWidth + gap);
                if (index == this.getDataModel().size() - 1) {
                    iconX -= 3;
                    textW -= 3;
                }
                g.setColor(this.isSelected(index) && this.isActive() ? new Color(80, 80, 123) : new Color(110, 120, 120));
                g.drawLine(iconX -= 2, --iconY, iconX + iconWidth, iconY + iconHeight);
                g.drawLine(iconX, iconY + iconHeight, iconX + iconWidth, iconY);
                g.drawLine(iconX, ++iconY, iconX + iconWidth, iconY + iconHeight);
                g.drawLine(iconX, iconY + iconHeight, iconX + iconWidth, iconY);
            } else {
                iconWidth = 0;
                iconX = x + width - gap;
                iconY = iconHeight > height ? -1 * ((iconHeight - height) / 2) : height / 2 - iconHeight / 2 - 1;
                this.tempRect.x = iconX;
            }
            int n = space4Pin = pinButton != null ? pinButton.getWidth() + 1 : 0;
            if (pinButton != null && this.isSelected(index)) {
                if (this.tempRect.x - space4Pin <= x) {
                    this.pinButtonRect.setBounds(0, 0, 0, 0);
                } else {
                    Icon ic = pinButton.getIcon();
                    if (ic != null) {
                        this.pinButtonRect.setBounds(iconX - space4Pin, iconY - 4, ic.getIconWidth(), ic.getIconHeight());
                        ic.paintIcon(this.displayer, g, this.pinButtonRect.x, this.pinButtonRect.y);
                    } else {
                        this.pinButtonRect.setBounds(0, 0, 0, 0);
                    }
                }
            }
            textW -= iconWidth + 7 + space4Pin;
        }
        if (text.length() == 0) {
            return;
        }
        int textHeight = fm.getHeight();
        int textX = index == 0 ? x + 10 : x + 5;
        int textY = textHeight > height ? -1 * ((textHeight - height) / 2) + fm.getAscent() - 1 : height / 2 - textHeight / 2 + fm.getAscent();
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)textX, (int)textY, (int)(textW -= 5), (int)height, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        boolean first = index == 0;
        boolean last = index == this.getDataModel().size() - 1;
        int state = 0;
        if (this.isActive()) {
            state |= 4;
        }
        if (this.isSelected(index)) {
            state |= 2;
        }
        if (this.isAttention(index)) {
            state |= 0x10;
        }
        chiclet.setState(state);
        chiclet.setBounds(x, ++y, width, height);
        chiclet.setArcs(first ? 0.5f : 0.0f, last ? 0.5f : 0.0f, first ? 0.0f : 0.0f, last ? 0.0f : 0.0f);
        chiclet.setNotch(false, false);
        g.translate(x, y);
        chiclet.draw((Graphics2D)g);
        g.translate(-x, -y);
    }

    private Rectangle getCloseIconRect(Rectangle rect, int index) {
        if (!this.displayer.isShowCloseButton()) {
            rect.x = -2;
            rect.y = -2;
            rect.width = 0;
            rect.height = 0;
            return rect;
        }
        FontMetrics fm = this.getTxtFontMetrics();
        Object text2Paint = null;
        int width = this.getLayoutModel().getW(index);
        int x = this.getLayoutModel().getX(index);
        int height = this.getLayoutModel().getH(index);
        int iconWidth = 5;
        int iconHeight = 5;
        int iconY = iconHeight > height ? -1 * ((iconHeight - height) / 2) : height / 2 - iconHeight / 2 - 1;
        int gap = 2;
        int iconX = x + width - (iconWidth + gap);
        if (index == this.getDataModel().size() - 1) {
            iconX -= 3;
        }
        rect.x = iconX;
        rect.y = iconY;
        rect.width = 5;
        rect.height = 5;
        return rect;
    }

    private void setContainsMouse(boolean val) {
        if (val != this.containsMouse) {
            this.containsMouse = val;
            this.getDisplayer().repaint();
        }
    }

    private boolean isContainsMouse() {
        return this.containsMouse;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        return super.createPinButton();
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            if (!AquaViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int index = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (index < 0) {
                return -1;
            }
            Rectangle rect = AquaViewTabDisplayerUI.this.getCloseIconRect(AquaViewTabDisplayerUI.this.tempRect, index);
            rect.width += 6;
            rect.height += 6;
            rect.x -= 3;
            rect.y -= 3;
            int result = rect.contains(point) ? index : -1;
            return result;
        }

        protected boolean inPinButtonRect(Point p) {
            return AquaViewTabDisplayerUI.this.pinButtonRect.contains(p);
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int i = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(p.x, p.y);
            int closeRectIdx = this.inCloseIconRect(p);
            AquaViewTabDisplayerUI.this.tabState.setPressed(i);
            AquaViewTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(closeRectIdx);
            AquaViewTabDisplayerUI.this.tabState.setMousePressedInCloseButton(closeRectIdx);
            if (i != -1 && closeRectIdx == -1 && AquaViewTabDisplayerUI.this.shouldPerformAction("select", i, e)) {
                AquaViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(i);
                AquaViewTabDisplayerUI.this.tabState.setSelected(i);
                Component tc = AquaViewTabDisplayerUI.this.getDataModel().getTab(i).getComponent();
                if (null != tc && tc instanceof TopComponent && !((TopComponent)tc).isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner())) {
                    ((TopComponent)tc).requestActive();
                }
            }
            if (this.shouldReact(e) && closeRectIdx != -1) {
                this.setClosePressed(closeRectIdx);
                return;
            }
            if (AquaViewTabDisplayerUI.this.pinButton != null && this.inPinButtonRect(p)) {
                AquaViewTabDisplayerUI.this.performPinAction();
            }
            if (i != -1 && e.isPopupTrigger()) {
                AquaViewTabDisplayerUI.this.shouldPerformAction("popup", i, e);
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            AquaViewTabDisplayerUI.this.tabState.setMousePressedInCloseButton(-1);
            AquaViewTabDisplayerUI.this.tabState.setPressed(-1);
            if (this.shouldReact(e)) {
                int currClosePressed = this.isClosePressed();
                this.setClosePressed(-1);
                Point point = e.getPoint();
                if (this.inCloseIconRect(point) >= 0) {
                    int i = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
                    if (i == currClosePressed) {
                        this.performAction(e);
                    }
                    this.setMouseInCloseButton(point);
                }
            }
        }

        public void mouseEntered(MouseEvent me) {
            AquaViewTabDisplayerUI.this.setContainsMouse(true);
            AquaViewTabDisplayerUI.this.tabState.setMouseInTabsArea(true);
        }

        public void mouseExited(MouseEvent me) {
            AquaViewTabDisplayerUI.this.setContainsMouse(false);
            AquaViewTabDisplayerUI.this.tabState.setMouseInTabsArea(false);
        }
    }
}

