/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.IconBases;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public abstract class BiFeature
implements IconBases,
Node.Cookie,
Comparable {
    private static final String TEXT_EXPERT = "setExpert";
    private static final String TEXT_HIDDEN = "setHidden";
    private static final String TEXT_PREFERRED = "setPreferred";
    private static final String TEXT_DISPLAY_NAME = "setDisplayName";
    private static final String TEXT_SHORT_DESCRIPTION = "setShortDescription";
    private String displayName = null;
    private boolean expert = false;
    private boolean hidden = false;
    private String name = null;
    private boolean preferred = false;
    private String shortDescription = null;
    private boolean included = true;
    private String brackets = "]";
    static /* synthetic */ Class class$org$netbeans$modules$beans$beaninfo$BiFeature;

    public BiFeature(Pattern pattern) {
        this(pattern.getName());
    }

    public BiFeature(org.netbeans.jmi.javamodel.Method me) throws JmiException {
        this(me.getName());
        this.displayName = "\"\"";
    }

    protected BiFeature() {
        this("beanDescriptor");
    }

    private BiFeature(String name) {
        this.name = name;
    }

    abstract String getCreationString();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    abstract String getBracketedName();

    String getBrackets() {
        return this.brackets;
    }

    void setBrackets(String brackets) {
        this.brackets = brackets;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getToolTip() {
        return this.getName();
    }

    Collection getCustomizationStrings() {
        ArrayList<String> col = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(100);
        if (this.expert) {
            sb.setLength(0);
            sb.append(TEXT_EXPERT).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.hidden) {
            sb.setLength(0);
            sb.append(TEXT_HIDDEN).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.preferred) {
            sb.setLength(0);
            sb.append(TEXT_PREFERRED).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.displayName != null && this.displayName.trim().length() > 0) {
            sb.setLength(0);
            sb.append(TEXT_DISPLAY_NAME).append(" ( ");
            sb.append(this.displayName).append(" )");
            col.add(sb.toString());
        }
        if (this.shortDescription != null && this.shortDescription.trim().length() > 0) {
            sb.setLength(0);
            sb.append(TEXT_SHORT_DESCRIPTION).append(" ( ");
            sb.append(this.shortDescription).append(" )");
            col.add(sb.toString());
        }
        return col;
    }

    void analyzeCustomization(Collection code) throws GenerateBeanException {
        this.setIncluded(false);
        Iterator it = code.iterator();
        String n = this.getBracketedName();
        String stNew = n + "=new";
        String stExpert = n + "." + TEXT_EXPERT;
        String stHidden = n + "." + TEXT_HIDDEN;
        String stPreferred = n + "." + TEXT_PREFERRED;
        String stDisplayName = n + "." + TEXT_DISPLAY_NAME;
        String stShortDescription = n + "." + TEXT_SHORT_DESCRIPTION;
        while (it.hasNext()) {
            String param;
            String statement = (String)it.next();
            if (statement.indexOf(stNew) != -1) {
                this.setIncluded(true);
                this.analyzeCreationString(statement);
                continue;
            }
            if (statement.indexOf(stExpert) != -1) {
                this.setExpert(true);
                continue;
            }
            if (statement.indexOf(stHidden) != -1) {
                this.setHidden(true);
                continue;
            }
            if (statement.indexOf(stPreferred) != -1) {
                this.setPreferred(true);
                continue;
            }
            if (statement.indexOf(stDisplayName) != -1) {
                param = BiAnalyser.getArgumentParameter(statement);
                if (param == null) continue;
                this.setDisplayName(param);
                continue;
            }
            if (statement.indexOf(stShortDescription) != -1) {
                param = BiAnalyser.getArgumentParameter(statement);
                if (param == null) continue;
                this.setShortDescription(param);
                continue;
            }
            this.analyzeCustomizationString(statement);
        }
    }

    abstract String getIconBase(boolean var1);

    abstract void analyzeCreationString(String var1);

    abstract void analyzeCustomizationString(String var1);

    public int compareTo(Object other) {
        if (!(other instanceof BiFeature)) {
            return -1;
        }
        BiFeature bf = (BiFeature)other;
        return this.getName().compareToIgnoreCase(bf.getName());
    }

    public static final class Method
    extends BiFeature {
        org.netbeans.jmi.javamodel.Method element;
        private String varName;
        private String toolTip;
        private org.netbeans.jmi.javamodel.Method me;
        private static Map PRIMITIVE_2_CLASS;
        private String creationString;
        static final /* synthetic */ boolean $assertionsDisabled;

        Method(org.netbeans.jmi.javamodel.Method me, PatternAnalyser pa) throws GenerateBeanException {
            super(me);
            this.element = me;
            this.me = me;
            this.toolTip = Method.initToolTip(this.element);
            this.creationString = Method.initCreationString(this.element);
        }

        String getBracketedName() {
            return "[METHOD_" + this.getName() + "]";
        }

        private static String findPrimitiveClass(String primitiveType) {
            if (PRIMITIVE_2_CLASS == null) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("int", "Integer.TYPE");
                m.put("boolean", "Boolean.TYPE");
                m.put("char", "Character.TYPE");
                m.put("long", "Long.TYPE");
                m.put("short", "Short.TYPE");
                m.put("byte", "Byte.TYPE");
                m.put("float", "Float.TYPE");
                m.put("double", "Double.TYPE");
                PRIMITIVE_2_CLASS = Collections.unmodifiableMap(m);
            }
            return (String)PRIMITIVE_2_CLASS.get(primitiveType);
        }

        private static String getTypeClass(Type type) throws JmiException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            if (type instanceof PrimitiveType) {
                return Method.findPrimitiveClass(type.getName());
            }
            if (type instanceof Array) {
                return Method.resolveArrayClass((Array)type);
            }
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getDefinition().getName() + ".class";
            }
            if (type instanceof ClassDefinition) {
                return ((ClassDefinition)type).getName() + ".class";
            }
            throw new IllegalStateException("Unknown type" + type);
        }

        private static String resolveArrayClass(Array array) {
            Array type = array;
            int i = 0;
            while (type instanceof Array) {
                type = type.getType();
                ++i;
            }
            if (type instanceof ParameterizedType) {
                char[] brackets = new char[i * 2];
                for (int j = 0; j < brackets.length; ++j) {
                    brackets[j] = 91;
                    brackets[++j] = 93;
                }
                return ((ParameterizedType)type).getDefinition().getName() + String.valueOf(brackets) + ".class";
            }
            return array.getName() + ".class";
        }

        public String getToolTip() {
            return this.toolTip;
        }

        private static String initToolTip(org.netbeans.jmi.javamodel.Method element) throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            try {
                StringBuffer sb = new StringBuffer(100);
                sb.append(element.getName() + "(");
                List parameters = element.getParameters();
                int i = 0;
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    Parameter param = (Parameter)iterator.next();
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    try {
                        sb.append(param.getType().getName());
                    }
                    catch (NullPointerException e) {
                        ErrorManager.getDefault().annotate((Throwable)e, "method: " + element);
                        ErrorManager.getDefault().annotate((Throwable)e, "i: " + i);
                        ErrorManager.getDefault().annotate((Throwable)e, "param: " + param);
                        if (param != null) {
                            ErrorManager.getDefault().annotate((Throwable)e, "type: " + param.getType());
                        }
                        throw e;
                    }
                }
                sb.append(")");
                return sb.toString();
            }
            catch (JmiException e) {
                throw new GenerateBeanException(e);
            }
        }

        org.netbeans.jmi.javamodel.Method getElement() {
            return this.element;
        }

        String getCreationString() {
            return this.creationString;
        }

        private static String initCreationString(org.netbeans.jmi.javamodel.Method element) throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            try {
                StringBuffer sb = new StringBuffer(100);
                sb.append("new MethodDescriptor ( ");
                sb.append(element.getDeclaringClass().getName() + ".class.getMethod(\"" + element.getName() + "\", ");
                sb.append("new Class[] {");
                List parameters = element.getParameters();
                int i = 0;
                Iterator it = parameters.iterator();
                while (it.hasNext()) {
                    Parameter param = (Parameter)it.next();
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(Method.getTypeClass(param.getType()));
                }
                sb.append("}))");
                return sb.toString();
            }
            catch (JmiException e) {
                throw new GenerateBeanException(e);
            }
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifMethod_S";
            }
            return "org/netbeans/modules/beans/resources/bifMethod_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCustomizationString(String statement) {
        }

        void analyzeCreationString(String statement) {
        }

        void analyzeCustomization(Collection code) throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            if (this.me != null) {
                String creation = (String)BiAnalyser.normalizeText(this.getCreationString()).toArray()[0];
                Iterator it = code.iterator();
                while (it.hasNext()) {
                    String statement = (String)it.next();
                    int index = statement.indexOf(creation);
                    if (index <= -1) continue;
                    this.varName = statement.substring(statement.indexOf("methods[METHOD_") + 15, index - 2);
                    break;
                }
                this.me = null;
            }
            String realName = this.getName();
            this.setName(this.varName);
            super.analyzeCustomization(code);
            this.setName(realName);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static final class EventSet
    extends BiFeature
    implements Comparator {
        EventSetPattern pattern;
        private static final String TEXT_UNICAST = "setUnicast";
        private static final String TEXT_IN_DEFAULT = "setInDefaultEventSet";
        private boolean isInDefaultEventSet = true;
        private String creationString;
        static final /* synthetic */ boolean $assertionsDisabled;

        EventSet(EventSetPattern esp) throws GenerateBeanException {
            super(esp);
            this.pattern = esp;
            this.creationString = this.initCreationString();
        }

        public boolean isUnicast() {
            return this.pattern.isUnicast();
        }

        public boolean isInDefaultEventSet() {
            return this.isInDefaultEventSet;
        }

        public void setInDefaultEventSet(boolean isInDefaultEventSet) {
            this.isInDefaultEventSet = isInDefaultEventSet;
        }

        String getBracketedName() {
            return "[EVENT_" + this.getName() + "]";
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof org.netbeans.jmi.javamodel.Method) || !(o2 instanceof org.netbeans.jmi.javamodel.Method)) {
                throw new IllegalArgumentException();
            }
            org.netbeans.jmi.javamodel.Method m1 = (org.netbeans.jmi.javamodel.Method)o1;
            org.netbeans.jmi.javamodel.Method m2 = (org.netbeans.jmi.javamodel.Method)o2;
            return m1.getName().compareTo(m2.getName());
        }

        String getCreationString() {
            return this.creationString;
        }

        private String initCreationString() throws GenerateBeanException {
            if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                throw new AssertionError();
            }
            try {
                ArrayList listenerMethods;
                StringBuffer sb = new StringBuffer(100);
                try {
                    Type listenerType = this.pattern.getType();
                    JavaClass listener = (JavaClass)listenerType;
                    listenerMethods = new ArrayList(JMIUtils.getMethods((ClassDefinition)listener));
                    Collections.sort(listenerMethods, this);
                }
                catch (IllegalStateException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    listenerMethods = Collections.EMPTY_LIST;
                }
                sb.append("new EventSetDescriptor ( ");
                sb.append(this.pattern.getDeclaringClass().getName() + ".class, ");
                sb.append("\"" + this.getName() + "\", ");
                sb.append(this.pattern.getType().getName() + ".class, ");
                sb.append("new String[] {");
                int i = 0;
                Iterator it = listenerMethods.iterator();
                while (it.hasNext()) {
                    org.netbeans.jmi.javamodel.Method method = (org.netbeans.jmi.javamodel.Method)it.next();
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append("\"" + method.getName() + "\"");
                }
                sb.append("}, ");
                sb.append("\"" + this.pattern.getAddListenerMethod().getName() + "\", ");
                sb.append("\"" + this.pattern.getRemoveListenerMethod().getName() + "\" )");
                return sb.toString();
            }
            catch (JmiException e) {
                throw new GenerateBeanException(e);
            }
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                if (this.isUnicast()) {
                    return "org/netbeans/modules/beans/resources/bifEventSetUC_S";
                }
                return "org/netbeans/modules/beans/resources/bifEventSetMC_S";
            }
            if (this.isUnicast()) {
                return "org/netbeans/modules/beans/resources/bifEventSetUC_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifEventSetMC_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection col = super.getCustomizationStrings();
            StringBuffer sb = new StringBuffer(100);
            if (this.isUnicast()) {
                sb.setLength(0);
                sb.append(TEXT_UNICAST).append(" ( true )");
                col.add(sb.toString());
            }
            if (!this.isInDefaultEventSet) {
                sb.setLength(0);
                sb.append(TEXT_IN_DEFAULT).append(" ( false )");
                col.add(sb.toString());
            }
            return col;
        }

        void analyzeCustomizationString(String statement) {
            String n = this.getBracketedName();
            String stInDefault = n + "." + TEXT_IN_DEFAULT;
            if (statement.indexOf(stInDefault) != -1) {
                this.setInDefaultEventSet(false);
                return;
            }
        }

        void analyzeCreationString(String statement) {
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static final class IdxProperty
    extends Property {
        private boolean niGetter;
        private boolean niSetter;
        IdxPropertyPattern pattern;
        private String indexedGetterName;
        private String indexedSetterName;
        static final /* synthetic */ boolean $assertionsDisabled;

        IdxProperty(IdxPropertyPattern pp) throws GenerateBeanException {
            super(pp);
            this.pattern = pp;
            this.niGetter = this.hasNiGetter();
            this.niSetter = this.hasNiSetter();
            try {
                if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                    throw new AssertionError();
                }
                org.netbeans.jmi.javamodel.Method ne = this.pattern.getIndexedGetterMethod();
                this.indexedGetterName = ne == null ? null : ne.getName();
                ne = this.pattern.getIndexedSetterMethod();
                this.indexedSetterName = ne == null ? null : ne.getName();
            }
            catch (JmiException e) {
                throw new GenerateBeanException(e);
            }
        }

        boolean isNiGetter() {
            return this.niGetter;
        }

        void setNiGetter(boolean niGetter) {
            this.niGetter = this.hasNiGetter() ? niGetter : false;
        }

        boolean isNiSetter() {
            return this.niSetter;
        }

        void setNiSetter(boolean niSetter) {
            this.niGetter = this.hasNiSetter() ? niSetter : false;
        }

        boolean hasNiGetter() {
            return this.pattern.getGetterMethod() != null;
        }

        boolean hasNiSetter() {
            return this.pattern.getGetterMethod() != null;
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new IndexedPropertyDescriptor ( ");
            sb.append("\"" + this.getName() + "\", ");
            sb.append(this.getDeclaringClassName() + ".class, ");
            if (this.getGetterName() != null && this.niGetter) {
                sb.append("\"" + this.getGetterName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.getSetterName() != null && this.niSetter) {
                sb.append("\"" + this.getSetterName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.indexedGetterName != null && this.getMode() != 4) {
                sb.append("\"" + this.indexedGetterName + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.indexedSetterName != null && this.getMode() != 2) {
                sb.append("\"" + this.indexedSetterName + "\" )");
            } else {
                sb.append("null )");
            }
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_S";
            }
            if (this.getMode() == 2) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.getMode() == 4) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCreationString(String statement) {
            String[] params = BiAnalyser.getParameters(statement);
            if (params.length == 6 && this.getMode() == 1) {
                if (params[4].equals("null")) {
                    this.setMode(4);
                } else if (params[5].equals("null")) {
                    this.setMode(2);
                }
                if (this.hasNiGetter() && params[2].equals(null)) {
                    this.niGetter = false;
                }
                if (this.hasNiGetter() && params[3].equals(null)) {
                    this.niSetter = false;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static class Property
    extends BiFeature {
        private PropertyPattern pattern;
        private static final String TEXT_BOUND = "setBound";
        private static final String TEXT_CONSTRAINED = "setConstrained";
        private static final String TEXT_PROPERTY_EDITOR = "setPropertyEditorClass";
        private boolean bound;
        private boolean constrained;
        private int mode;
        private String propertyEditorClass;
        private String declaringClassName;
        private String getterName;
        private String setterName;
        static final /* synthetic */ boolean $assertionsDisabled;

        Property(PropertyPattern pp) throws GenerateBeanException {
            super(pp);
            this.mode = pp.getMode();
            this.pattern = pp;
            try {
                if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
                    throw new AssertionError();
                }
                this.declaringClassName = this.pattern.getDeclaringClass().getName();
                org.netbeans.jmi.javamodel.Method ne = this.pattern.getGetterMethod();
                this.getterName = ne == null ? null : ne.getName();
                ne = this.pattern.getSetterMethod();
                this.setterName = ne == null ? null : ne.getName();
            }
            catch (JmiException e) {
                throw new GenerateBeanException(e);
            }
        }

        protected final String getDeclaringClassName() {
            return this.declaringClassName;
        }

        protected final String getGetterName() {
            return this.getterName;
        }

        protected final String getSetterName() {
            return this.setterName;
        }

        public boolean isBound() {
            return this.bound;
        }

        String getBracketedName() {
            return "[PROPERTY_" + this.getName() + "]";
        }

        public void setBound(boolean bound) {
            this.bound = bound;
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public boolean modeChangeable() {
            return this.pattern.getMode() == 1;
        }

        public String getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        public void setPropertyEditorClass(String propertyEditorClass) {
            this.propertyEditorClass = propertyEditorClass;
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new PropertyDescriptor ( ");
            sb.append("\"" + this.getName() + "\", ");
            sb.append(this.declaringClassName + ".class, ");
            if (this.getterName != null && this.getMode() != 4) {
                sb.append("\"" + this.getterName + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.setterName != null && this.getMode() != 2) {
                sb.append("\"" + this.setterName + "\" )");
            } else {
                sb.append("null )");
            }
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifPropertyRW_S";
            }
            if (this.mode == 2) {
                return "org/netbeans/modules/beans/resources/bifPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.mode == 4) {
                return "org/netbeans/modules/beans/resources/bifPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection col = super.getCustomizationStrings();
            StringBuffer sb = new StringBuffer(100);
            if (this.bound) {
                sb.setLength(0);
                sb.append(TEXT_BOUND).append(" ( true )");
                col.add(sb.toString());
            }
            if (this.constrained) {
                sb.setLength(0);
                sb.append(TEXT_CONSTRAINED).append(" ( true )");
                col.add(sb.toString());
            }
            if (this.propertyEditorClass != null && this.propertyEditorClass.trim().length() > 0) {
                sb.setLength(0);
                sb.append(TEXT_PROPERTY_EDITOR).append(" ( ");
                sb.append(this.propertyEditorClass).append(" )");
                col.add(sb.toString());
            }
            return col;
        }

        void analyzeCustomizationString(String statement) {
            String n = this.getBracketedName();
            String stBound = n + "." + TEXT_BOUND;
            String stConstrained = n + "." + TEXT_CONSTRAINED;
            String stPropertyEditor = n + "." + TEXT_PROPERTY_EDITOR;
            if (statement.indexOf(stBound) != -1) {
                this.setBound(true);
                return;
            }
            if (statement.indexOf(stConstrained) != -1) {
                this.setConstrained(true);
                return;
            }
            int peIndex = statement.indexOf(stPropertyEditor);
            if (peIndex != -1) {
                String paramString = statement.substring(peIndex + stPropertyEditor.length());
                String[] params = BiAnalyser.getParameters(paramString);
                if (params.length > 0) {
                    this.setPropertyEditorClass(params[0]);
                }
                return;
            }
        }

        void analyzeCreationString(String statement) {
            String[] params = BiAnalyser.getParameters(statement);
            if (params.length == 4 && this.mode == 1) {
                if (params[2].equals("null")) {
                    this.mode = 4;
                } else if (params[3].equals("null")) {
                    this.mode = 2;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$beans$beaninfo$BiFeature == null ? (class$org$netbeans$modules$beans$beaninfo$BiFeature = BiFeature.class$("org.netbeans.modules.beans.beaninfo.BiFeature")) : class$org$netbeans$modules$beans$beaninfo$BiFeature).desiredAssertionStatus();
        }
    }

    public static final class Descriptor
    extends BiFeature {
        JavaClass element;
        String customizer;
        private String beanName;

        Descriptor(JavaClass ce) throws GenerateBeanException {
            this.element = ce;
            this.beanName = Descriptor.initBeanName(this.element);
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new BeanDescriptor  ( ");
            sb.append(this.getBeanName() + ".class , ");
            sb.append(String.valueOf(this.getCustomizer()) + " )");
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            return "org/netbeans/modules/beans/resources/bifDescriptor";
        }

        Collection getCustomizationStrings() {
            Collection col = super.getCustomizationStrings();
            return col;
        }

        void analyzeCustomizationString(String statement) {
        }

        void analyzeCreationString(String statement) {
            int beg = statement.indexOf(44);
            int end = statement.lastIndexOf(41);
            if (beg != -1 && end != -1 && ++beg < end) {
                this.setCustomizer(statement.substring(beg, end));
            } else {
                this.setCustomizer(null);
            }
        }

        String getBracketedName() {
            return this.getName();
        }

        String getBrackets() {
            return "";
        }

        public String getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(String customizer) {
            this.customizer = customizer;
        }

        public boolean isIncluded() {
            return true;
        }

        private static String initBeanName(JavaClass element) throws GenerateBeanException {
            try {
                return element.getName();
            }
            catch (JmiException e) {
                throw new GenerateBeanException(e);
            }
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

