/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.CustomizerSupport;

public class CustomizerDataSupport {
    private final DeploymentManagerProperties dmp;
    private CustomizerSupport.PathModel sourceModel;
    private CustomizerSupport.PathModel classModel;
    private CustomizerSupport.PathModel javadocModel;
    private boolean sourceModelFlag;
    private boolean javadocModelFlag;
    private boolean serverPortModelFlag;

    public CustomizerDataSupport(DeploymentManagerProperties dmp) {
        this.dmp = dmp;
        this.init();
    }

    private void init() {
        this.classModel = new CustomizerSupport.PathModel(this.dmp.getClasses());
        this.sourceModel = new CustomizerSupport.PathModel(this.dmp.getSources());
        this.sourceModel.addListDataListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.sourceModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.javadocModel = new CustomizerSupport.PathModel(this.dmp.getJavadocs());
        this.javadocModel.addListDataListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.javadocModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
    }

    public CustomizerSupport.PathModel getClassModel() {
        return this.classModel;
    }

    public CustomizerSupport.PathModel getSourceModel() {
        return this.sourceModel;
    }

    public CustomizerSupport.PathModel getJavadocsModel() {
        return this.javadocModel;
    }

    private void store() {
        if (this.sourceModelFlag) {
            this.dmp.setSources(this.sourceModel.getData());
            this.sourceModelFlag = false;
        }
        if (this.javadocModelFlag) {
            this.dmp.setJavadocs(this.javadocModel.getData());
            this.javadocModelFlag = false;
        }
    }

    private abstract class ModelChangeAdapter
    implements ListDataListener,
    DocumentListener,
    ItemListener,
    ChangeListener {
        private ModelChangeAdapter() {
        }

        public abstract void modelChanged();

        public void contentsChanged(ListDataEvent e) {
            this.modelChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.modelChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.modelChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        public void itemStateChanged(ItemEvent e) {
            this.modelChanged();
        }

        public void stateChanged(ChangeEvent e) {
            this.modelChanged();
        }
    }
}

