/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.enterprise.deploy.model.DeployableObject;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Utils {
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.j2ee.Bundle");
    static final File[] EMPTY_FILE_LIST = new File[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempPasswordFile(String password, String masterPassword) {
        FileOutputStream output = null;
        PrintWriter p = null;
        try {
            File file = File.createTempFile("admin", null);
            file.deleteOnExit();
            output = new FileOutputStream(file);
            p = new PrintWriter(output);
            p.println("AS_ADMIN_ADMINPASSWORD=" + password);
            p.println("AS_ADMIN_PASSWORD=" + password);
            p.println("AS_ADMIN_MASTERPASSWORD=" + masterPassword);
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            File file = null;
            return file;
        }
        finally {
            try {
                if (p != null) {
                    p.close();
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static Object getResource(File primaryFile) {
        Resources resources = Utils.getResourceGraph(primaryFile);
        JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
        if (pools.length != 0) {
            return pools[0];
        }
        JdbcResource[] dataSources = resources.getJdbcResource();
        if (dataSources.length != 0) {
            return dataSources[0];
        }
        return null;
    }

    public static String getResourceType(Resources resources) {
        PersistenceManagerFactoryResource[] pmfResources = resources.getPersistenceManagerFactoryResource();
        if (pmfResources.length != 0) {
            return "persistence-manager-factory-resource";
        }
        MailResource[] mailResources = resources.getMailResource();
        if (mailResources.length != 0) {
            return "mail-resource";
        }
        ConnectorResource[] connResources = resources.getConnectorResource();
        ConnectorConnectionPool[] connPoolResources = resources.getConnectorConnectionPool();
        AdminObjectResource[] admObjResources = resources.getAdminObjectResource();
        if (admObjResources.length != 0 || connPoolResources.length != 0 & connResources.length != 0) {
            return "jms-resource";
        }
        return null;
    }

    public static void setTopManagerStatus(String msg) {
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    public static File[] getResourceDirs(DeployableObject deployableObject) {
        try {
            SourceFileMap sourceFileMap = SourceFileMap.findSourceMap((DeployableObject)deployableObject);
            if (sourceFileMap != null) {
                return sourceFileMap.getEnterpriseResourceDirs();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return EMPTY_FILE_LIST;
    }

    public static File[] getResourceDirs(File file) {
        try {
            FileObject fo = FileUtil.toFileObject((File)file);
            SourceFileMap sourceFileMap = SourceFileMap.findSourceMap((FileObject)fo);
            if (sourceFileMap != null) {
                return sourceFileMap.getEnterpriseResourceDirs();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return EMPTY_FILE_LIST;
    }

    public static void registerResources(File[] resourceDirs, ServerInterface mejb) {
        System.out.println(bundle.getString("Msg_ProjResRegisterStart"));
        try {
            SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)mejb.getDeploymentManager();
            for (int j = 0; j < resourceDirs.length; ++j) {
                int i;
                File resourceDir = resourceDirs[j];
                File[] resources = null;
                if (resourceDir != null) {
                    resources = resourceDir.listFiles(new ResourceFileFilter());
                }
                File resource = null;
                Object sunResource = null;
                if (resources == null) continue;
                for (i = 0; i < resources.length; ++i) {
                    resource = resources[i];
                    if (resource == null || resource.isDirectory() || (sunResource = Utils.getResource(resource)) == null || !(sunResource instanceof JdbcConnectionPool)) continue;
                    JdbcConnectionPool connectionPoolBean = (JdbcConnectionPool)sunResource;
                    ResourceUtils.register((JdbcConnectionPool)connectionPoolBean, (ServerInterface)mejb, (boolean)true);
                }
                for (i = 0; i < resources.length; ++i) {
                    resource = resources[i];
                    if (resource == null || resource.isDirectory() || (sunResource = Utils.getResource(resource)) == null || !(sunResource instanceof JdbcResource)) continue;
                    JdbcResource datasourceBean = (JdbcResource)sunResource;
                    ResourceUtils.register((JdbcResource)datasourceBean, (ServerInterface)mejb, (boolean)true);
                }
                for (i = 0; i < resources.length; ++i) {
                    Resources res;
                    String resourceType;
                    resource = resources[i];
                    if (resource == null || resource.isDirectory() || (resourceType = Utils.getResourceType(res = Utils.getResourceGraph(resource))) == null) continue;
                    ResourceUtils.register((Resources)res, (SunDeploymentManagerInterface)sunDm, (boolean)true, (String)resourceType);
                }
            }
        }
        catch (Exception ex) {
            String errorMsg = MessageFormat.format(bundle.getString("Msg_RegFailure"), ex.getLocalizedMessage());
            System.out.println(errorMsg);
        }
        System.out.println(bundle.getString("Msg_ProjResRegisterFinish"));
    }

    static Resources getResourceGraph(File primaryFile) {
        Resources resources = null;
        try {
            if (!primaryFile.isDirectory()) {
                FileInputStream in = new FileInputStream(primaryFile);
                resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resources;
    }

    public static class ResourceFileFilter
    implements FileFilter {
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".sun-resource");
        }
    }
}

