/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.SunServerStateInterface;
import org.netbeans.modules.j2ee.sun.ide.dm.SunDeploymentManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ConfigureProfiler;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.sun.ide.j2ee.HttpMonitorSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.HttpProxyUpdater;
import org.netbeans.modules.j2ee.sun.ide.j2ee.LogViewerSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ProgressEventSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Status;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.actions.ViewLogAction;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.MasterPasswordInputDialog;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class StartSunServer
extends StartServer
implements ProgressObject,
SunServerStateInterface,
Runnable {
    private ProgressEventSupport pes;
    private CommandType ct = null;
    private int cmd = 0;
    private DeploymentManager dm;
    private boolean debug = false;
    private ServerDebugInfo debugInfo = null;
    private boolean shouldStopDeploymentManagerSilently = false;
    private static final int CMD_NONE = 0;
    private static final int CMD_START = 1;
    private static final int CMD_STOP = 2;
    private static final int CMD_RESTART = 3;
    private static final long TIMEOUT_DELAY = 300000L;
    private static final long PROFILER_TIMEOUT_DELAY = 600000L;
    private static Map debugInfoMap = Collections.synchronizedMap(new HashMap(2, 1.0f));
    private String httpPort = null;
    private int current_mode = 0;
    private static final int MODE_RUN = 0;
    private static final int MODE_DEBUG = 1;
    private static final int MODE_PROFILE = 2;
    private String installRoot;
    private final DeploymentManagerProperties dmProps;
    private static Map<DeploymentManager, StartServer> dm2StartServer = new HashMap<DeploymentManager, StartServer>();
    private static final String MASTER_PASSWORD_ALIAS = "master-password";
    private static final String LOCALHOST = "localhost";
    private static final String LOCALADDRESS = "127.0.0.1";

    private StartSunServer(DeploymentManager deploymentManager) {
        this.dm = deploymentManager;
        this.dmProps = new DeploymentManagerProperties(deploymentManager);
        File irf = ((SunDeploymentManagerInterface)this.dm).getPlatformRoot();
        if (null != irf && irf.exists()) {
            this.installRoot = irf.getAbsolutePath();
        }
        this.pes = new ProgressEventSupport(this);
        Logger.getLogger("javax.enterprise.system.tools.admin.client").setLevel(Level.OFF);
        Logger.getLogger("javax.enterprise.system.tools.avk.tools.verifier").setLevel(Level.OFF);
        Logger.getLogger("javax.enterprise.system.tools.avk.appverification").setLevel(Level.OFF);
        Logger.getLogger("javax.enterprise.system.tools.avk.appverification.tools").setLevel(Level.OFF);
        Logger.getLogger("javax.enterprise.system.tools.avk.appverification.xml").setLevel(Level.OFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StartServer get(DeploymentManager dm) {
        StartServer retVal = null;
        Map<DeploymentManager, StartServer> map = dm2StartServer;
        synchronized (map) {
            retVal = dm2StartServer.get(dm);
            if (null == retVal) {
                retVal = new StartSunServer(dm);
                dm2StartServer.put(dm, retVal);
            }
        }
        return retVal;
    }

    public DeploymentManager getDeploymentManager() {
        return this.dm;
    }

    public boolean supportsStartDeploymentManager() {
        boolean ret = true;
        File domainDirectory = null;
        String domain = this.dmProps.getDomainName();
        String domainDir = this.dmProps.getLocation();
        if (null == domain || domain.trim().length() < 1 || null == domainDir || domainDir.trim().length() < 1) {
            ret = false;
        } else {
            domainDirectory = new File(domainDir, domain);
            ret = ((SunDeploymentManagerInterface)this.dm).isLocal();
            ret &= domainDirectory.canWrite();
        }
        return ret;
    }

    public boolean supportsStartDebugging(Target target) {
        return this.supportsStartDeploymentManager();
    }

    public boolean supportsStartProfiling(Target target) {
        return this.supportsStartDeploymentManager();
    }

    public boolean isProfiling(Target target) {
        return this.isRunning();
    }

    public ProgressObject startProfiling(Target target, ProfilerServerSettings settings) {
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        this.current_mode = 2;
        return this.startTarget(target, 2, settings);
    }

    public void stopDeploymentManagerSilently() {
        this.shouldStopDeploymentManagerSilently = true;
        this.stopDeploymentManager();
    }

    public boolean canStopDeploymentManagerSilently() {
        return true;
    }

    public ProgressObject startDeploymentManager() {
        this.ct = CommandType.START;
        this.pes.clearProgressListener();
        if (this.cmd == 0) {
            this.cmd = 1;
        }
        this.addProgressListener(new ProgressListener(){

            public void handleProgressEvent(ProgressEvent pe) {
                if (pe.getDeploymentStatus().isCompleted()) {
                    StartSunServer.this.getDebugInfo();
                }
            }
        });
        ConfigureProfiler.removeProfilerFromDomain(this.dm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.RUNNING));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public ProgressObject stopDeploymentManager() {
        SunDeploymentManager sunDm = (SunDeploymentManager)this.dm;
        debugInfoMap.remove(sunDm.getHost() + sunDm.getPort());
        this.ct = CommandType.STOP;
        this.pes.clearProgressListener();
        this.cmd = 2;
        ConfigureProfiler.removeProfilerFromDomain(this.dm);
        boolean running = false;
        try {
            Target[] targs = sunDm.getTargets();
            running = targs == null ? false : targs.length > 0;
        }
        catch (IllegalStateException ise) {
            running = false;
        }
        if (this.current_mode == 2 && !running && !this.portInUse()) {
            this.current_mode = 0;
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.COMPLETED));
            this.cmd = 0;
        } else {
            if (this.current_mode == 2) {
                this.current_mode = 0;
            }
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.RUNNING));
            RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        }
        return this;
    }

    public void viewLogFile() {
        this.getLogViewerWindow();
    }

    private InputOutput getLogViewerWindow() {
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        return ViewLogAction.viewLog(sunDm, false, false);
    }

    public synchronized void run() {
        String asadminCmd;
        int errorCode = -1;
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        DeploymentManagerProperties dmProps = new DeploymentManagerProperties(this.dm);
        String domain = dmProps.getDomainName();
        String domainDir = dmProps.getLocation();
        if (this.cmd == 2 || this.cmd == 3) {
            String[] arr;
            try {
                if (!this.debug && !ServerLocationManager.isGlassFish((File)sunDm.getPlatformRoot())) {
                    sunDm.fixJVMDebugOptions();
                }
            }
            catch (Exception ex) {
                Util.showInformation(ex.getLocalizedMessage());
            }
            asadminCmd = domainDir + File.separator + domain + File.separator + "bin" + File.separator + "stopserv";
            if (File.separator.equals("\\")) {
                asadminCmd = asadminCmd + ".bat";
            }
            if ((errorCode = this.exec(arr = new String[]{asadminCmd, " "}, 2, null)) != 0) {
                this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, NbBundle.getMessage(StartSunServer.class, (String)"LBL_ErrorStoppingServer"), StateType.FAILED));
                this.cmd = 0;
                this.pes.clearProgressListener();
                return;
            }
            LogViewerSupport.removeLogViewerSupport(dmProps.getUrl());
        }
        if (this.cmd == 1 || this.cmd == 3) {
            InputOutput io;
            String mpw;
            try {
                HttpMonitorSupport.synchronizeMonitorWithFlag((SunDeploymentManagerInterface)this.dm);
            }
            catch (Exception eee) {
                // empty catch block
            }
            try {
                HttpProxyUpdater hpu = new HttpProxyUpdater(sunDm.getManagement(), false);
                if (dmProps.isSyncHttpProxyOn()) {
                    hpu.addHttpProxySettings();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            asadminCmd = this.installRoot + File.separator + "bin" + File.separator + "asadmin";
            if (File.separator.equals("\\")) {
                asadminCmd = asadminCmd + ".bat";
            }
            String debugString = "false";
            if (this.debug) {
                debugString = "true";
            }
            if ((mpw = this.readMasterPasswordFile()) == null) {
                this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, NbBundle.getMessage(StartSunServer.class, (String)"LBL_ErrorStartingServer"), StateType.FAILED));
                this.cmd = 0;
                this.pes.clearProgressListener();
                return;
            }
            File passWordFile = Utils.createTempPasswordFile(sunDm.getPassword(), mpw);
            if (passWordFile == null) {
                this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, NbBundle.getMessage(StartSunServer.class, (String)"LBL_ErrorStartingServer"), StateType.FAILED));
                this.cmd = 0;
                this.pes.clearProgressListener();
                return;
            }
            String[] arrd = new String[]{asadminCmd, "start-domain", "--debug=" + debugString, "--user", sunDm.getUserName(), "--passwordfile", passWordFile.getAbsolutePath(), "--domaindir", domainDir, domain};
            if (ServerLocationManager.isJavaDBPresent((File)sunDm.getPlatformRoot())) {
                DerbySupport.ensureStarted();
            }
            if ((errorCode = this.exec(arrd, 1, io = this.getLogViewerWindow())) != 0) {
                if (!((SunDeploymentManager)sunDm).isMaybeRunningButWrongUserName()) {
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, NbBundle.getMessage(StartSunServer.class, (String)"LBL_ErrorStartingServer"), StateType.FAILED));
                } else {
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, NbBundle.getMessage(SunDeploymentManager.class, (String)"ERR_AUTH_DIALOG_TITLE"), StateType.FAILED));
                }
                this.cmd = 0;
                this.pes.clearProgressListener();
                return;
            }
        }
        if (this.current_mode == 2) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.COMPLETED));
            this.cmd = 0;
            this.pes.clearProgressListener();
            return;
        }
        boolean running = false;
        try {
            running = sunDm.isRunning(true);
        }
        catch (RuntimeException re) {
            ErrorManager.getDefault().notify(1, (Throwable)re);
        }
        if (this.cmd != 2 && !running) {
            this.viewLogFile();
            for (int l = 0; l < 5; ++l) {
                try {
                    Thread.sleep(3000L);
                    if (!((SunDeploymentManagerInterface)this.dm).isRunning(true)) continue;
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.COMPLETED));
                    this.cmd = 0;
                    this.pes.clearProgressListener();
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, NbBundle.getMessage(StartSunServer.class, (String)"LBL_ErrorStartingServer"), StateType.FAILED));
            this.cmd = 0;
            this.pes.clearProgressListener();
            return;
        }
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.COMPLETED));
        this.cmd = 0;
        this.pes.clearProgressListener();
    }

    private int exec(String[] arr, int type, InputOutput io) {
        int exitValue = -1;
        try {
            Process process = Runtime.getRuntime().exec(arr);
            ByteArrayOutputStream eos = new ByteArrayOutputStream();
            StreamFlusher sfErr = new StreamFlusher(process.getErrorStream(), eos);
            sfErr.start();
            ByteArrayOutputStream oos = new ByteArrayOutputStream();
            StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), oos);
            sfOut.start();
            if (this.shouldStopDeploymentManagerSilently) {
                this.shouldStopDeploymentManagerSilently = false;
                return 0;
            }
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.RUNNING));
            try {
                if (this.current_mode == 2) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.hasCommandSucceeded()) {
                        return 0;
                    }
                    if (null != io) {
                        io.getOut().println(oos.toString());
                    }
                    return -1;
                }
                exitValue = process.waitFor();
                if (exitValue == 0) {
                    if (this.hasCommandSucceeded()) {
                        return 0;
                    }
                    return -1;
                }
                if (null != io) {
                    io.getOut().println(oos.toString());
                }
            }
            catch (InterruptedException ie) {}
        }
        catch (IOException e) {
            // empty catch block
        }
        return exitValue;
    }

    private char[] getMasterPasswordPassword() {
        return MASTER_PASSWORD_ALIAS.toCharArray();
    }

    protected String readMasterPasswordFile() {
        String mpw = "changeit";
        String domain = this.dmProps.getDomainName();
        String domainDir = this.dmProps.getLocation();
        File pwdFile = new File(domainDir + File.separator + domain + File.separator + MASTER_PASSWORD_ALIAS);
        if (pwdFile.exists()) {
            try {
                SunDeploymentManagerInterface sdm = (SunDeploymentManagerInterface)this.dm;
                ClassLoader loader = ServerLocationManager.getNetBeansAndServerClassLoader((File)sdm.getPlatformRoot());
                Class<?> pluginRootFactoryClass = loader.loadClass("com.sun.enterprise.security.store.PasswordAdapter");
                Constructor<?> constructor = pluginRootFactoryClass.getConstructor(String.class, this.getMasterPasswordPassword().getClass());
                Object PasswordAdapter = constructor.newInstance(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
                Class<?> PasswordAdapterClazz = PasswordAdapter.getClass();
                Method method = PasswordAdapterClazz.getMethod("getPasswordForAlias", MASTER_PASSWORD_ALIAS.getClass());
                mpw = (String)method.invoke(PasswordAdapter, MASTER_PASSWORD_ALIAS);
                return mpw;
            }
            catch (Exception ex) {
                return mpw;
            }
        }
        MasterPasswordInputDialog d = new MasterPasswordInputDialog();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.OK_OPTION) {
            mpw = d.getInputText();
            try {
                File pwdFile2 = new File(domainDir + File.separator + domain + File.separator + "config/domain-passwords");
                SunDeploymentManagerInterface sdm = (SunDeploymentManagerInterface)this.dm;
                ClassLoader loader = ServerLocationManager.getNetBeansAndServerClassLoader((File)sdm.getPlatformRoot());
                Class<?> pluginRootFactoryClass = loader.loadClass("com.sun.enterprise.security.store.PasswordAdapter");
                Constructor<?> constructor = pluginRootFactoryClass.getConstructor(String.class, this.getMasterPasswordPassword().getClass());
                constructor.newInstance(pwdFile2.getAbsolutePath(), mpw.toCharArray());
                return mpw;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public boolean isRunning() {
        try {
            SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
            boolean runningState = sunDm.isRunning();
            if (runningState && this.httpPort == null) {
                this.httpPort = sunDm.getNonAdminPortNumber();
                if (this.httpPort != null) {
                    DeploymentManagerProperties dmProps = new DeploymentManagerProperties(this.dm);
                    dmProps.setHttpPortNumber(this.httpPort);
                }
            }
            return runningState;
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    private boolean hasCommandSucceeded() {
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        long to = 300000L;
        if (this.current_mode == 2) {
            to = 600000L;
        }
        long timeout = System.currentTimeMillis() + to;
        block4: while (true) {
            try {
                while (true) {
                    boolean isRunning = sunDm.isRunning(true);
                    if (this.ct == CommandType.START) {
                        if (isRunning) {
                            return true;
                        }
                        if (((SunDeploymentManager)sunDm).isMaybeRunningButWrongUserName()) {
                            return false;
                        }
                        if (this.current_mode == 2) {
                            int state = ProfilerSupport.getState();
                            if (state == ProfilerSupport.STATE_BLOCKING || state == ProfilerSupport.STATE_RUNNING || state == ProfilerSupport.STATE_PROFILING) {
                                return true;
                            }
                            if (state == ProfilerSupport.STATE_INACTIVE) {
                                return false;
                            }
                        }
                    }
                    if (this.ct == CommandType.STOP && !isRunning) {
                        return true;
                    }
                    if (System.currentTimeMillis() > timeout) {
                        return false;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue block4;
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                return false;
            }
        }
    }

    public boolean needsRestart(Target target) {
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        return sunDm.isRestartNeeded();
    }

    public boolean isDebuggable(Target target) {
        try {
            SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
            if (!sunDm.isRunning()) {
                return false;
            }
            if (sunDm.isLocal()) {
                return null != debugInfoMap.get(sunDm.getHost() + sunDm.getPort());
            }
            debugInfoMap.put(sunDm.getHost() + sunDm.getPort(), this.getDebugInfo());
            return true;
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    public boolean isDebugged() {
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        if (!sunDm.isRunning()) {
            return false;
        }
        return null != debugInfoMap.get(sunDm.getHost() + sunDm.getPort());
    }

    public ProgressObject startTarget(Target Target2, int mode, ProfilerServerSettings settings) {
        this.debug = mode == 1;
        this.pes.clearProgressListener();
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        if (this.debug) {
            debugInfoMap.put(sunDm.getHost() + sunDm.getPort(), this.getDebugInfo());
        } else {
            debugInfoMap.remove(sunDm.getHost() + sunDm.getPort());
        }
        if (settings != null) {
            ConfigureProfiler.instrumentProfilerInDOmain(this.dm, null, settings.getJvmArgs());
        } else {
            ConfigureProfiler.removeProfilerFromDomain(this.dm);
        }
        this.cmd = 1;
        if (this.isRunning()) {
            this.cmd = 3;
        }
        this.ct = CommandType.START;
        this.pes.clearProgressListener();
        this.addProgressListener(new ProgressListener(){

            public void handleProgressEvent(ProgressEvent pe) {
                if (pe.getDeploymentStatus().isCompleted()) {
                    StartSunServer.this.getDebugInfo();
                }
            }
        });
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.ct, "", StateType.RUNNING));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean portInUse() {
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
        boolean retVal = true;
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(sunDm.getPort());
            retVal = false;
        }
        catch (IOException ioe) {
        }
        finally {
            if (null != ss) {
                try {
                    ss.close();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        }
        return retVal;
    }

    public ProgressObject stopTarget(Target target) {
        this.pes.clearProgressListener();
        boolean running = false;
        try {
            running = ((SunDeploymentManagerInterface)this.dm).isRunning(true);
        }
        catch (RuntimeException re) {
            ErrorManager.getDefault().notify(1, (Throwable)re);
        }
        if (!running) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.STOP, "", StateType.COMPLETED));
            return this;
        }
        return this.stopDeploymentManager();
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return this.getDebugInfo();
    }

    private ServerDebugInfo getDebugInfo() {
        try {
            SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)this.dm;
            if (!sunDm.isRunning()) {
                return null;
            }
            if (StartSunServer.isSuspended((SunDeploymentManagerInterface)this.dm)) {
                return (ServerDebugInfo)debugInfoMap.get(sunDm.getHost() + sunDm.getPort());
            }
            String addr = sunDm.getDebugAddressValue();
            if (sunDm.isDebugSharedMemory()) {
                this.debugInfo = new ServerDebugInfo(sunDm.getHost(), addr);
                if (this.debug) {
                    debugInfoMap.put(sunDm.getHost() + sunDm.getPort(), this.debugInfo);
                }
            } else {
                int port = Integer.parseInt(addr);
                this.debugInfo = new ServerDebugInfo(sunDm.getHost(), port);
                if (this.debug) {
                    debugInfoMap.put(sunDm.getHost() + sunDm.getPort(), this.debugInfo);
                }
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.debugInfo = null;
        }
        return this.debugInfo;
    }

    public static boolean isSuspended(SunDeploymentManagerInterface sunDm) {
        boolean retVal = false;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; !retVal && i < sessions.length; ++i) {
            JPDADebugger jpda;
            Object d;
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null || (d = s.lookupFirst(null, JPDADebugger.class)) == null || (jpda = (JPDADebugger)d).getState() != 3) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            String shmName = attCookie.getSharedMemoryName();
            if (shmName != null) {
                if (!shmName.startsWith(sunDm.getHost())) continue;
                retVal = true;
                continue;
            }
            int attachedPort = attCookie.getPortNumber();
            ServerDebugInfo dbi = (ServerDebugInfo)debugInfoMap.get(sunDm.getHost() + sunDm.getPort());
            if (null == dbi || !StartSunServer.sameMachine(attCookie.getHostName(), sunDm.getHost()) || dbi.getPort() != attachedPort) continue;
            retVal = true;
        }
        return retVal;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.pes.getDeploymentStatus();
    }

    public void addProgressListener(ProgressListener pl) {
        this.pes.addProgressListener(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.pes.removeProgressListener(pl);
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public ProgressObject startDebugging(Target target) {
        this.current_mode = 1;
        return this.startTarget(target, 1, null);
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public static boolean sameMachine(String host1, String host2) {
        try {
            String h1;
            String h12;
            String h2;
            String localCanonicalHostName;
            if (host1.equals(host2)) {
                return true;
            }
            if (host1.equals(LOCALHOST)) {
                if (host2.equals(LOCALADDRESS)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                if (localCanonicalHostName.equals(h2 = InetAddress.getByName(host2).getCanonicalHostName())) {
                    return true;
                }
            }
            if (host1.equals(LOCALADDRESS)) {
                if (host2.equals(LOCALHOST)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                h2 = InetAddress.getByName(host2).getCanonicalHostName();
                return true;
            }
            if (host2.equals(LOCALHOST)) {
                if (host1.equals(LOCALADDRESS)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                if (localCanonicalHostName.equals(h12 = InetAddress.getByName(host1).getCanonicalHostName())) {
                    return true;
                }
            }
            if (host2.equals(LOCALADDRESS)) {
                if (host1.equals(LOCALHOST)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                if (localCanonicalHostName.equals(h12 = InetAddress.getByName(host1).getCanonicalHostName())) {
                    return true;
                }
            }
            if ((h1 = InetAddress.getByName(host1).getCanonicalHostName()).equals(h2 = InetAddress.getByName(host2).getCanonicalHostName())) {
                return true;
            }
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    protected class StreamFlusher
    extends Thread {
        private InputStream _input = null;
        private OutputStream _output = null;

        public StreamFlusher(InputStream input, OutputStream output) {
            this._input = input;
            this._output = output;
        }

        public void run() {
            if (this._input == null) {
                return;
            }
            try {
                int byteCnt = 0;
                byte[] buffer = new byte[4096];
                while ((byteCnt = this._input.read(buffer)) != -1) {
                    if (this._output != null && byteCnt > 0) {
                        this._output.write(buffer, 0, byteCnt);
                        this._output.flush();
                    }
                    StreamFlusher.yield();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

