/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DomainEditor;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.JvmOptions;

public class HttpProxyUpdater {
    private String httpProxyPort;
    private String httpProxyHost;
    private String httpsProxyPort;
    private String httpsProxyHost;
    private String httpProxyNoHost;
    private static String HTTP_PROXY_HOST = "-Dhttp.proxyHost=";
    private static String HTTP_PROXY_PORT = "-Dhttp.proxyPort=";
    private static String HTTPS_PROXY_HOST = "-Dhttps.proxyHost=";
    private static String HTTPS_PROXY_PORT = "-Dhttps.proxyPort=";
    private static String HTTP_PROXY_NO_HOST = "-Dhttp.nonProxyHosts=";
    private static String JVM_OPTIONS = "jvm-options";
    private ObjectName jvmOptionsObjectName;
    private ServerInterface si;
    private String[] options;
    private boolean serverRunning;
    ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.j2ee.Bundle");

    public HttpProxyUpdater(ServerInterface si, boolean serverRunning) {
        this.serverRunning = serverRunning;
        this.si = si;
    }

    private void getOptionsFromServer() throws Exception {
        this.jvmOptionsObjectName = new JvmOptions(this.si.getMBeanServerConnection()).getConfigObjectName();
        this.options = (String[])this.si.getAttribute(this.jvmOptionsObjectName, JVM_OPTIONS);
        this.initializeProps();
    }

    private void setOptionsToServer() throws Exception {
        this.jvmOptionsObjectName = new JvmOptions(this.si.getMBeanServerConnection()).getConfigObjectName();
        Attribute newOptions = new Attribute(JVM_OPTIONS, this.options);
        this.si.setAttribute(this.jvmOptionsObjectName, newOptions);
    }

    private void getOptionsFromXml() {
        DomainEditor dEditor = new DomainEditor(this.si.getDeploymentManager());
        this.options = dEditor.getHttpProxyOptions();
        this.initializeProps();
    }

    private void setOptionsToXml() {
        DomainEditor dEditor = new DomainEditor(this.si.getDeploymentManager());
        dEditor.setHttpProxyOptions(this.options);
    }

    private boolean removeProperty(String prefix) {
        boolean changed;
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.options.length; ++i) {
            String option = this.options[i].trim();
            if (option.startsWith(prefix)) continue;
            al.add(this.options[i]);
        }
        boolean bl = changed = this.options.length != al.size();
        if (changed) {
            this.options = al.toArray(new String[al.size()]);
        }
        return changed;
    }

    private boolean setProperty(String prefix, String value) {
        if (value == null) {
            return this.removeProperty(prefix);
        }
        String newValue = prefix + value;
        boolean found = false;
        for (int i = 0; i < this.options.length; ++i) {
            String option = this.options[i].trim();
            if (!option.startsWith(prefix)) continue;
            this.options[i] = newValue;
            found = true;
            break;
        }
        if (found) {
            return true;
        }
        String[] newOptions = new String[this.options.length + 1];
        System.arraycopy(this.options, 0, newOptions, 0, this.options.length);
        newOptions[this.options.length] = newValue;
        this.options = newOptions;
        return true;
    }

    private boolean removeProxy() {
        boolean changed = this.removeProperty(HTTP_PROXY_HOST);
        changed |= this.removeProperty(HTTP_PROXY_PORT);
        changed |= this.removeProperty(HTTPS_PROXY_HOST);
        changed |= this.removeProperty(HTTPS_PROXY_PORT);
        return changed |= this.removeProperty(HTTP_PROXY_NO_HOST);
    }

    public void addHttpProxySettings() throws Exception {
        String nonHosts;
        String port;
        String host = System.getProperty("http.proxyHost", "");
        if (host.trim().length() == 0) {
            host = null;
        }
        if ((port = System.getProperty("http.proxyPort", "")).trim().length() == 0) {
            port = null;
        }
        if ((nonHosts = System.getProperty("http.nonProxyHosts", "")).trim().length() == 0) {
            nonHosts = null;
        }
        if (this.serverRunning) {
            try {
                this.getOptionsFromServer();
                if (host == null || port == null || nonHosts == null) {
                    this.removeOptionsFromServer();
                    return;
                }
            }
            catch (Exception ex) {
                throw new Exception(this.bundle.getString("Err_CannotUpdateProxy"));
            }
            this.checkProxyInfo(host, port);
            if (this.updateOptions(host, port, nonHosts)) {
                try {
                    this.setOptionsToServer();
                }
                catch (Exception ex) {
                    String message = MessageFormat.format(this.bundle.getString("Err_InvalidProxyInfo"), host, port);
                    throw new Exception(message);
                }
            }
        } else {
            this.getOptionsFromXml();
            if (host == null || port == null || nonHosts == null) {
                this.removeOptionsFromXml();
                return;
            }
            this.checkProxyInfo(host, port);
            if (this.updateOptions(host, port, nonHosts)) {
                this.setOptionsToXml();
            }
        }
    }

    public void removeHttpProxySettings() throws Exception {
        if (this.serverRunning) {
            this.getOptionsFromServer();
            this.removeOptionsFromServer();
        } else {
            this.getOptionsFromXml();
            this.removeOptionsFromXml();
        }
    }

    private void removeOptionsFromXml() {
        if ((this.httpProxyHost != null || this.httpProxyPort != null || this.httpProxyNoHost != null || this.httpsProxyHost != null || this.httpsProxyPort != null) && this.removeProxy()) {
            this.setOptionsToXml();
        }
    }

    private void removeOptionsFromServer() throws Exception {
        try {
            if ((this.httpProxyHost != null || this.httpProxyPort != null || this.httpProxyNoHost != null || this.httpsProxyHost != null || this.httpsProxyPort != null) && this.removeProxy()) {
                try {
                    this.setOptionsToServer();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean updateOptions(String host, String port, String nonHosts) {
        SunDeploymentManagerInterface sdm;
        boolean changed = false;
        if (!host.equals(this.httpProxyHost)) {
            this.setProperty(HTTP_PROXY_HOST, host);
            changed = true;
        }
        if (!port.equals(this.httpProxyPort)) {
            this.setProperty(HTTP_PROXY_PORT, port);
            changed = true;
        }
        if (!host.equals(this.httpsProxyHost)) {
            this.setProperty(HTTPS_PROXY_HOST, host);
            changed = true;
        }
        if (!port.equals(this.httpsProxyPort)) {
            this.setProperty(HTTPS_PROXY_PORT, port);
            changed = true;
        }
        if (ServerLocationManager.isGlassFish((File)(sdm = (SunDeploymentManagerInterface)this.si.getDeploymentManager()).getPlatformRoot()) && !nonHosts.equals(this.httpProxyNoHost)) {
            this.setProperty(HTTP_PROXY_NO_HOST, nonHosts);
            changed = true;
        }
        return changed;
    }

    private void initializeProps() {
        for (int i = 0; i < this.options.length; ++i) {
            String option = this.options[i].trim();
            if (option.startsWith(HTTP_PROXY_HOST)) {
                this.httpProxyHost = option.substring(HTTP_PROXY_HOST.length());
                continue;
            }
            if (option.startsWith(HTTP_PROXY_PORT)) {
                this.httpProxyPort = option.substring(HTTP_PROXY_PORT.length());
                continue;
            }
            if (option.startsWith(HTTPS_PROXY_HOST)) {
                this.httpsProxyHost = option.substring(HTTPS_PROXY_HOST.length());
                continue;
            }
            if (option.startsWith(HTTPS_PROXY_PORT)) {
                this.httpsProxyPort = option.substring(HTTPS_PROXY_PORT.length());
                continue;
            }
            if (!option.startsWith(HTTP_PROXY_NO_HOST)) continue;
            this.httpProxyNoHost = option.substring(HTTP_PROXY_NO_HOST.length());
        }
    }

    private void checkProxyInfo(String host, String port) throws Exception {
        try {
            int portNo = Integer.parseInt(port);
            Socket socket = new Socket(host, portNo);
            return;
        }
        catch (Exception ex) {
            String message = MessageFormat.format(this.bundle.getString("Err_InvalidProxyInfo"), host, port);
            throw new Exception(message);
        }
    }
}

