/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.Asenv;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.SunURIManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformFactory;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformImpl;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.CustomizerSupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerProperties {
    public static final String DOMAIN_ATTR = "DOMAIN";
    public static final String HTTP_MONITOR_ATTR = "HttpMonitorOn";
    public static final String HTTP_PROXY_SYNCHED_ATTR = "HttpProxySynced";
    public static final String DIRDEPLOYMENT_POSSIBLE_ATTR = "DirectoryDeploymentPossible";
    public static final String PASSWORD_ATTR = "password";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String LOCATION_ATTR = "LOCATION";
    public static final String HTTP_PORT_NUMBER_ATTR = "httpportnumber";
    public static final String AVK_INSTRUMENTED_ATTR = "AVKTurnedOn";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private InstanceProperties instanceProperties;
    private SunDeploymentManagerInterface SunDM;

    public DeploymentManagerProperties(DeploymentManager deploymentManager) {
        this.SunDM = (SunDeploymentManagerInterface)deploymentManager;
        this.instanceProperties = SunURIManager.getInstanceProperties((File)this.SunDM.getPlatformRoot(), (String)this.SunDM.getHost(), (int)this.SunDM.getPort());
        String httpport = this.SunDM.getNonAdminPortNumber();
        if (httpport == null) {
            httpport = "8080";
        }
        if (this.instanceProperties == null) {
            try {
                this.instanceProperties = SunURIManager.createInstanceProperties((File)this.SunDM.getPlatformRoot(), (String)this.SunDM.getHost(), (String)("" + this.SunDM.getPort()), (String)this.SunDM.getUserName(), (String)this.SunDM.getPassword(), (String)(this.SunDM.getHost() + ":" + this.SunDM.getPort()));
                this.setHttpPortNumber(httpport);
            }
            catch (InstanceCreationException instanceCreationException) {
                // empty catch block
            }
        }
        if (this.instanceProperties.getProperty(HTTP_PORT_NUMBER_ATTR) == null) {
            this.instanceProperties.setProperty(HTTP_PORT_NUMBER_ATTR, httpport);
        }
    }

    public String getDomainName() {
        String retVal = "";
        if (this.instanceProperties == null) {
            return retVal;
        }
        retVal = this.instanceProperties.getProperty(DOMAIN_ATTR);
        if (null == retVal || retVal.trim().length() == 0) {
            retVal = "";
        }
        return retVal;
    }

    public void setDomainName(String domainName) {
        this.instanceProperties.setProperty(DOMAIN_ATTR, domainName);
    }

    public String getLocation() {
        File irf = this.SunDM.getPlatformRoot();
        String installRoot = null;
        if (null != irf && irf.exists()) {
            installRoot = irf.getAbsolutePath();
        }
        if (this.instanceProperties == null) {
            return installRoot;
        }
        String ret = this.instanceProperties.getProperty(LOCATION_ATTR);
        if (ret == null) {
            return installRoot;
        }
        if (ret.equals(installRoot)) {
            String defDomainsDirName;
            String ext = File.separatorChar == '/' ? "conf" : "bat";
            File asenv = new File(installRoot, "config/asenv." + ext);
            Asenv asenvContent = new Asenv(asenv);
            ret = defDomainsDirName = asenvContent.get("AS_DEF_DOMAINS_PATH");
            this.instanceProperties.setProperty(LOCATION_ATTR, ret);
        }
        return ret;
    }

    public void setLocation(String location) {
        if (this.instanceProperties == null) {
            return;
        }
        this.instanceProperties.setProperty(LOCATION_ATTR, location);
    }

    public String getPassword() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty(PASSWORD_ATTR);
    }

    public void setPassword(String password) {
        this.instanceProperties.setProperty(PASSWORD_ATTR, password);
    }

    public String getUserName() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty("username");
    }

    public void setUserName(String UserName) {
        this.instanceProperties.setProperty("username", UserName);
    }

    public String getHttpMonitorOn() {
        if (this.instanceProperties == null) {
            return "false";
        }
        String s = this.instanceProperties.getProperty(HTTP_MONITOR_ATTR);
        if (s == null) {
            return "false";
        }
        return s;
    }

    public void setHttpMonitorOn(String HttpMonitorOn) {
        this.instanceProperties.setProperty(HTTP_MONITOR_ATTR, HttpMonitorOn);
    }

    public String getHttpPortNumber() {
        if (this.instanceProperties == null) {
            return "8080";
        }
        return this.instanceProperties.getProperty(HTTP_PORT_NUMBER_ATTR);
    }

    public void setHttpPortNumber(String port) {
        this.instanceProperties.setProperty(HTTP_PORT_NUMBER_ATTR, port);
    }

    public String getDisplayName() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty(DISPLAY_NAME_ATTR);
    }

    public String getUrl() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty("url");
    }

    public InstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public boolean getAVKOn() {
        if (this.instanceProperties == null) {
            return false;
        }
        String s = this.instanceProperties.getProperty(AVK_INSTRUMENTED_ATTR);
        if (s == null) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    public void setAVKOn(boolean AVKOn) {
        this.instanceProperties.setProperty(AVK_INSTRUMENTED_ATTR, Boolean.toString(AVKOn));
    }

    public void setJavadocs(List<URL> path) {
        this.instanceProperties.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(path));
        PlatformImpl platform = (PlatformImpl)new PlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.SunDM);
        platform.notifyLibrariesChanged();
    }

    public void setSources(List<URL> path) {
        this.instanceProperties.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(path));
        PlatformImpl platform = (PlatformImpl)new PlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.SunDM);
        platform.notifyLibrariesChanged();
    }

    public List<URL> getClasses() {
        ArrayList<URL> data = new ArrayList<URL>();
        PlatformImpl platform = (PlatformImpl)new PlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.SunDM);
        for (LibraryImplementation libImpl : platform.getLibraries()) {
            data.addAll(libImpl.getContent("classpath"));
        }
        return data;
    }

    public List<URL> getSources() {
        String path = this.instanceProperties.getProperty(PROP_SOURCES);
        if (path == null) {
            return new ArrayList<URL>();
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public List<URL> getJavadocs() {
        String path = this.instanceProperties.getProperty(PROP_JAVADOCS);
        if (path == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            try {
                File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee5-doc-api.zip", null, false);
                if (j2eeDoc != null) {
                    list.add(DeploymentManagerProperties.fileToUrl(j2eeDoc));
                }
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return list;
        }
        return CustomizerSupport.tokenizePath(path);
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    public boolean isSyncHttpProxyOn() {
        if (this.instanceProperties == null) {
            return true;
        }
        String s = this.instanceProperties.getProperty(HTTP_PROXY_SYNCHED_ATTR);
        if (s == null) {
            return true;
        }
        return Boolean.valueOf(s);
    }

    public void setSyncHttpProxyOn(boolean syncHttpProxyOn) {
        this.instanceProperties.setProperty(HTTP_PROXY_SYNCHED_ATTR, Boolean.toString(syncHttpProxyOn));
    }

    public boolean isDirectoryDeploymentPossible() {
        if (this.instanceProperties == null) {
            return true;
        }
        String s = this.instanceProperties.getProperty(DIRDEPLOYMENT_POSSIBLE_ATTR);
        if (s == null) {
            return true;
        }
        return Boolean.valueOf(s);
    }

    public void setDirectoryDeploymentPossible(boolean dirpossible) {
        this.instanceProperties.setProperty(DIRDEPLOYMENT_POSSIBLE_ATTR, Boolean.toString(dirpossible));
    }
}

