/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DomainEditor;
import org.w3c.dom.Document;

public class ConfigureProfiler {
    private static final String ASENV_INSERTION_POINT_WIN_STRING = "set AS_JAVA";
    private static final String ASENV_INSERTION_POINT_NOWIN_STRING = "AS_JAVA";

    public static boolean instrumentProfilerInDOmain(DeploymentManager dm, String nativeLibraryPath, String[] jvmOptions) {
        DomainEditor dEditor = new DomainEditor(dm);
        Document domainDocument = dEditor.getDomainDocument();
        if (domainDocument == null) {
            return false;
        }
        return dEditor.addProfilerElements(domainDocument, nativeLibraryPath, jvmOptions);
    }

    public static boolean removeProfilerFromDomain(DeploymentManager dm) {
        DomainEditor dEditor = new DomainEditor(dm);
        Document domainDocument = dEditor.getDomainDocument();
        if (domainDocument == null) {
            return false;
        }
        return dEditor.removeProfilerElements(domainDocument);
    }

    public static boolean modifyAsEnvScriptFile(SunDeploymentManagerInterface dm, String targetJavaHomePath) {
        String ext = ConfigureProfiler.isUnix() ? "conf" : "bat";
        File irf = dm.getPlatformRoot();
        if (null == irf || !irf.exists()) {
            return false;
        }
        String installRoot = irf.getAbsolutePath();
        String asEnvScriptFilePath = installRoot + "/config/asenv." + ext;
        File asEnvScriptFile = new File(asEnvScriptFilePath);
        String lineBreak = System.getProperty("line.separator");
        try {
            String line;
            String asJavaString;
            FileReader fr = new FileReader(asEnvScriptFile);
            BufferedReader br = new BufferedReader(fr);
            StringBuffer buffer = new StringBuffer();
            String string = asJavaString = ConfigureProfiler.isUnix() ? ASENV_INSERTION_POINT_NOWIN_STRING : ASENV_INSERTION_POINT_WIN_STRING;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith(asJavaString)) {
                    buffer.append(asJavaString + "=" + targetJavaHomePath);
                } else {
                    buffer.append(line);
                }
                buffer.append(lineBreak);
            }
            br.close();
            FileWriter fw = new FileWriter(asEnvScriptFile);
            fw.write(buffer.toString());
            fw.flush();
            fw.close();
            if (ConfigureProfiler.isUnix()) {
                Runtime.getRuntime().exec("chmod a+r " + asEnvScriptFile.getAbsolutePath());
            }
            return true;
        }
        catch (Exception ex) {
            System.err.println("Modifying " + asEnvScriptFilePath + " failed!\n" + ex.getMessage());
            return false;
        }
    }

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }
}

