/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private String expression;

    public String getShortDescription() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        AntDebugger d = (AntDebugger)((Object)currentEngine.lookupFirst(null, AntDebugger.class));
        if (d == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            StyledDocument doc = ec.openDocument();
            JEditorPane ep = ToolTipAnnotation.getCurrentEditor();
            if (ep == null) {
                return null;
            }
            this.expression = ToolTipAnnotation.getIdentifier(doc, ep, NbDocument.findLineOffset((StyledDocument)doc, (int)lp.getLine().getLineNumber()) + lp.getColumn());
            if (this.expression == null) {
                return null;
            }
            RequestProcessor.getDefault().post((Runnable)this);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public void run() {
        if (this.expression == null) {
            return;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return;
        }
        AntDebugger d = (AntDebugger)((Object)currentEngine.lookupFirst(null, AntDebugger.class));
        if (d == null) {
            return;
        }
        String value = d.evaluate(this.expression);
        if (value == null || value.equals(this.expression)) {
            return;
        }
        String toolTipText = this.expression + " = " + value;
        this.firePropertyChange("shortDescription", null, toolTipText);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            lineLen = t.length();
            for (identStart = col; identStart > 0 && t.charAt(identStart - 1) != '\"'; --identStart) {
            }
            for (identEnd = Math.max(col, 1); identEnd < lineLen && t.charAt(identEnd - 1) != '\"'; ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd - 1);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    static JEditorPane getCurrentEditor() {
        EditorCookie e = ToolTipAnnotation.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    private static EditorCookie getCurrentEditorCookie() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        Node n = nodes[0];
        return (EditorCookie)n.getCookie(EditorCookie.class);
    }
}

