/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.Length";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private int maximum = 0;
    private boolean maximumSet = false;
    private int minimum = 0;
    private boolean minimumSet = false;
    private boolean transientValue = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        this.setMaximum(maximum);
    }

    public LengthValidator(int maximum, int minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.maximumSet = true;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.minimumSet = true;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            String converted = this.stringValue(value);
            if (this.maximumSet && converted.length() > this.maximum) {
                throw new ValidatorException(MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, new Object[]{this.integerToString(component, new Integer(this.maximum))}));
            }
            if (this.minimumSet && converted.length() < this.minimum) {
                throw new ValidatorException(MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, new Object[]{this.integerToString(component, new Integer(this.minimum))}));
            }
        }
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof LengthValidator)) {
            return false;
        }
        LengthValidator other = (LengthValidator)otherObj;
        return this.maximum == other.maximum && this.minimum == other.minimum && this.maximumSet == other.maximumSet && this.minimumSet == other.minimumSet;
    }

    private String stringValue(Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof String) {
            return (String)attributeValue;
        }
        return attributeValue.toString();
    }

    private String integerToString(UIComponent component, Integer toConvert) {
        String result = null;
        Converter converter = null;
        FacesContext context = FacesContext.getCurrentInstance();
        converter = context.getApplication().createConverter("javax.faces.Number");
        result = converter.getAsString(context, component, toConvert);
        return result;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{new Integer(this.maximum), this.maximumSet ? Boolean.TRUE : Boolean.FALSE, new Integer(this.minimum), this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Integer)values[0];
        this.maximumSet = (Boolean)values[1];
        this.minimum = (Integer)values[2];
        this.minimumSet = (Boolean)values[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

