/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.STATE_SAVING_METHOD";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    private Boolean savingStateInClient = null;

    public abstract SerializedView saveSerializedView(FacesContext var1);

    protected abstract Object getTreeStructureToSave(FacesContext var1);

    protected abstract Object getComponentStateToSave(FacesContext var1);

    public abstract void writeState(FacesContext var1, SerializedView var2) throws IOException;

    public abstract UIViewRoot restoreView(FacesContext var1, String var2, String var3);

    protected abstract UIViewRoot restoreTreeStructure(FacesContext var1, String var2, String var3);

    protected abstract void restoreComponentState(FacesContext var1, UIViewRoot var2, String var3);

    public boolean isSavingStateInClient(FacesContext context) {
        if (null != this.savingStateInClient) {
            return this.savingStateInClient;
        }
        this.savingStateInClient = Boolean.FALSE;
        String saveStateParam = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (saveStateParam != null && saveStateParam.equalsIgnoreCase(STATE_SAVING_METHOD_CLIENT)) {
            this.savingStateInClient = Boolean.TRUE;
        }
        return this.savingStateInClient;
    }

    public class SerializedView {
        private Object structure = null;
        private Object state = null;

        public SerializedView(Object newStructure, Object newState) {
            this.structure = newStructure;
            this.state = newState;
        }

        public Object getStructure() {
            return this.structure;
        }

        public Object getState() {
            return this.state;
        }
    }
}

