/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.filesystems.FileObject;

public abstract class AbstractMethodController
extends EjbMethodController {
    private EntityAndSession model;
    private ClassPath cp;
    protected Set classesForSave;
    private int transactionLevel = 0;
    private boolean writeTransactionRollBack = false;
    private boolean simplified = false;

    public AbstractMethodController(EntityAndSession model, ClassPath cp) {
        this.model = model;
        this.cp = cp;
        this.simplified = model.getRoot().getVersion().doubleValue() > 2.1;
    }

    public abstract GenerateFromImpl createGenerateFromImpl();

    public abstract GenerateFromIntf createGenerateFromIntf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createAndAdd(Method clientView, boolean local, boolean isComponent) {
        JavaClass home = null;
        JavaClass component = null;
        Method methodToOpen = null;
        boolean rollback = true;
        this.beginWriteJmiTransaction();
        try {
            if (local) {
                home = JMIUtils.findClass((String)this.model.getLocalHome(), (ClassPath)this.cp);
                component = this.businessInterface(this.model.getLocal());
            } else {
                home = JMIUtils.findClass((String)this.model.getHome(), (ClassPath)this.cp);
                component = this.businessInterface(this.model.getRemote());
            }
            if (isComponent) {
                this.registerClassForSave(component);
                component.getContents().add(clientView);
            } else {
                this.registerClassForSave(home);
                home.getContents().add(clientView);
            }
            JavaClass bc = JMIUtils.findClass((String)this.model.getEjbClass(), (ClassPath)this.cp);
            if (this.hasJavaImplementation(clientView)) {
                List implMethods = this.getImplementationMethods(clientView);
                for (Method me : implMethods) {
                    if (JMIUtils.findInClass((Method)me, (JavaClass)bc) != null) continue;
                    this.registerClassForSave(bc);
                    TypeReference typeReference = JavaModelUtil.resolveImportsForType((Element)bc, (Type)me.getType());
                    me.setTypeName(typeReference);
                    bc.getContents().add(me);
                    methodToOpen = me;
                    for (Parameter param : me.getParameters()) {
                        JavaModelUtil.resolveImportsForType((Element)bc, (Type)param.getType());
                    }
                }
            }
            TypeReference typeReference = JavaModelUtil.resolveImportsForType((Element)(isComponent ? component : home), (Type)clientView.getType());
            clientView.setTypeName(typeReference);
            if (!local && !this.simplified) {
                this.addExceptionIfNecessary(clientView, RemoteException.class.getName());
            }
            JMIUtils.fixImports((JavaClass)component);
            JMIUtils.fixImports((JavaClass)home);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
        if (methodToOpen != null) {
            StatementBlock stBlock = null;
            JMIUtils.beginJmiTransaction();
            try {
                if (methodToOpen.isValid()) {
                    stBlock = methodToOpen.getBody();
                }
            }
            finally {
                JMIUtils.endJmiTransaction();
            }
            if (stBlock != null) {
                JMIUtils.openInEditor((Element)stBlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createAndAddInterface(Method beanImpl, boolean local) {
        this.beginWriteJmiTransaction();
        boolean rollback = false;
        try {
            MethodType t = this.getMethodTypeFromImpl(beanImpl);
            GenerateFromImpl v = this.createGenerateFromImpl();
            JavaClass home = null;
            JavaClass component = null;
            if (local) {
                home = JMIUtils.findClass((String)this.model.getLocalHome(), (ClassPath)this.cp);
                component = this.businessInterface(this.model.getLocal());
            } else {
                home = JMIUtils.findClass((String)this.model.getHome(), (ClassPath)this.cp);
                component = this.businessInterface(this.model.getRemote());
            }
            this.registerClassForSave(home);
            this.registerClassForSave(component);
            v.getInterfaceMethodFromImpl(t, home, component);
            Method me = v.getInterfaceMethod();
            if (!local && !this.simplified) {
                this.addExceptionIfNecessary(me, RemoteException.class.getName());
            }
            me.setModifiers(0);
            JavaClass destinationInterface = v.getDestinationInterface();
            this.registerClassForSave(destinationInterface);
            destinationInterface.getContents().add(me);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createAndAddImpl(Method intfView) {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            MethodType t = this.getMethodTypeFromInterface(intfView);
            GenerateFromIntf v = this.createGenerateFromIntf();
            v.getInterfaceMethodFromImpl(t);
            Method bcm = v.getImplMethod();
            JavaClass bc = JMIUtils.findClass((String)this.model.getEjbClass(), (ClassPath)this.cp);
            this.registerClassForSave(bc);
            bc.getContents().add(bcm);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    private List getImplementationMethods(Method intfView) {
        MethodType t = this.getMethodTypeFromInterface(intfView);
        GenerateFromIntf v = this.createGenerateFromIntf();
        v.getInterfaceMethodFromImpl(t);
        Method primary = v.getImplMethod();
        Method secondary = v.getSecondaryMethod();
        List<Method> rv = null;
        rv = secondary != null ? Arrays.asList(primary, secondary) : Collections.singletonList(primary);
        return rv;
    }

    public final List getImplementation(Method intfView) {
        List methods = this.getImplementationMethods(intfView);
        ArrayList<Method> l = new ArrayList<Method>(methods.size());
        for (Method m : methods) {
            l.add(JMIUtils.findInClass((Method)m, (JavaClass)this.getBeanClass()));
        }
        return l;
    }

    public final Method getInterface(Method beanImpl, boolean local) {
        MethodType t = this.getMethodTypeFromImpl(beanImpl);
        assert (t != null) : "method cannot be used in interface";
        GenerateFromImpl v = this.createGenerateFromImpl();
        JavaClass home = null;
        JavaClass component = null;
        if (local) {
            home = JMIUtils.findClass((String)this.model.getLocalHome(), (ClassPath)this.cp);
            component = this.businessInterface(this.model.getLocal());
        } else {
            home = JMIUtils.findClass((String)this.model.getHome(), (ClassPath)this.cp);
            component = this.businessInterface(this.model.getRemote());
        }
        v.getInterfaceMethodFromImpl(t, home, component);
        return JMIUtils.findInClass((Method)v.getInterfaceMethod(), (JavaClass)v.getDestinationInterface());
    }

    public boolean hasMethodInInterface(Method m, MethodType methodType, boolean local) {
        boolean result = false;
        JavaClass intf = null;
        Method wantedMethod = JMIUtils.duplicate((Method)m);
        if (methodType instanceof MethodType.BusinessMethodType) {
            intf = this.findBusinessInterface(local ? this.model.getLocal() : this.model.getRemote());
        } else if (methodType instanceof MethodType.CreateMethodType) {
            wantedMethod.setName(this.chopAndUpper(m.getName(), "ejb"));
            wantedMethod.setType((Type)this.findJavaClass(local ? this.model.getLocal() : this.model.getRemote()));
            intf = this.findJavaClass(local ? this.model.getLocalHome() : this.model.getHome());
        }
        if (wantedMethod.getName() == null || intf == null || wantedMethod.getType() == null) {
            return true;
        }
        for (Feature f : intf.getFeatures()) {
            if (!(f instanceof Method) || !JMIUtils.equalMethods((Method)wantedMethod, (Method)((Method)f))) continue;
            result = true;
            break;
        }
        return result;
    }

    private JavaClass findJavaClass(String clzName) {
        Resource res;
        FileObject clzFo = this.cp.findResource(clzName.replace('.', '/') + ".java");
        Resource resource = res = clzFo != null ? JavaModel.getResource((FileObject)clzFo) : null;
        if (res != null) {
            List classes = res.getClassifiers();
            assert (classes.size() == 1) : "" + res + " should contain just one class";
            JavaClass beani = (JavaClass)classes.get(0);
            return beani;
        }
        return null;
    }

    private String chopAndUpper(String fullName, String chop) {
        StringBuffer sb = new StringBuffer(fullName);
        sb.delete(0, chop.length());
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    private void addExceptionIfNecessary(Method me, String exceptionName) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)me.refImmediatePackage();
        MultipartId exceptionMultipartId = javaModelPackage.getMultipartId().createMultipartId(exceptionName, null, null);
        if (!me.getExceptionNames().contains(exceptionMultipartId)) {
            JMIUtils.addException((Method)me, (String)exceptionName);
        }
    }

    private JavaClass businessInterface(String compInterfaceName) {
        JavaClass compInterface = JMIUtils.findClass((String)compInterfaceName, (ClassPath)this.cp);
        JavaClass beanClass = JMIUtils.findClass((String)this.model.getEjbClass(), (ClassPath)this.cp);
        if (compInterface == null || beanClass == null) {
            return null;
        }
        List beanInterfaces = this.buildInterfaces(beanClass.getInterfaces());
        List compInterfaces = this.buildInterfaces(compInterface.getInterfaces());
        compInterfaces.retainAll(beanInterfaces);
        if (compInterfaces.isEmpty()) {
            return compInterface;
        }
        JavaClass business = JMIUtils.findClass((String)compInterfaces.get(0).toString(), (ClassPath)this.cp);
        return business == null ? compInterface : business;
    }

    private JavaClass findBusinessInterface(String compInterfaceName) {
        JavaClass compInterface = this.findJavaClass(compInterfaceName);
        JavaClass beanClass = this.findJavaClass(this.model.getEjbClass());
        if (compInterface == null || beanClass == null) {
            return null;
        }
        List beanInterfaces = beanClass.getInterfaces();
        List compInterfaces = compInterface.getInterfaces();
        JavaClass business = null;
        for (int i = 0; i < compInterfaces.size(); ++i) {
            Object o = compInterfaces.get(i);
            if (!beanInterfaces.contains(o)) continue;
            business = (JavaClass)o;
            break;
        }
        return business == null ? compInterface : business;
    }

    private List buildInterfaces(List interfaces) {
        JavaClass[] interfacesArray = interfaces.toArray(new JavaClass[interfaces.size()]);
        ArrayList<String> l = new ArrayList<String>(interfacesArray.length);
        for (int i = 0; i < interfacesArray.length; ++i) {
            l.add(interfacesArray[i].getName());
        }
        return l;
    }

    public final JavaClass getBeanClass() {
        return this.model.getEjbClass() == null ? null : JMIUtils.findClass((String)this.model.getEjbClass(), (ClassPath)this.cp);
    }

    public final Collection getLocalInterfaces() {
        if (!this.hasLocal()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JavaClass> l = new ArrayList<JavaClass>(2);
        if (this.model.getLocalHome() != null) {
            l.add(JMIUtils.findClass((String)this.model.getLocalHome(), (ClassPath)this.cp));
        }
        if (this.model.getLocal() != null) {
            l.add(this.businessInterface(this.model.getLocal()));
        }
        return l;
    }

    public final Collection getRemoteInterfaces() {
        if (!this.hasRemote()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JavaClass> l = new ArrayList<JavaClass>(2);
        if (this.model.getHome() != null) {
            l.add(JMIUtils.findClass((String)this.model.getHome(), (ClassPath)this.cp));
        }
        if (this.model.getRemote() != null) {
            l.add(this.businessInterface(this.model.getRemote()));
        }
        return l;
    }

    public final void delete(Method interfaceMethod, boolean local) {
        boolean checkOther;
        List impls = this.getImplementation(interfaceMethod);
        boolean bl = checkOther = local ? this.hasRemote() : this.hasLocal();
        if (!impls.isEmpty()) {
            for (Method impl : impls) {
                if (impl == null || (!checkOther || this.getInterface(impl, !local) != null) && checkOther) continue;
                impl.getDeclaringClass().getContents().remove(impl);
            }
            interfaceMethod.getDeclaringClass().getContents().remove(interfaceMethod);
        }
    }

    public boolean hasRemote() {
        String intf = this.model.getHome();
        if (!(this.simplified || intf != null && this.findJavaClass(intf) != null)) {
            return false;
        }
        intf = this.model.getRemote();
        return intf != null && this.findBusinessInterface(intf) != null;
    }

    public boolean hasLocal() {
        String intf = this.model.getLocalHome();
        if (!(this.simplified || intf != null && this.findJavaClass(intf) != null)) {
            return false;
        }
        intf = this.model.getLocal();
        return intf != null && this.findBusinessInterface(intf) != null;
    }

    public Method getPrimaryImplementation(Method intfView) {
        List impls = this.getImplementation(intfView);
        return impls.isEmpty() ? null : (Method)impls.get(0);
    }

    public String getRemote() {
        return this.model.getRemote();
    }

    public String getLocal() {
        return this.model.getLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMethod(Method method, boolean local, boolean isComponent) {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            method = JMIUtils.duplicate((Method)method);
            JavaClass javaClass = this.getBeanInterface(local, isComponent);
            assert (javaClass != null);
            this.registerClassForSave(javaClass);
            javaClass.getContents().add(method);
            if (!local) {
                this.addExceptionIfNecessary(method, RemoteException.class.getName());
            }
            this.createBeanMethod(method);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    public JavaClass getBeanInterface(boolean local, boolean isComponent) {
        if (isComponent) {
            return this.businessInterface(local ? this.model.getLocal() : this.model.getRemote());
        }
        String className = local ? this.model.getLocalHome() : this.model.getHome();
        return JMIUtils.findClass((String)className, (ClassPath)this.cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBeanMethod(Method method) {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            JavaClass beanClass = JMIUtils.findClass((String)this.model.getEjbClass(), (ClassPath)this.cp);
            if (this.hasJavaImplementation(method)) {
                List implMethods = this.getImplementationMethods(method);
                for (Method me : implMethods) {
                    if (JMIUtils.findInClass((Method)me, (JavaClass)beanClass) != null) continue;
                    beanClass.getContents().add(me);
                }
            }
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMethod(Method method, boolean local, boolean isComponent) {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            JavaClass javaClass = this.getBeanInterface(local, isComponent);
            assert (javaClass != null);
            this.registerClassForSave(javaClass);
            if (!local) {
                this.addExceptionIfNecessary(method, RemoteException.class.getName());
            }
            javaClass.getContents().remove(method);
            this.createBeanMethod(method);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateMethod(Method method, boolean local, boolean isComponent, boolean shouldExist) {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            JavaClass javaClass = this.getBeanInterface(local, isComponent);
            assert (javaClass != null);
            this.registerClassForSave(javaClass);
            Method m = JMIUtils.findInClass((Method)method, (JavaClass)javaClass);
            List contents = javaClass.getContents();
            if (shouldExist) {
                if (m == null) {
                    if (!local) {
                        this.addExceptionIfNecessary(method, RemoteException.class.getName());
                    }
                    contents.add(method);
                }
            } else if (m != null) {
                contents.remove(m);
            }
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    public void beginWriteJmiTransaction() {
        if (this.transactionLevel++ == 0) {
            this.writeTransactionRollBack = false;
            this.classesForSave = new HashSet();
            JMIUtils.beginJmiTransaction((boolean)true);
        }
    }

    public void endWriteJmiTransaction(boolean rollback) {
        boolean bl = this.writeTransactionRollBack = this.writeTransactionRollBack || rollback;
        if (--this.transactionLevel == 0) {
            JMIUtils.endJmiTransaction((boolean)this.writeTransactionRollBack);
            if (!this.writeTransactionRollBack) {
                this.saveModifiedClasses();
            }
        }
    }

    public void registerClassForSave(JavaClass javaClass) {
        if (this.transactionLevel > 0 && javaClass != null && !Utils.isModified(javaClass)) {
            this.classesForSave.add(javaClass);
        }
    }

    private void saveModifiedClasses() {
        for (JavaClass javaClass : this.classesForSave) {
            if (!Utils.isModified(javaClass)) continue;
            Utils.save(javaClass);
        }
    }

    public static interface GenerateFromIntf {
        public void getInterfaceMethodFromImpl(MethodType var1);

        public Method getImplMethod();

        public Method getSecondaryMethod();
    }

    public static interface GenerateFromImpl {
        public void getInterfaceMethodFromImpl(MethodType var1, JavaClass var2, JavaClass var3);

        public JavaClass getDestinationInterface();

        public Method getInterfaceMethod();
    }
}

