/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeAppProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class Utils {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    public static String toClasspathString(File[] classpathEntries) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpath.append(classpathEntries[i].getAbsolutePath());
            if (i + 1 >= classpathEntries.length) continue;
            classpath.append(":");
        }
        return classpath.toString();
    }

    public static void notifyError(Exception ex) {
        NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
    }

    public static void mergeSteps(WizardDescriptor wizard, WizardDescriptor.Panel[] panels, String[] steps) {
        int offset;
        String[] beforeSteps;
        Object prop = wizard.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            offset = beforeSteps.length;
            if (offset > 0 && "...".equals(beforeSteps[offset - 1])) {
                --offset;
            }
        } else {
            beforeSteps = null;
            offset = 0;
        }
        String[] resultSteps = new String[offset + panels.length];
        for (int i = 0; i < offset; ++i) {
            resultSteps[i] = beforeSteps[i];
        }
        Utils.setSteps(panels, steps, resultSteps, offset);
    }

    private static void setSteps(WizardDescriptor.Panel[] panels, String[] steps, String[] resultSteps, int offset) {
        int n = steps == null ? 0 : steps.length;
        for (int i = 0; i < panels.length; ++i) {
            String step;
            JComponent component = (JComponent)panels[i].getComponent();
            String string = step = i < n ? steps[i] : null;
            if (step == null) {
                step = component.getName();
            }
            component.putClientProperty(WIZARD_PANEL_CONTENT_DATA, resultSteps);
            component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(i));
            component.getAccessibleContext().setAccessibleDescription(step);
            resultSteps[i + offset] = step;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panels, String[] steps) {
        Utils.setSteps(panels, steps, steps, 0);
    }

    public static void save(JavaClass jc) {
        if (jc == null) {
            return;
        }
        SaveCookie saveCookie = (SaveCookie)JMIUtils.getCookie((Feature)jc, SaveCookie.class);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(4096, (Throwable)ioe);
            }
        }
    }

    public static boolean isModified(JavaClass ce) {
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(ce.getResource());
        assert (dataObject != null) : "DataObject not found for " + ce.getName();
        return dataObject.isModified();
    }

    public static boolean areInSameJ2EEApp(Project p1, Project p2) {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            List<J2eeModuleProvider> childModules;
            J2eeAppProvider j2eeApp;
            J2eeModuleProvider[] j2eeModules;
            Project project = openProjects[i];
            Object j2eeAppProvider = project.getLookup().lookup(J2eeAppProvider.class);
            if (j2eeAppProvider == null || (j2eeModules = (j2eeApp = (J2eeAppProvider)j2eeAppProvider).getChildModuleProviders()) == null || j2eeModules.length <= 0) continue;
            J2eeModuleProvider affectedPrjProvider1 = (J2eeModuleProvider)p1.getLookup().lookup(J2eeModuleProvider.class);
            J2eeModuleProvider affectedPrjProvider2 = (J2eeModuleProvider)p2.getLookup().lookup(J2eeModuleProvider.class);
            if (affectedPrjProvider1 == null || affectedPrjProvider2 == null || !(childModules = Arrays.asList(j2eeModules)).contains(affectedPrjProvider1) || !childModules.contains(affectedPrjProvider2)) continue;
            return true;
        }
        return false;
    }

    public static boolean canExposeInLocal(Method me) {
        boolean signatureOk;
        boolean bl = signatureOk = Modifier.isPublic(me.getModifiers()) && !Modifier.isProtected(me.getModifiers()) && !Modifier.isPrivate(me.getModifiers()) && !Modifier.isStatic(me.getModifiers());
        if (signatureOk) {
            ClassDefinition clzDef = me.getDeclaringClass();
            EjbMethodController c = clzDef instanceof JavaClass ? EjbMethodController.createFromClass((JavaClass)clzDef) : null;
            return c != null && c.hasLocal() && !c.hasMethodInInterface(me, c.getMethodTypeFromImpl(me), true);
        }
        return false;
    }

    public static void exposeInLocal(Method method) {
        EjbMethodController c = EjbMethodController.create((Feature)method);
        c.createAndAddInterface(method, true);
    }

    public static boolean canExposeInRemote(Method me) {
        boolean signatureOk;
        boolean bl = signatureOk = Modifier.isPublic(me.getModifiers()) && !Modifier.isProtected(me.getModifiers()) && !Modifier.isPrivate(me.getModifiers()) && !Modifier.isStatic(me.getModifiers());
        if (signatureOk) {
            ClassDefinition clzDef = me.getDeclaringClass();
            EjbMethodController c = clzDef instanceof JavaClass ? EjbMethodController.createFromClass((JavaClass)clzDef) : null;
            return c != null && c.hasRemote() && !c.hasMethodInInterface(me, c.getMethodTypeFromImpl(me), false);
        }
        return false;
    }

    public static void exposeInRemote(Method me) {
        EjbMethodController c = EjbMethodController.create((Feature)me);
        c.createAndAddInterface(me, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReference(JavaClass beanClass, EjbReference ref, String serviceLocator, boolean remote, boolean throwExceptions, String ejbRefName, Project nodeProject) {
        FileObject srcFile = JavaModel.getFileObject((Resource)beanClass.getResource());
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)srcFile);
        try {
            EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)enterpriseProject.getLookup().lookup(EnterpriseReferenceContainer.class);
            boolean enterpriseProjectIsJavaEE5 = Utils.isJavaEE5orHigher(enterpriseProject);
            boolean nodeProjectIsJavaEE5 = Utils.isJavaEE5orHigher(nodeProject);
            if (remote) {
                EjbRef ejbRef = ref.createRef();
                if (ejbRefName != null) {
                    ejbRef.setEjbRefName(ejbRefName);
                }
                if (enterpriseProjectIsJavaEE5 && InjectionTargetQuery.isInjectionTarget((JavaClass)beanClass)) {
                    Utils.addProjectToClassPath(enterpriseProject, ref);
                } else if (nodeProjectIsJavaEE5 == enterpriseProjectIsJavaEE5) {
                    erc.addEjbReferernce(ejbRef, beanClass.getName(), ref.getClientJarTarget());
                }
                if (serviceLocator == null) {
                    Feature f = ref.generateReferenceCode(beanClass, ejbRef, throwExceptions);
                } else {
                    ref.generateServiceLocatorLookup(beanClass, ejbRef, serviceLocator, throwExceptions);
                }
            } else {
                EjbLocalRef ejbLocalRef = ref.createLocalRef();
                if (ejbRefName != null) {
                    ejbLocalRef.setEjbRefName(ejbRefName);
                }
                if (enterpriseProjectIsJavaEE5 && InjectionTargetQuery.isInjectionTarget((JavaClass)beanClass)) {
                    Utils.addProjectToClassPath(enterpriseProject, ref);
                } else if (nodeProjectIsJavaEE5 == enterpriseProjectIsJavaEE5) {
                    erc.addEjbLocalReference(ejbLocalRef, beanClass.getName(), ref.getClientJarTarget());
                }
                if (serviceLocator == null) {
                    Feature f = ref.generateReferenceCode(beanClass, ejbLocalRef, throwExceptions);
                } else {
                    ref.generateServiceLocatorLookup(beanClass, ejbLocalRef, serviceLocator, throwExceptions);
                }
            }
            if (serviceLocator != null) {
                erc.setServiceLocatorName(serviceLocator);
            }
            boolean failed = true;
            JavaModel.getJavaRepository().beginTrans(true);
            try {
                JMIUtils.fixImports((JavaClass)beanClass);
                failed = false;
            }
            finally {
                JavaModel.getJavaRepository().endTrans(failed);
            }
        }
        catch (IOException ioe) {
            Utils.notifyError(ioe);
        }
        catch (JmiException jmie) {
            ErrorManager.getDefault().notify((Throwable)jmie);
        }
    }

    private static void addProjectToClassPath(Project enterpriseProject, EjbReference ref) throws IOException {
        ProjectClassPathExtender pcpe;
        boolean differentProject;
        AntArtifact target = ref.getClientJarTarget();
        boolean bl = differentProject = target != null && !enterpriseProject.equals(target.getProject());
        if (differentProject && (pcpe = (ProjectClassPathExtender)enterpriseProject.getLookup().lookup(ProjectClassPathExtender.class)) != null) {
            URI[] locations = target.getArtifactLocations();
            for (int i = 0; i < locations.length; ++i) {
                pcpe.addAntArtifact(target, locations[i]);
            }
        }
    }

    public static Project[] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        boolean isCallerEJBModule = false;
        J2eeModuleProvider callerJ2eeModuleProvider = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        if (callerJ2eeModuleProvider != null && callerJ2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            isCallerEJBModule = true;
        }
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> filteredResults = new ArrayList<Project>(allProjects.length);
        for (int i = 0; i < allProjects.length; ++i) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                isEJBModule = true;
            }
            if ((!isEJBModule || isCallerFreeform) && (!isCallerFreeform || !enterpriseProject.equals(allProjects[i]))) continue;
            filteredResults.add(allProjects[i]);
        }
        return filteredResults.toArray(new Project[filteredResults.size()]);
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            Object type = j2eeModule.getModuleType();
            double version = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.EJB.equals(type) && version > 2.1) {
                return true;
            }
            if (J2eeModule.WAR.equals(type) && version > 2.4) {
                return true;
            }
            if (J2eeModule.CLIENT.equals(type) && version > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAppClient(Project project) {
        J2eeModuleProvider module = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return module != null ? module.getJ2eeModule().getModuleType().equals(J2eeModule.CLIENT) : false;
    }

    public static boolean isTargetJavaSE(JavaClass target) {
        Project owner = FileOwnerQuery.getOwner((FileObject)JavaModel.getFileObject((Resource)target.getResource()));
        if (owner.getLookup().lookup(J2eeModuleProvider.class) == null) {
            return true;
        }
        return Utils.extendsTestCase(target);
    }

    private static boolean extendsTestCase(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        if (javaClass.getName().equals("junit.framework.TestCase")) {
            return true;
        }
        return Utils.extendsTestCase(javaClass.getSuperClass());
    }

    public static String jndiNameToCamelCase(String jndiName, boolean lowerCaseFirstChar, String prefixToStrip) {
        if (prefixToStrip != null && jndiName.startsWith(prefixToStrip)) {
            jndiName = jndiName.substring(jndiName.indexOf(prefixToStrip) + prefixToStrip.length());
        }
        StringBuilder result = new StringBuilder();
        for (String token : jndiName.split("/")) {
            if (token.length() == 0) continue;
            char firstChar = token.charAt(0);
            firstChar = lowerCaseFirstChar && result.length() == 0 && !Utils.isAllUpperCase(token) ? Character.toLowerCase(firstChar) : Character.toUpperCase(firstChar);
            result.append(firstChar);
            result.append(token.substring(1));
        }
        return result.toString();
    }

    private static boolean isAllUpperCase(String str) {
        if (str.length() <= 1) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsFeature(JavaClass javaClass, Feature feature) {
        for (Feature existing : javaClass.getFeatures()) {
            String name = existing.getName();
            if (name == null || !name.equals(feature.getName())) continue;
            return true;
        }
        return false;
    }
}

