/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.test;

import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.netbeans.lib.gjast.ASIdent;
import org.netbeans.lib.gjast.ASLiteral;
import org.netbeans.lib.gjast.ASParser;
import org.netbeans.lib.gjast.ASTypeArray;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.lib.java.parser.JParser;
import org.netbeans.lib.java.parser.Parser;
import org.netbeans.lib.java.parser.SymbolInfo;
import org.netbeans.lib.java.parser.Token;

public final class DumpASTree {
    public static String dumpDir = System.getProperty("test.dump.dir", "test_dumps");
    public static boolean dumpSymbols = Boolean.getBoolean("gjast.dump.symbols");

    public static void main(String[] args) {
        String sourceLevel = "1.5";
        if (args.length == 0) {
            System.err.println("java DumpASTree [-source <level>] <file> [<file> ...]");
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-source")) {
                sourceLevel = args[i + 1];
                i += 2;
                continue;
            }
            DumpASTree.dump(args[i++], sourceLevel);
        }
    }

    private DumpASTree() {
    }

    public static void dump(String filename, String sourceLevel) {
        try {
            FileReader fileIn = new FileReader(filename);
            char[] src = DumpASTree.readInChars(fileIn);
            CharArrayReader in = new CharArrayReader(src);
            MiniContext ctx = new MiniContext(src, sourceLevel);
            ASParser parser = new ASParser(ctx, in, filename);
            ctx.setParser(parser);
            parser.parse(dumpSymbols);
            DumpASTree.dump(filename, parser, src);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void dump(String filename, ASParser newParser, char[] src) {
        try {
            File dir = new File(dumpDir);
            dir.mkdir();
            if (!dumpSymbols) {
                JParser oldParser = DumpASTree.makeOldParser(src);
                int nerrors = oldParser.parse(false);
                if (nerrors == 0) {
                    DumpASTree.dumpASTree(oldParser, filename + ".old");
                } else {
                    System.err.println("old parser failed: " + nerrors + " errors");
                }
            }
            DumpASTree.dumpASTree(newParser, filename + ".new");
        }
        catch (Exception e) {
            System.err.println("failed writing ASTree logs: ");
            e.printStackTrace();
        }
    }

    private static JParser makeOldParser(char[] src) {
        CharArrayReader reader = new CharArrayReader(src);
        MiniContext ctx = new MiniContext(src, "1.4");
        Parser oldParser = new Parser((ASTContext)ctx, (Reader)reader, null);
        ctx.setParser((JParser)oldParser);
        return oldParser;
    }

    public static void dumpASTree(JParser jp, String filename) throws IOException {
        filename = new File(filename).getName();
        ASTree tree = jp.getASTree();
        File dir = new File(dumpDir);
        File f = new File(dir, filename);
        FileOutputStream fos = new FileOutputStream(f);
        PrintStream out = new PrintStream(new BufferedOutputStream(fos, 4096));
        DumpASTree.printASTree(tree, out, 1);
        out.println();
        DumpASTree.dumpTokens(tree, jp, out);
        out.flush();
        fos.close();
    }

    private static void printASTree(ASTree tree, PrintStream out, int indent) {
        try {
            DumpASTree.printIndent(out, indent);
            if (tree == null) {
                out.println("null");
            } else {
                out.print(DumpASTree.asTreeType(tree) + " [" + tree.getFirstToken() + "," + tree.getLastToken() + "]");
                ASTree[] subtrees = tree.getSubTrees();
                if (subtrees != null) {
                    out.println(" {");
                    for (int i = 0; i < subtrees.length; ++i) {
                        ASTree ast = subtrees[i];
                        DumpASTree.printASTree(subtrees[i], out, indent + 1);
                    }
                    DumpASTree.printIndent(out, indent);
                    out.print("}");
                }
                if (dumpSymbols) {
                    SymbolInfo info = tree.getSymbolInfo();
                    if (info != null) {
                        out.print(" sym=" + info);
                    } else {
                        switch (tree.getType()) {
                            case 27: 
                            case 43: 
                            case 45: 
                            case 49: 
                            case 50: 
                            case 296: 
                            case 361: {
                                out.print(" !!!missing symbol!!!");
                            }
                        }
                    }
                }
                out.println();
            }
        }
        catch (Throwable t) {
            StackTraceElement[] stack;
            if (t.getCause() != null) {
                t = t.getCause();
            }
            out.println("ASTree failure for " + DumpASTree.asTreeType(tree) + ": " + t);
            String msg = t.getMessage();
            if (msg != null) {
                DumpASTree.printIndent(out, indent);
                out.println(msg);
            }
            int max = (stack = t.getStackTrace()).length < 4 ? stack.length : 4;
            for (int i = 0; i < 4 && !stack[i].getMethodName().equals("printASTree"); ++i) {
                out.println(stack[i].toString());
            }
        }
    }

    private static void printIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(".  ");
        }
    }

    static String asTreeType(ASTree tree) {
        return DumpASTree.asTreeType(tree, "(", ")");
    }

    static String asTreeType(ASTree tree, String openValue, String closeValue) {
        Object value;
        String s = null;
        int type = tree.getType();
        switch (type) {
            case 1: {
                s = "ARGUMENT_LIST";
                break;
            }
            case 2: {
                s = "ARRAY_ACCESS";
                break;
            }
            case 3: {
                s = "ARRAY_CREATION_EXPRESSION";
                break;
            }
            case 4: {
                s = "ARRAY_INITIALIZER";
                break;
            }
            case 5: {
                s = "ASSERT_STATEMENT";
                break;
            }
            case 6: {
                s = "ASSIGNMENT";
                break;
            }
            case 7: {
                s = "BLOCK_STATEMENTS";
                break;
            }
            case 8: {
                s = "BREAK_STATEMENT";
                break;
            }
            case 9: {
                s = "CAST_EXPRESSION";
                break;
            }
            case 10: {
                s = "CATCH_CLAUSE";
                break;
            }
            case 11: {
                s = "CATCHES";
                break;
            }
            case 12: {
                s = "CLASS_BODY_DECLARATIONS";
                break;
            }
            case 13: {
                s = "CLASS_DECLARATION";
                break;
            }
            case 14: {
                s = "CLASS_INSTANCE_CREATION_EXPRESSION";
                break;
            }
            case 15: {
                s = "COMPILATION_UNIT";
                break;
            }
            case 16: {
                s = "COMPLEX_EXPRESSION";
                break;
            }
            case 17: {
                s = "CONDITIONAL_EXPRESSION";
                break;
            }
            case 18: {
                s = "CONSTRUCTOR_DECLARATION";
                break;
            }
            case 19: {
                s = "CONSTRUCTOR_DECLARATOR";
                break;
            }
            case 20: {
                s = "CONTINUE_STATEMENT";
                break;
            }
            case 21: {
                s = "DIM_EXPRS";
                break;
            }
            case 22: {
                s = "DIMS";
                break;
            }
            case 23: {
                s = "DO_STATEMENT";
                break;
            }
            case 24: {
                s = "EMPTY_STATEMENT";
                break;
            }
            case 25: {
                s = "EXPLICIT_CONSTRUCTOR_INVOCATION";
                break;
            }
            case 26: {
                s = "EXPRESSION_STATEMENT";
                break;
            }
            case 27: {
                s = "FIELD_ACCESS";
                break;
            }
            case 28: {
                s = "FIELD_DECLARATION";
                break;
            }
            case 30: {
                s = "FORMAL_PARAMETER";
                break;
            }
            case 31: {
                s = "FORMAL_PARAMETER_LIST";
                break;
            }
            case 32: {
                s = "FOR_STATEMENT";
                break;
            }
            case 33: {
                s = "IF_STATEMENT";
                break;
            }
            case 34: {
                s = "IMPORT_DECLARATIONS";
                break;
            }
            case 35: {
                s = "INFIX_EXPRESSION";
                break;
            }
            case 36: {
                s = "INSTANCE_INITIALIZER";
                break;
            }
            case 37: {
                s = "INTERFACE_DECLARATION";
                break;
            }
            case 38: {
                s = "INTERFACE_MEMBER_DECLARATIONS";
                break;
            }
            case 39: {
                s = "LABELED_STATEMENT";
                break;
            }
            case 40: {
                s = "LOCAL_VARIABLE_DECLARATION";
                break;
            }
            case 41: {
                s = "METHOD_DECLARATION";
                break;
            }
            case 42: {
                s = "METHOD_DECLARATOR";
                break;
            }
            case 43: {
                s = "METHOD_INVOCATION";
                break;
            }
            case 44: {
                s = "";
                ASTree[] subs = tree.getSubTrees();
                for (int i = 0; i < subs.length; ++i) {
                    s = s + tree.getASTContext().getText(subs[i]);
                    if (i + 1 >= subs.length) continue;
                    s = s + " ";
                }
                break;
            }
            case 45: {
                s = "MULTI_PART_ID";
                break;
            }
            case 46: {
                s = "PACKAGE_DECLARATION";
                break;
            }
            case 47: {
                s = "POSTFIX_EXPRESSION";
                break;
            }
            case 48: {
                s = "PREFIX_EXPRESSION";
                break;
            }
            case 49: {
                s = "PRIMARY_CLASS";
                break;
            }
            case 50: {
                s = "PRIMARY_THIS";
                break;
            }
            case 51: {
                s = "PRIMITIVE_TYPE";
                break;
            }
            case 52: {
                s = "REFERENCE_TYPE";
                break;
            }
            case 53: {
                s = "RETURN_STATEMENT";
                break;
            }
            case 54: {
                s = "SINGLE_TYPE_IMPORT";
                break;
            }
            case 55: {
                s = "STATEMENT_EXPRESSION_LIST";
                break;
            }
            case 56: {
                s = "STATIC_INITIALIZER";
                break;
            }
            case 57: {
                s = "SUPER_";
                break;
            }
            case 58: {
                s = "SWITCH_BLOCK";
                break;
            }
            case 59: {
                s = "SWITCH_BLOCK_STATEMENT_GROUP";
                break;
            }
            case 60: {
                s = "SWITCH_BLOCK_STATEMENT_GROUPS";
                break;
            }
            case 61: {
                s = "SWITCH_LABEL";
                break;
            }
            case 62: {
                s = "SWITCH_LABELS";
                break;
            }
            case 63: {
                s = "SWITCH_STATEMENT";
                break;
            }
            case 64: {
                s = "SYNCHRONIZE_STATEMENT";
                break;
            }
            case 65: {
                s = "THROW_STATEMENT";
                break;
            }
            case 66: {
                s = "TRY_STATEMENT";
                break;
            }
            case 67: {
                s = "TYPE_DECLARATIONS";
                break;
            }
            case 68: {
                s = "TYPE_IMPORT_ON_DEMAND";
                break;
            }
            case 69: {
                s = "TYPE_LIST";
                break;
            }
            case 70: {
                s = "VARIABLE_DECLARATOR";
                break;
            }
            case 71: {
                s = "VARIABLE_DECLARATORS";
                break;
            }
            case 72: {
                s = "VARIABLE_INITIALIZERS";
                break;
            }
            case 73: {
                s = "WHILE_STATEMENT";
                break;
            }
            case 74: {
                s = "BOUND_LIST";
                break;
            }
            case 29: {
                s = "FOR_EACH_STATEMENT";
                break;
            }
            case 75: {
                s = "TYPE_ARGUMENTS";
                break;
            }
            case 77: {
                s = "TYPE_PARAMETER";
                break;
            }
            case 78: {
                s = "TYPE_PARAMETER_LIST";
                break;
            }
            case 79: {
                s = "WILDCARD";
                break;
            }
            case 80: {
                s = "ENUM_BODY";
                break;
            }
            case 81: {
                s = "ENUM_BODY_DECLARATIONS";
                break;
            }
            case 82: {
                s = "ENUM_CONSTANT";
                break;
            }
            case 83: {
                s = "ENUM_CONSTANTS";
                break;
            }
            case 84: {
                s = "ENUM_DECLARATION";
                break;
            }
            case 85: {
                s = "ERRONEOUS";
                break;
            }
            case 86: {
                s = "ANNOTATION";
                break;
            }
            case 93: {
                s = "ANNOTATIONS";
                break;
            }
            case 87: {
                s = "ANNOTATION_ATTRIBUTE_DECLARATION";
                break;
            }
            case 88: {
                s = "ANNOTATION_TYPE_BODY_DECLARATIONS";
                break;
            }
            case 89: {
                s = "ANNOTATION_TYPE_DECLARATION";
                break;
            }
            case 90: {
                s = "ELEMENT_VALUE_PAIR";
                break;
            }
            case 91: {
                s = "ELEMENT_VALUE_PAIRS";
                break;
            }
            case 92: {
                s = "DEFAULT_VALUE";
                break;
            }
            case 257: {
                s = "ABSTRACT";
                break;
            }
            case 258: {
                s = "ASSERT";
                break;
            }
            case 259: {
                s = "BOOLEAN";
                break;
            }
            case 260: {
                s = "BREAK";
                break;
            }
            case 261: {
                s = "BYTE";
                break;
            }
            case 262: {
                s = "CASE";
                break;
            }
            case 263: {
                s = "CATCH";
                break;
            }
            case 264: {
                s = "CHAR";
                break;
            }
            case 265: {
                s = "CLASS";
                break;
            }
            case 266: {
                s = "CONST";
                break;
            }
            case 267: {
                s = "CONTINUE";
                break;
            }
            case 268: {
                s = "DEFAULT";
                break;
            }
            case 269: {
                s = "DO";
                break;
            }
            case 270: {
                s = "DOUBLE";
                break;
            }
            case 271: {
                s = "ELSE";
                break;
            }
            case 272: {
                s = "ENUM";
                break;
            }
            case 273: {
                s = "EXTENDS";
                break;
            }
            case 274: {
                s = "FINAL";
                break;
            }
            case 275: {
                s = "FINALLY";
                break;
            }
            case 276: {
                s = "FLOAT";
                break;
            }
            case 277: {
                s = "FOR";
                break;
            }
            case 278: {
                s = "GOTO";
                break;
            }
            case 279: {
                s = "IF";
                break;
            }
            case 280: {
                s = "IMPLEMENTS";
                break;
            }
            case 281: {
                s = "IMPORT";
                break;
            }
            case 282: {
                s = "INSTANCEOF";
                break;
            }
            case 283: {
                s = "INT";
                break;
            }
            case 284: {
                s = "INTERFACE";
                break;
            }
            case 285: {
                s = "LONG";
                break;
            }
            case 286: {
                s = "NATIVE";
                break;
            }
            case 287: {
                s = "NEW";
                break;
            }
            case 288: {
                s = "PACKAGE";
                break;
            }
            case 289: {
                s = "PRIVATE";
                break;
            }
            case 290: {
                s = "PROTECTED";
                break;
            }
            case 291: {
                s = "PUBLIC";
                break;
            }
            case 292: {
                s = "RETURN";
                break;
            }
            case 293: {
                s = "SHORT";
                break;
            }
            case 294: {
                s = "STATIC";
                break;
            }
            case 295: {
                s = "STRICTFP";
                break;
            }
            case 296: {
                s = "SUPER";
                break;
            }
            case 297: {
                s = "SWITCH";
                break;
            }
            case 298: {
                s = "SYNCHRONIZED";
                break;
            }
            case 299: {
                s = "THIS";
                break;
            }
            case 300: {
                s = "THROW";
                break;
            }
            case 301: {
                s = "THROWS";
                break;
            }
            case 302: {
                s = "TRANSIENT";
                break;
            }
            case 303: {
                s = "TRY";
                break;
            }
            case 304: {
                s = "VOID";
                break;
            }
            case 305: {
                s = "VOLATILE";
                break;
            }
            case 306: {
                s = "WHILE";
                break;
            }
            case 307: {
                s = "L_PAR";
                break;
            }
            case 308: {
                s = "R_PAR";
                break;
            }
            case 309: {
                s = "L_CURLY";
                break;
            }
            case 310: {
                s = "R_CURLY";
                break;
            }
            case 311: {
                s = "L_BRACKET";
                break;
            }
            case 312: {
                s = "R_BRACKET";
                break;
            }
            case 313: {
                s = "SEMICOLON";
                break;
            }
            case 314: {
                s = "COMMA";
                break;
            }
            case 315: {
                s = "DOT";
                break;
            }
            case 316: {
                s = "MONKEYS_AT";
                break;
            }
            case 317: {
                s = "ELLIPSIS";
                break;
            }
            case 318: {
                s = "ASSIGN";
                break;
            }
            case 319: {
                s = "GT";
                break;
            }
            case 320: {
                s = "LT";
                break;
            }
            case 321: {
                s = "NOT";
                break;
            }
            case 322: {
                s = "COMP";
                break;
            }
            case 323: {
                s = "QUESTION";
                break;
            }
            case 324: {
                s = "COLON";
                break;
            }
            case 325: {
                s = "EQ";
                break;
            }
            case 326: {
                s = "LTE";
                break;
            }
            case 327: {
                s = "GTE";
                break;
            }
            case 328: {
                s = "NEQ";
                break;
            }
            case 329: {
                s = "BOOL_AND";
                break;
            }
            case 330: {
                s = "BOOL_OR";
                break;
            }
            case 331: {
                s = "INCREMENT";
                break;
            }
            case 332: {
                s = "DECREMENT";
                break;
            }
            case 333: {
                s = "PLUS";
                break;
            }
            case 334: {
                s = "MINUS";
                break;
            }
            case 335: {
                s = "MULTI";
                break;
            }
            case 336: {
                s = "DIV";
                break;
            }
            case 337: {
                s = "AND";
                break;
            }
            case 338: {
                s = "OR";
                break;
            }
            case 339: {
                s = "XOR";
                break;
            }
            case 340: {
                s = "MOD";
                break;
            }
            case 341: {
                s = "L_SHIFT";
                break;
            }
            case 342: {
                s = "R_SHIFT";
                break;
            }
            case 343: {
                s = "UR_SHIFT";
                break;
            }
            case 344: {
                s = "PLUS_ASSIGN";
                break;
            }
            case 345: {
                s = "MINUS_ASSIGN";
                break;
            }
            case 346: {
                s = "MULTI_ASSIGN";
                break;
            }
            case 347: {
                s = "DIV_ASSIGN";
                break;
            }
            case 348: {
                s = "AND_ASSIGN";
                break;
            }
            case 349: {
                s = "OR_ASSIGN";
                break;
            }
            case 350: {
                s = "XOR_ASSIGN";
                break;
            }
            case 351: {
                s = "MOD_ASSIGN";
                break;
            }
            case 352: {
                s = "L_SHIFT_ASSIGN";
                break;
            }
            case 353: {
                s = "R_SHIFT_ASSIGN";
                break;
            }
            case 354: {
                s = "UR_SHIFT_ASSIGN";
                break;
            }
            case 355: {
                s = "BOOL_LIT";
                break;
            }
            case 356: {
                s = "INT_LIT";
                break;
            }
            case 357: {
                s = "FLOAT_LIT";
                break;
            }
            case 358: {
                s = "CHAR_LIT";
                break;
            }
            case 359: {
                s = "STRING_LIT";
                break;
            }
            case 360: {
                s = "NULL_LIT";
                break;
            }
            case 361: {
                s = "IDENTIFIER";
                break;
            }
            case 362: {
                s = "COMMENT";
                break;
            }
            case 363: {
                s = "EOL_COMMENT";
                break;
            }
            case 364: {
                s = "DOC_COMMENT";
                break;
            }
            case 365: {
                s = "WHITESPACE";
                break;
            }
            case 366: {
                s = "EOL";
                break;
            }
            case 367: {
                s = "EOF";
                break;
            }
            case 368: {
                s = "ERROR";
                break;
            }
            default: {
                s = "unknown ASTreeType: " + type;
            }
        }
        if (tree instanceof Token && !(tree instanceof ASTypeArray) && (value = ((Token)tree).getValue()) != null) {
            s = s + openValue + value + closeValue;
        }
        return s;
    }

    private static void dumpTokens(ASTree tree, JParser jp, PrintStream out) {
        int max = tree.getLastToken();
        Token[] tokens = jp.getTokens();
        for (int i = tree.getFirstToken(); i <= max; ++i) {
            Token tok = tokens[i];
            out.print(Integer.toString(i) + "\t" + DumpASTree.asTokenType(tok));
            out.print(" start=" + tok.getStartOffset() + " end=" + tok.getEndOffset() + " value=" + tok.getValue());
            DumpASTree.dumpPadding(tok, tree.getASTContext(), out);
            out.println();
        }
    }

    private static String asTokenType(Token tok) {
        if (tok instanceof ASIdent) {
            return DumpASTree.asTreeType((ASTree)((ASIdent)tok).getLexicalToken());
        }
        if (tok instanceof ASLiteral) {
            return DumpASTree.asTreeType((ASTree)((ASLiteral)tok).getLexicalToken());
        }
        return DumpASTree.asTreeType((ASTree)tok);
    }

    private static void dumpPadding(Token token, ASTContext ctx, PrintStream out) {
        Token[] padding = token.getPadding();
        if (padding.length > 0) {
            out.print("\tpad = {");
            for (int i = 0; i < padding.length; ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print('\"');
                Token t = padding[i];
                char[] pad = ctx.getText(t).toCharArray();
                block8: for (int j = 0; j < pad.length; ++j) {
                    switch (pad[j]) {
                        case '\n': {
                            out.print("\\n");
                            continue block8;
                        }
                        case '\r': {
                            out.print("\\r");
                            continue block8;
                        }
                        case '\t': {
                            out.print("\\t");
                            continue block8;
                        }
                        case '\b': {
                            out.print("\\b");
                            continue block8;
                        }
                        case '\f': {
                            out.print("\\f");
                            continue block8;
                        }
                        default: {
                            out.print(pad[j]);
                        }
                    }
                }
                out.print('\"');
            }
            out.print('}');
        }
    }

    static char[] readInChars(Reader in) {
        try {
            int n;
            CharArrayWriter out = new CharArrayWriter();
            char[] buf = new char[8192];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            return out.toCharArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class MiniContext
    implements ASTContext {
        JParser parser;
        String sourceText;
        String sourceLevel;
        ErrConsumer errConsumer = new ErrConsumer(){

            public void pushError(Object severity, String errorFileName, int line, int column, String message, String key, String[] args) {
                System.err.print(severity == ErrConsumer.ERROR ? "error: " : "warning: ");
                System.err.println(errorFileName + ":" + line + "," + column + ": " + message);
            }
        };

        MiniContext(char[] src, String sourceLevel) {
            this.sourceText = new String(src);
            this.sourceLevel = sourceLevel;
        }

        void setParser(JParser parser) {
            this.parser = parser;
        }

        public String getText(ASTree tree) {
            return tree == null ? null : this.getText(tree, tree);
        }

        public String getText(ASTree first, ASTree last) {
            int start = this.getToken(first.getFirstToken()).getStartOffset();
            int end = this.getToken(last.getLastToken()).getEndOffset();
            return this.sourceText.substring(start, end);
        }

        public String getText(Token token) {
            int start = token.getStartOffset();
            int end = token.getEndOffset();
            return this.sourceText.substring(start, end);
        }

        public Token getToken(int index) {
            Token[] tokens = this.parser.getTokens();
            return tokens[index];
        }

        public ASTree getRootTree() {
            return this.parser.getASTree();
        }

        public ASTree getParent(ASTree tree) {
            return null;
        }

        public String getSourceLevel() {
            return this.sourceLevel;
        }

        public String getClassPath() {
            String mycp = System.getProperty("gjast.class.path");
            if (mycp == null) {
                mycp = System.getProperty("java.class.path");
            }
            return mycp;
        }

        public ErrConsumer getErrorConsumer() {
            return this.errConsumer;
        }
    }
}

