/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.expressions.SubSelectExpression;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class ExpressionNormalizer {
    protected Expression additionalExpression;
    protected SQLSelectStatement statement;
    protected Vector subSelectExpressions;
    protected AbstractSession session;

    public ExpressionNormalizer(SQLSelectStatement statement) {
        this.statement = statement;
    }

    public void addAdditionalExpression(Expression theExpression) {
        this.additionalExpression = this.additionalExpression == null ? theExpression : this.additionalExpression.and(theExpression);
    }

    public void addSubSelectExpression(SubSelectExpression subSelectExpression) {
        if (this.subSelectExpressions == null) {
            this.subSelectExpressions = new Vector(1);
        }
        this.subSelectExpressions.add(subSelectExpression);
    }

    public Expression getAdditionalExpression() {
        return this.additionalExpression;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public boolean encounteredSubSelectExpressions() {
        return this.subSelectExpressions != null;
    }

    public void normalizeSubSelects(Dictionary clonedExpressions) {
        Enumeration enumtr = this.subSelectExpressions.elements();
        while (enumtr.hasMoreElements()) {
            SubSelectExpression next = (SubSelectExpression)enumtr.nextElement();
            next.normalizeSubSelect(this, clonedExpressions);
        }
    }

    public void setAdditionalExpression(Expression additionalExpression) {
        this.additionalExpression = additionalExpression;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setStatement(SQLSelectStatement statement) {
        this.statement = statement;
    }
}

