/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.exceptions.PersistenceUnitLoadingException;
import oracle.toplink.essentials.exceptions.XMLParseException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.PersistenceContentHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLExceptionHandler;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitProcessor {
    public static final String JAR_OPENING_EXCEPTION = "attempted_to_open_url_as_jar";
    public static final String DIRECTORY_OPENING_EXCEPTION = "attempted_to_open_url_as_directory";
    public static final String JAR_ENTRY_OPENING_EXCEPTION = "attempted_to_open_entry_in_url_as_jar";
    public static final String DIRECTORY_ENTRY_OPENING_EXCEPTION = "attempted_to_open_file_url_as_directory";

    public static List<SEPersistenceUnitInfo> getPersistenceUnits(URL url, ClassLoader loader) {
        return PersistenceUnitProcessor.processPersistenceArchive(url, loader);
    }

    protected static List<SEPersistenceUnitInfo> processPersistenceArchveFromUnconvertableURL(URL baseURL, ClassLoader loader) {
        InputStream stream = null;
        try {
            stream = baseURL.openStream();
            List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceXML(baseURL, stream, loader);
            return list;
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(baseURL.toString(), exc);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    private static List<SEPersistenceUnitInfo> processDirectory(URL baseURL, File file, ClassLoader loader) {
        FileInputStream inputStream = null;
        try {
            String filePath = file.getPath();
            File persistenceXMLFile = new File(filePath + File.separator + "META-INF" + File.separator + "persistence.xml");
            if (!persistenceXMLFile.exists()) {
                persistenceXMLFile = new File(filePath + File.separator + "meta-inf" + File.separator + "persistence.xml");
            }
            if (persistenceXMLFile.exists()) {
                inputStream = new FileInputStream(persistenceXMLFile);
                List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceXML(baseURL, inputStream, loader);
                return list;
            }
            List<SEPersistenceUnitInfo> list = null;
            return list;
        }
        catch (FileNotFoundException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromDirectory(file, exc);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    protected static List<SEPersistenceUnitInfo> processJarFile(URL baseURL, ClassLoader loader) {
        ZipInputStream jarFile = null;
        InputStream stream = null;
        try {
            stream = PersistenceUnitProcessor.createInputStreamForURL(baseURL);
            jarFile = new JarInputStream(stream);
            ZipEntry entry = ((JarInputStream)jarFile).getNextEntry();
            while (entry != null && !entry.getName().equals("META-INF/persistence.xml") && !entry.getName().equals("meta-inf/persistence.xml")) {
                entry = ((JarInputStream)jarFile).getNextEntry();
            }
            if (entry != null && (entry.getName().equals("META-INF/persistence.xml") || entry.getName().equals("meta-inf/persistence.xml"))) {
                List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceXML(baseURL, jarFile, loader);
                return list;
            }
            List<SEPersistenceUnitInfo> list = null;
            return list;
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromJar(baseURL, exc);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    private static List<SEPersistenceUnitInfo> processPersistenceArchive(URL url, ClassLoader loader) {
        File file = null;
        List<SEPersistenceUnitInfo> persistenceUnitList = null;
        URL tempURL = PersistenceUnitProcessor.truncateURLAndRemoveFileReference(url);
        try {
            persistenceUnitList = PersistenceUnitProcessor.processJarFile(tempURL, loader);
            if (persistenceUnitList != null) {
                return persistenceUnitList;
            }
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(1, JAR_OPENING_EXCEPTION, url, exception);
        }
        try {
            file = new File(PersistenceUnitProcessor.convertURLToURI(tempURL));
            if (file.isDirectory() && (persistenceUnitList = PersistenceUnitProcessor.processDirectory(tempURL, file, loader)) != null) {
                return persistenceUnitList;
            }
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(1, DIRECTORY_OPENING_EXCEPTION, url, exception);
        }
        persistenceUnitList = PersistenceUnitProcessor.processPersistenceArchveFromUnconvertableURL(url, loader);
        return persistenceUnitList;
    }

    public static InputStream createInputStreamForFileInPersistenceUnit(String fileName, PersistenceUnitInfo persistenceUnitInfo, ClassLoader classLoader) throws IOException {
        InputStream stream = null;
        try {
            stream = PersistenceUnitProcessor.createInputStreamForJarFile(fileName, persistenceUnitInfo.getPersistenceUnitRootUrl());
            if (stream != null) {
                return stream;
            }
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().log(1, JAR_ENTRY_OPENING_EXCEPTION, persistenceUnitInfo.getPersistenceUnitRootUrl(), fileName, e);
        }
        try {
            File file = new File(PersistenceUnitProcessor.convertURLToURI(persistenceUnitInfo.getPersistenceUnitRootUrl()));
            if (file.isDirectory() && (stream = PersistenceUnitProcessor.createInputStreamForDirectory(fileName, file)) != null) {
                return stream;
            }
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().log(1, DIRECTORY_ENTRY_OPENING_EXCEPTION, persistenceUnitInfo.getPersistenceUnitRootUrl(), fileName, e);
        }
        return PersistenceUnitProcessor.createInputStreamForUnconvertableURL(fileName, persistenceUnitInfo.getPersistenceUnitRootUrl(), classLoader);
    }

    public static InputStream createInputStreamForJarFile(String fileName, URL url) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(PersistenceUnitProcessor.createInputStreamForURL(url));
        ZipEntry entry = jarInputStream.getNextEntry();
        while (entry != null && !entry.getName().equals(fileName)) {
            entry = jarInputStream.getNextEntry();
        }
        if (entry != null && entry.getName().equals(fileName)) {
            return jarInputStream;
        }
        return null;
    }

    public static InputStream createInputStreamForDirectory(String fileName, File inputFile) throws IOException {
        File xmlFile;
        String filePath = inputFile.getPath();
        String tempFileName = fileName;
        if (!filePath.endsWith(File.separator) && !fileName.startsWith(File.separator)) {
            tempFileName = File.separator + tempFileName;
        }
        if ((xmlFile = new File(filePath + tempFileName)).exists()) {
            return new FileInputStream(xmlFile);
        }
        return null;
    }

    public static InputStream createInputStreamForUnconvertableURL(String fileName, URL url, ClassLoader loader) throws IOException {
        String persistenceUnitRoolUrlString = url.toString();
        Enumeration<URL> resources = loader.getResources(fileName);
        while (resources.hasMoreElements()) {
            URL mappingFileResource = resources.nextElement();
            String mappingFileResourceString = mappingFileResource.toString();
            if (!mappingFileResourceString.contains(persistenceUnitRoolUrlString)) continue;
            return url.openStream();
        }
        return null;
    }

    public static InputStream createInputStreamForURL(URL url) throws IOException {
        InputStream stream = null;
        IOException initialException = null;
        try {
            stream = url.openStream();
        }
        catch (IOException exc) {
            AbstractSessionLog.getLog().log(1, JAR_OPENING_EXCEPTION, url, exc);
            initialException = exc;
            try {
                stream = PersistenceUnitProcessor.createTruncatedJarURLFromString(url.toString()).openStream();
            }
            catch (PersistenceUnitLoadingException exception) {
                AbstractSessionLog.getLog().log(1, JAR_OPENING_EXCEPTION, url, exception);
                throw initialException;
            }
            catch (IOException exception2) {
                AbstractSessionLog.getLog().log(1, JAR_OPENING_EXCEPTION, url, exception2);
                throw initialException;
            }
        }
        return stream;
    }

    public static List<SEPersistenceUnitInfo> processPersistenceXML(URL baseURL, InputStream input, ClassLoader loader) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        XMLReader xmlReader = null;
        SAXParser sp = null;
        XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
        try {
            sp = spf.newSAXParser();
            sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (ParserConfigurationException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        try {
            xmlReader = sp.getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingXMLReader(baseURL, exc);
        }
        URL schemaURL = loader.getResource("persistence_1_0.xsd");
        if (schemaURL != null) {
            try {
                sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL.toString());
            }
            catch (SAXException exc) {
                throw XMLParseException.exceptionSettingSchemaSource(baseURL, schemaURL, exc);
            }
        }
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        xmlReader.setContentHandler(myContentHandler);
        InputSource inputSource = new InputSource(input);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, exc);
        }
        catch (SAXException exc) {
            // empty catch block
        }
        XMLException xmlError = xmlErrorHandler.getXMLException();
        if (xmlError != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, xmlError);
        }
        for (SEPersistenceUnitInfo info : myContentHandler.getPersistenceUnits()) {
            info.setPersistenceUnitRootUrl(baseURL);
        }
        return myContentHandler.getPersistenceUnits();
    }

    private static URL truncateURLAndRemoveFileReference(URL url) {
        String newURLString = url.toString().substring(0, url.toString().length() - 25);
        return PersistenceUnitProcessor.createTruncatedJarURLFromString(newURLString);
    }

    private static URL createTruncatedJarURLFromString(String url) {
        try {
            String cleanUrl = url;
            int index = url.lastIndexOf(33);
            if (index > 0) {
                cleanUrl = cleanUrl.substring(0, index);
            }
            if (cleanUrl.startsWith("jar:")) {
                cleanUrl = cleanUrl.substring(4, cleanUrl.length());
            }
            return new URL(cleanUrl);
        }
        catch (MalformedURLException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(url, exc);
        }
    }

    public static String buildClassNameFromEntryString(String classEntryString) {
        String classNameForLoader = classEntryString;
        if (classEntryString.endsWith(".class")) {
            classNameForLoader = classNameForLoader.substring(0, classNameForLoader.length() - 6);
            classNameForLoader = classNameForLoader.replace("/", ".");
        }
        return classNameForLoader;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(persistenceUnitInfo.getManagedClassNames());
        Iterator<URL> i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(i.next()));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl()));
        }
        return set;
    }

    public static Set<String> buildPersistentClassSet(PersistenceUnitInfo persistenceUnitInfo, ClassLoader loader) {
        HashSet<String> set = new HashSet<String>();
        for (String className : persistenceUnitInfo.getManagedClassNames()) {
            if (!PersistenceUnitProcessor.isClassPersistent(className, loader, true)) continue;
            set.add(className);
        }
        Iterator<URL> i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getPersistentClassNamesFromURL(i.next(), loader));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getPersistentClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl(), loader));
        }
        return set;
    }

    protected static List<String> findClassesInDirectory(File directory, int leadingCharactersToRemove) {
        File[] files;
        Vector<String> classes = new Vector<String>();
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(PersistenceUnitProcessor.findClassesInDirectory(file, leadingCharactersToRemove));
            }
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            String className = file.getPath().substring(leadingCharactersToRemove + 1, file.getPath().length() - 6);
            className = className.replace("/", ".");
            className = className.replace("\\", ".");
            classes.add(className);
        }
        return classes;
    }

    public static Set<URL> findPersistenceArchives() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(threadLoader);
    }

    public static Set<URL> findPersistenceArchives(ClassLoader loader) {
        HashSet<URL> parURLs = new HashSet<URL>();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                parURLs.add(url);
            }
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, exc);
        }
        return parURLs;
    }

    private static List<String> getClassNamesFromJar(URL url) {
        InputStream stream = null;
        List persistentClasses = null;
        try {
            stream = PersistenceUnitProcessor.createInputStreamForURL(url);
            persistentClasses = PersistenceUnitProcessor.findClassesInJar(stream);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForEntities(url, exc);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException exc) {}
        }
        return persistentClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List findClassesInJar(InputStream stream) throws IOException {
        JarInputStream jarFile = null;
        Vector<String> persistentClasses = new Vector<String>();
        try {
            jarFile = new JarInputStream(stream);
            ZipEntry entry = jarFile.getNextEntry();
            if (entry == null) {
                List list = null;
                return list;
            }
            while (entry != null) {
                String classNameForLoader = PersistenceUnitProcessor.buildClassNameFromEntryString(entry.getName());
                if (entry.getName().endsWith(".class")) {
                    persistentClasses.add(classNameForLoader);
                }
                entry = jarFile.getNextEntry();
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException exc) {}
        }
        return persistentClasses;
    }

    private static List<String> getClassNamesFromURL(URL url) {
        List<String> classNames = null;
        try {
            classNames = PersistenceUnitProcessor.getClassNamesFromJar(url);
            if (classNames != null) {
                return classNames;
            }
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(1, JAR_OPENING_EXCEPTION, url, exception);
        }
        try {
            File file = new File(PersistenceUnitProcessor.convertURLToURI(url));
            if (file.isDirectory()) {
                return PersistenceUnitProcessor.getClassNamesFromDirectory(file);
            }
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(1, DIRECTORY_OPENING_EXCEPTION, url, exception);
        }
        return null;
    }

    private static List<String> getClassNamesFromDirectory(File file) {
        List<String> classList = null;
        if (!file.isDirectory()) {
            return null;
        }
        int initialDirectoryNameLength = file.getPath().length();
        classList = PersistenceUnitProcessor.findClassesInDirectory(file, initialDirectoryNameLength);
        return classList;
    }

    public static List<String> getPersistentClassNamesFromDirectory(File file, ClassLoader loader) {
        Vector<String> persistentClasses = new Vector<String>();
        List<String> classList = PersistenceUnitProcessor.getClassNamesFromDirectory(file);
        for (String className : classList) {
            if (!PersistenceUnitProcessor.isClassPersistent(className, loader, false)) continue;
            persistentClasses.add(className);
        }
        return persistentClasses;
    }

    public static List getPersistentClassNamesFromURL(URL url, ClassLoader loader) {
        List<String> classNames = null;
        try {
            classNames = PersistenceUnitProcessor.getPersistentClassNamesFromJar(url, loader);
            if (classNames != null) {
                return classNames;
            }
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(1, JAR_OPENING_EXCEPTION, url, exception);
        }
        try {
            File file = new File(PersistenceUnitProcessor.convertURLToURI(url));
            if (file.isDirectory() && (classNames = PersistenceUnitProcessor.getPersistentClassNamesFromDirectory(file, loader)) != null) {
                return classNames;
            }
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(1, DIRECTORY_OPENING_EXCEPTION, url, exception);
        }
        throw PersistenceUnitLoadingException.couldNotGetClassNamesFromUrl(url);
    }

    public static List<String> getPersistentClassNamesFromJar(URL url, ClassLoader loader) {
        List<String> classList = PersistenceUnitProcessor.getClassNamesFromJar(url);
        if (classList == null) {
            return null;
        }
        Vector<String> persistentClasses = new Vector<String>();
        for (String className : classList) {
            if (!PersistenceUnitProcessor.isClassPersistent(className, loader, false)) continue;
            persistentClasses.add(className);
        }
        return persistentClasses;
    }

    public static boolean isClassPersistent(String className, ClassLoader loader, boolean throwExceptionIfNotFound) {
        Class<?> candidateClass = null;
        try {
            candidateClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            if (throwExceptionIfNotFound) {
                throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations(className, exc);
            }
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", exc.getClass().getName(), exc.getLocalizedMessage(), className);
            return false;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", exception.getClass().getName(), exception.getLocalizedMessage(), className);
            return false;
        }
        return PersistenceUnitProcessor.isClassPersistent(candidateClass);
    }

    public static boolean isClassPersistent(Class candidateClass) {
        return candidateClass.isAnnotationPresent(Entity.class);
    }

    private static URI convertURLToURI(URL url) {
        URI uri;
        block5: {
            String filePath = url.getFile();
            if (filePath.equals("") || filePath == null) {
                throw PersistenceUnitLoadingException.filePathMissingException(filePath);
            }
            uri = null;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                try {
                    uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
                }
                catch (URISyntaxException exc) {
                    // empty catch block
                }
                if (uri != null) break block5;
                throw PersistenceUnitLoadingException.exceptionProcessingPersistenceUnit(url, e);
            }
        }
        return uri;
    }
}

