/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeAppProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultSourceMap
extends SourceFileMap {
    private J2eeModuleProvider provider;
    private HashSet rootFiles = new HashSet();

    public DefaultSourceMap(J2eeModuleProvider provider) {
        this.provider = provider;
        FileObject[] roots = provider.getSourceRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i] == null) continue;
            this.rootFiles.add(FileUtil.toFile((FileObject)roots[i]));
        }
    }

    public String getContextName() {
        return this.provider.getDeploymentName();
    }

    public FileObject[] getSourceRoots() {
        return this.provider.getSourceRoots();
    }

    public File getEnterpriseResourceDir() {
        return this.provider.getEnterpriseResourceDirectory();
    }

    public File[] getEnterpriseResourceDirs() {
        ArrayList<File> result = new ArrayList<File>();
        result.add(this.provider.getEnterpriseResourceDirectory());
        if (this.provider instanceof J2eeAppProvider) {
            J2eeAppProvider jap = (J2eeAppProvider)this.provider;
            J2eeModuleProvider[] children = jap.getChildModuleProviders();
            for (int i = 0; i < children.length; ++i) {
                result.add(children[i].getEnterpriseResourceDirectory());
            }
        }
        return result.toArray(new File[result.size()]);
    }

    public boolean add(String distributionPath, FileObject sourceFile) {
        return false;
    }

    public FileObject remove(String distributionPath) {
        return null;
    }

    public FileObject[] findSourceFile(String distributionPath) {
        ArrayList<FileObject> ret = new ArrayList<FileObject>();
        FileObject[] roots = this.getSourceRoots();
        String path = distributionPath.startsWith("/") ? distributionPath.substring(1) : distributionPath;
        for (int i = 0; i < roots.length; ++i) {
            FileObject fo = roots[i].getFileObject(path);
            if (fo == null) continue;
            ret.add(fo);
        }
        return ret.toArray(new FileObject[ret.size()]);
    }

    public File getDistributionPath(FileObject sourceFile) {
        for (File rootFile : this.rootFiles) {
            FileObject root = FileUtil.toFileObject((File)rootFile);
            String relative = FileUtil.getRelativePath((FileObject)root, (FileObject)sourceFile);
            if (relative == null || relative.trim().equals("")) continue;
            return new File(relative);
        }
        return null;
    }
}

