/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.netbeans.modules.search.types.TextDetail;
import org.netbeans.modules.search.types.TextType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchPattern;

public class FullTextType
extends TextType {
    private static final long serialVersionUID = 1L;
    private static final Collection searchableXMimeTypes = new HashSet(17);
    private transient Map detailsMap;
    private static final int MAX_REPORTED_OCCURENCES_ON_LINE = 5;
    private static final int MAX_REPORTED_OCCURENCES_IN_FILE = 200;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction;

    public Object clone() {
        FullTextType clone = (FullTextType)((Object)super.clone());
        clone.detailsMap = new HashMap(20);
        return clone;
    }

    public void destroy() {
        if (this.detailsMap != null) {
            this.detailsMap.clear();
        }
    }

    protected String displayName() {
        return NbBundle.getMessage((Class)FullTextType.class, (String)"TEXT_FULLTEXT_CRITERION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        FullTextType fullTextType = this;
        synchronized (fullTextType) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap(20);
            }
        }
        return this.detailsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDataObject(DataObject dobj) {
        InputStream is = null;
        BufferedReader reader = null;
        SearchPattern searchPattern = this.createSearchPattern();
        try {
            boolean bl;
            String line = "";
            FileObject fo = dobj.getPrimaryFile();
            if (fo == null) {
                boolean bl2 = false;
                return bl2;
            }
            is = fo.getInputStream();
            reader = new LineNumberReader(new InputStreamReader(is));
            ArrayList<TextDetail> txtDetails = new ArrayList<TextDetail>(5);
            int fileCount = 0;
            while (fileCount < 200 && (line = ((LineNumberReader)reader).readLine()) != null) {
                if (this.matchString != null) {
                    int lineNum = ((LineNumberReader)reader).getLineNumber();
                    int markLen = this.matchString.length();
                    String stringToSearch = this.caseSensitive ? line : line.toUpperCase();
                    int i = this.matchString(stringToSearch, 0);
                    int lineCount = 0;
                    while (i >= 0 && lineCount < 5) {
                        TextDetail det = new TextDetail(dobj, searchPattern);
                        det.setLine(lineNum);
                        det.setColumn(i + 1);
                        det.setLineText(line);
                        det.setMarkLength(markLen);
                        txtDetails.add(det);
                        i = this.matchString(stringToSearch, i + 1);
                        ++lineCount;
                        ++fileCount;
                    }
                    continue;
                }
                if (!this.matchRE(line)) continue;
                TextDetail det = new TextDetail(dobj, searchPattern);
                det.setLine(((LineNumberReader)reader).getLineNumber());
                det.setLineText(line);
                Matcher matcher = this.getMatcher();
                int start = matcher.start();
                int len = matcher.end() - start;
                det.setColumn(start + 1);
                det.setMarkLength(len);
                txtDetails.add(det);
                ++fileCount;
            }
            if (txtDetails.isEmpty()) {
                bl = false;
                return bl;
            }
            txtDetails.trimToSize();
            this.getDetailsMap().put(dobj, txtDetails);
            bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                    is = null;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    protected boolean acceptSearchObject(Object searchObject) {
        DataObject dataObj = (DataObject)searchObject;
        FileObject fileObj = dataObj.getPrimaryFile();
        String mimeType = fileObj.getMIMEType();
        if (mimeType.equals("content/unknown") || mimeType.startsWith("text/")) {
            return true;
        }
        if (mimeType.startsWith("application/")) {
            String subtype = mimeType.substring(12);
            return subtype.equals("rtf") || subtype.equals("sgml") || subtype.startsWith("xml-") || subtype.endsWith("+xml") || subtype.startsWith("x-") && searchableXMimeTypes.contains(subtype.substring(2));
        }
        return false;
    }

    public Node[] getDetails(Object resultObject) {
        List details = (List)this.getDetailsMap().get(resultObject);
        if (details == null) {
            return null;
        }
        ArrayList<DetailNode> detailNodes = new ArrayList<DetailNode>(details.size());
        Iterator it = details.iterator();
        while (it.hasNext()) {
            TextDetail txtDetail = (TextDetail)it.next();
            DetailNode detailNode = new DetailNode(txtDetail);
            detailNodes.add(detailNode);
        }
        return detailNodes.toArray(new Node[detailNodes.size()]);
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public int getDetailsCount(Object resultObject) {
        List details = (List)this.getDetailsMap().get(resultObject);
        return details != null ? details.size() : 0;
    }

    public SearchPattern createSearchPattern() {
        return SearchPattern.create((String)(this.matchString != null ? this.matchString : this.reString), (boolean)this.wholeWords, (boolean)this.caseSensitive, (this.matchString == null ? 1 : 0) != 0);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FullTextType.class);
    }

    static {
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
    }

    private static class GotoDetailAction
    extends NodeAction {
        private GotoDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType)).getString("LBL_GotoDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = FullTextType.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length != 0 && activatedNodes[0] instanceof DetailNode;
        }

        protected void performAction(Node[] activatedNodes) {
            if (this.enable(activatedNodes)) {
                ((DetailNode)activatedNodes[0]).gotoDetail();
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class DetailNode
    extends AbstractNode
    implements OutputListener {
        private TextDetail txtDetail;

        public DetailNode(TextDetail txtDetail) {
            super(Children.LEAF);
            this.txtDetail = txtDetail;
            this.setDefaultAction(SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = FullTextType.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction)));
            this.setShortDescription(DetailNode.getShortDesc(txtDetail));
            this.setValue("output line", DetailNode.getFullDesc(txtDetail));
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction == null ? (class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction = FullTextType.class$("org.netbeans.modules.search.types.FullTextType$GotoDetailAction")) : class$org$netbeans$modules$search$types$FullTextType$GotoDetailAction))};
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            String colored;
            if (this.txtDetail.getMarkLength() > 0 && this.txtDetail.getColumn() > 0) {
                try {
                    StringBuffer bold = new StringBuffer();
                    String plain = this.txtDetail.getLineText();
                    int col0 = this.txtDetail.getColumn() - 1;
                    bold.append(XMLUtil.toElementContent((String)plain.substring(0, col0)));
                    bold.append("<b>");
                    int end = col0 + this.txtDetail.getMarkLength();
                    bold.append(XMLUtil.toElementContent((String)plain.substring(col0, end)));
                    bold.append("</b>");
                    if (this.txtDetail.getLineText().length() > end) {
                        bold.append(XMLUtil.toElementContent((String)plain.substring(end)));
                    }
                    colored = bold.toString();
                }
                catch (CharConversionException ex) {
                    return null;
                }
            }
            try {
                colored = XMLUtil.toElementContent((String)this.txtDetail.getLineText());
            }
            catch (CharConversionException e) {
                return null;
            }
            try {
                return colored + "      <font color='!controlShadow'>[" + XMLUtil.toElementContent((String)DetailNode.getName(this.txtDetail)) + "]";
            }
            catch (CharConversionException e) {
                return null;
            }
        }

        private void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent evt) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent evt) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent evt) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(line), (Object)Integer.toString(col));
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(line));
        }

        private static String getShortDesc(TextDetail det) {
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(line), Integer.toString(col)});
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(line));
        }

        private static String getFullDesc(TextDetail det) {
            String filename = det.getDataObject().getPrimaryFile().getNameExt();
            String lineText = det.getLineText();
            int line = det.getLine();
            int col = det.getColumn();
            if (col > 0) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{lineText, filename, Integer.toString(line), Integer.toString(col)});
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$search$types$FullTextType == null ? (class$org$netbeans$modules$search$types$FullTextType = FullTextType.class$("org.netbeans.modules.search.types.FullTextType")) : class$org$netbeans$modules$search$types$FullTextType), (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{lineText, filename, Integer.toString(line)});
        }
    }
}

