/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.java.navigation.base.ReorderDragAndDropHandler;
import org.netbeans.modules.java.navigation.base.TooltipHack;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.openide.util.NbBundle;

public final class NavigatorJList
extends JList
implements MouseMotionListener,
MouseListener {
    static CellRendererPane cellpane = new CellRendererPane();
    static JLabel widthTestLabel = new JLabel();
    private JComponent enclosingComp;
    private Point curMouseLoc;
    private boolean isMouseInside;
    private boolean ignoreNextKey;
    private static final boolean DND = Boolean.getBoolean("nb.navigator.reordering");
    private static final boolean NO_SCROLL = Boolean.getBoolean("nb.navigator.noscroll");

    public NavigatorJList(JComponent enclosingComp) {
        cellpane.add(widthTestLabel);
        this.curMouseLoc = null;
        this.isMouseInside = false;
        this.ignoreNextKey = false;
        this.enclosingComp = enclosingComp;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)NavigatorJList.class, (String)"ACC_NavListName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)NavigatorJList.class, (String)"ACC_NavListDesc"));
        this.setBorder(BorderFactory.createEmptyBorder());
        if (DND) {
            ReorderDragAndDropHandler handler = new ReorderDragAndDropHandler();
            this.addMouseListener(handler);
            this.addMouseMotionListener(handler);
        }
    }

    public void scrollRectToVisible(Rectangle aRect) {
        if (!NO_SCROLL) {
            super.scrollRectToVisible(aRect);
        } else {
            AWTEvent eo = EventQueue.getCurrentEvent();
            if (eo instanceof MouseEvent && ((MouseEvent)eo).getID() == 506) {
                super.scrollRectToVisible(aRect);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.curMouseLoc = null;
    }

    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.assureSelection();
        return result;
    }

    public void assureSelection() {
        if (this.getSelectedIndex() == -1 && this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public String getToolTipText(MouseEvent me) {
        if (this.getModel() instanceof NavigatorListModel) {
            NavigatorListModel nlm = (NavigatorListModel)this.getModel();
            int idx = NavigatorJList.indexAtLocation(this, me.getPoint());
            if (idx >= 0 && idx <= nlm.getSize()) {
                Object rep = nlm.getElementAt(idx);
                if (AbstractModel.isWaitMarker(rep) || AbstractModel.isInvalidMarker(rep)) {
                    return null;
                }
                return nlm.getTooltip(rep, me.getX(), me.getY());
            }
        }
        return "";
    }

    public Point getToolTipLocation(MouseEvent e) {
        Point result = e.getPoint();
        Container c = this.getTopLevelAncestor();
        Rectangle r = this.enclosingComp.getBounds();
        Rectangle converted = SwingUtilities.convertRectangle(this, r, c);
        boolean closerToLeft = converted.x + converted.width < c.getWidth() - converted.x;
        result = SwingUtilities.convertPoint(this, result, this.enclosingComp);
        int approxWidth = this.approximateWidth(this.getToolTipText(e));
        int approxHeight = NavigatorJList.widthTestLabel.getPreferredSize().height;
        result.x = closerToLeft ? r.x + r.width + 5 : r.x - (approxWidth + 5);
        result = SwingUtilities.convertPoint(this.enclosingComp, result, this);
        Point orig = e.getPoint();
        int idx = this.locationToIndex(orig);
        Rectangle r2 = this.getCellBounds(idx, idx);
        if (r2 != null) {
            result.y = r2.y;
        }
        return result;
    }

    public String getToolTipText() {
        Rectangle rect;
        int index = this.getSelectedIndex();
        if (index >= 0 && (rect = this.getCellBounds(index, index)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TooltipHack.invokeTip(NavigatorJList.this, (int)rect.getCenterX(), (int)rect.getCenterY(), Integer.MAX_VALUE);
                }
            });
        }
        return "";
    }

    public boolean isTooltipLocValid(int x, int y) {
        if (this.curMouseLoc == null || !this.isMouseInside) {
            return false;
        }
        return NavigatorJList.indexAtLocation(this, this.curMouseLoc) == NavigatorJList.indexAtLocation(this, new Point(x, y));
    }

    private int approximateWidth(String s) {
        widthTestLabel.setText(s);
        return NavigatorJList.widthTestLabel.getPreferredSize().width;
    }

    public static int indexAtLocation(JList list, Point location) {
        int result = list.locationToIndex(location);
        Rectangle cellB = list.getCellBounds(result, result);
        if (result != -1 && !cellB.contains(location)) {
            result = -1;
        }
        return result;
    }

    public void mouseMoved(MouseEvent e) {
        this.curMouseLoc = e.getPoint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.isMouseInside = true;
    }

    public void mouseExited(MouseEvent e) {
        this.isMouseInside = false;
        TooltipHack.invokeTip(this, 0, 0, 0);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void ignoreNextKeyUntilReleased() {
        this.ignoreNextKey = true;
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.ignoreNextKey) {
            if (e.getID() == 402) {
                this.ignoreNextKey = false;
            }
        } else {
            super.processKeyEvent(e);
        }
    }
}

