/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.web.debug.watchesfiltering.JspElWatch;
import org.netbeans.modules.web.debug.watchesfiltering.WatchPanel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JspWatchesActionsProvider
implements NodeActionsProvider {
    private static final Action NEW_WATCH_ACTION = new AbstractAction(NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_AddNew")){

        public void actionPerformed(ActionEvent e) {
            JspWatchesActionsProvider.newWatch();
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_DeleteAll")){

        public void actionPerformed(ActionEvent e) {
            DebuggerManager.getDebuggerManager().removeAllWatches();
        }
    };
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((JspElWatch)nodes[i]).getWatch().remove();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action CUSTOMIZE_ACTION;

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof JspElWatch) {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null, CUSTOMIZE_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof JspElWatch) {
            JspWatchesActionsProvider.customize(((JspElWatch)node).getWatch());
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void customize(Watch w) {
        WatchPanel wp = new WatchPanel(w.getExpression());
        JComponent panel = wp.getPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(JspWatchesActionsProvider.class, (String)"CTL_Edit_Watch_Dialog_Title", (Object)w.getExpression()));
        dd.setHelpCtx(new HelpCtx("debug.add.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        dialog.dispose();
        if (dd.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        w.setExpression(wp.getExpression());
    }

    private static void newWatch() {
        WatchPanel wp = new WatchPanel("");
        JComponent panel = wp.getPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(JspWatchesActionsProvider.class, (String)"CTL_New_Watch_Dialog_Title"));
        dd.setHelpCtx(new HelpCtx("debug.new.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        dialog.dispose();
        if (dd.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        DebuggerManager.getDebuggerManager().createWatch(wp.getExpression());
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        CUSTOMIZE_ACTION = Models.createAction((String)NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_Customize"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                JspWatchesActionsProvider.customize(((JspElWatch)nodes[0]).getWatch());
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }
}

