/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.faces;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.Mappings;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.Processor;
import org.apache.shale.remoting.impl.MappingImpl;
import org.apache.shale.remoting.impl.MappingsImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MappingsHelper {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.shale.remoting.Bundle");
    private transient Log log = null;

    public Mappings getMappings(FacesContext context) {
        Mappings mappings = (Mappings)context.getExternalContext().getApplicationMap().get("org.apache.shale.remoting.MAPPINGS");
        if (mappings == null) {
            mappings = this.createMappings(context);
            context.getExternalContext().getApplicationMap().put("org.apache.shale.remoting.MAPPINGS", mappings);
        }
        return mappings;
    }

    private void configureMappings(FacesContext context, Mappings mappings, String paramName, Mechanism mechanism, String defaultValue) {
        String paramValue;
        Class clazz = MappingImpl.class;
        String mappingClass = context.getExternalContext().getInitParameter("org.apache.shale.remoting.MAPPING_CLASS");
        if (mappingClass != null) {
            try {
                clazz = this.loadClass(mappingClass);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        if ((paramValue = context.getExternalContext().getInitParameter(paramName)) == null) {
            paramValue = defaultValue;
        }
        if (paramValue == null) {
            return;
        }
        while ((paramValue = paramValue.trim()).length() != 0) {
            String pair = null;
            int comma = paramValue.indexOf(44);
            if (comma >= 0) {
                pair = paramValue.substring(0, comma).trim();
                paramValue = paramValue.substring(comma + 1);
            } else {
                pair = paramValue.trim();
                paramValue = "";
            }
            int colon = pair.indexOf(58);
            if (colon < 0) {
                throw new IllegalArgumentException(pair);
            }
            String pattern = pair.substring(0, colon).trim();
            String processorClass = pair.substring(colon + 1).trim();
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)this.bundle.getString("mapping.configure"));
                this.log().info((Object)(pattern + ":" + processorClass));
            }
            Class processorClazz = null;
            try {
                processorClazz = this.loadClass(processorClass);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            try {
                Mapping mapping = (Mapping)clazz.newInstance();
                mapping.setMappings(mappings);
                mapping.setMechanism(mechanism);
                mapping.setPattern(pattern);
                mapping.setProcessor((Processor)processorClazz.newInstance());
                mappings.addMapping(mapping);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    private Mappings createMappings(FacesContext context) {
        Mappings mappings = null;
        String mappingsClass = MappingsImpl.class.getName();
        String mappingsClassParam = context.getExternalContext().getInitParameter("org.apache.shale.remoting.MAPPINGS_CLASS");
        if (mappingsClassParam != null) {
            mappingsClass = mappingsClassParam;
        }
        Class clazz = null;
        try {
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)this.bundle.getString("mappings.configure"));
                this.log().info((Object)mappingsClass);
            }
            clazz = this.loadClass(mappingsClass);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        try {
            mappings = (Mappings)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        this.configureMappings(context, mappings, "org.apache.shale.remoting.CLASS_RESOURCES", Mechanism.CLASS_RESOURCE, "/static/*:org.apache.shale.remoting.impl.ClassResourceProcessor");
        this.configureMappings(context, mappings, "org.apache.shale.remoting.DYNAMIC_RESOURCES", Mechanism.DYNAMIC_RESOURCE, "/dynamic/*:org.apache.shale.remoting.impl.MethodBindingProcessor");
        this.configureMappings(context, mappings, "org.apache.shale.remoting.OTHER_RESOURCES", Mechanism.OTHER_RESOURCE, null);
        this.configureMappings(context, mappings, "org.apache.shale.remoting.WEBAPP_RESOURCES", Mechanism.WEBAPP_RESOURCE, "/webapp/*:org.apache.shale.remoting.impl.WebResourceProcessor");
        String extension = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (extension == null) {
            extension = ".jsp";
        }
        mappings.setExtension(extension);
        String[] patterns = this.patterns(context);
        if (this.log().isTraceEnabled()) {
            for (int i = 0; i < patterns.length; ++i) {
                this.log().trace((Object)("FacesServlet is mapped with URL pattern '" + patterns[i] + "'"));
            }
        }
        mappings.setPatterns(patterns);
        return mappings;
    }

    private Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl.loadClass(name);
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)MappingsHelper.class);
        }
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] patterns(FacesContext context) {
        Object method;
        Document document = null;
        InputStream stream = null;
        try {
            Object ctxt = context.getExternalContext().getContext();
            method = ctxt.getClass().getMethod("getResource", String.class);
            URL url = (URL)((Method)method).invoke(ctxt, "/WEB-INF/web.xml");
            if (url == null) {
                if (this.log().isTraceEnabled()) {
                    this.log().trace((Object)"No /WEB-INF/web.xml resource available, returning empty list");
                }
                String[] stringArray = new String[]{};
                return stringArray;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            stream = url.openStream();
            document = db.parse(stream);
        }
        catch (Exception e) {
            if (this.log().isErrorEnabled()) {
                this.log().error((Object)this.bundle.getString("mappings.parseWebXml"), (Throwable)e);
            }
            method = new String[]{};
            return method;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        String name = null;
        NodeList servletNodes = document.getElementsByTagName("servlet");
        for (int i = 0; i < servletNodes.getLength(); ++i) {
            Node servletNode = servletNodes.item(i);
            String servletName = null;
            String servletClass = null;
            NodeList kids = servletNode.getChildNodes();
            for (int j = 0; j < kids.getLength(); ++j) {
                Node kid = kids.item(j);
                if ("servlet-name".equals(kid.getNodeName())) {
                    servletName = this.text(kid);
                    continue;
                }
                if (!"servlet-class".equals(kid.getNodeName())) continue;
                servletClass = this.text(kid);
            }
            if (!"javax.faces.webapp.FacesServlet".equals(servletClass)) continue;
            name = servletName;
        }
        if (name == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        NodeList mappingNodes = document.getElementsByTagName("servlet-mapping");
        for (int i = 0; i < mappingNodes.getLength(); ++i) {
            Node mappingNode = mappingNodes.item(i);
            String servletName = null;
            String urlPattern = null;
            NodeList kids = mappingNode.getChildNodes();
            for (int j = 0; j < kids.getLength(); ++j) {
                Node kid = kids.item(j);
                if ("servlet-name".equals(kid.getNodeName())) {
                    servletName = this.text(kid);
                    continue;
                }
                if (!"url-pattern".equals(kid.getNodeName())) continue;
                urlPattern = this.text(kid);
            }
            if (!name.equals(servletName)) continue;
            list.add(urlPattern);
        }
        return list.toArray(new String[list.size()]);
    }

    private String text(Node node) {
        NodeList kids = node.getChildNodes();
        for (int k = 0; k < kids.getLength(); ++k) {
            Node kid = kids.item(k);
            if (!"#text".equals(kid.getNodeName())) continue;
            return kid.getNodeValue().trim();
        }
        return "";
    }
}

