/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.selectvalue;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.model.SelectItem;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SelectValuePhaseListener
implements PhaseListener {
    private static final String SELECTVALUE_VIEW_ID = "ajax-selectvalue";

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        String rootId = context.getViewRoot().getViewId();
        if (rootId.indexOf(SELECTVALUE_VIEW_ID) != -1) {
            this.handleAjaxRequest(event);
        }
    }

    private void handleAjaxRequest(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        Object object = context.getExternalContext().getRequest();
        if (!(object instanceof HttpServletRequest)) {
            return;
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String method = (String)requestMap.get("itemsmethod");
        String value = (String)requestMap.get("selectvalue");
        StringBuffer sb = new StringBuffer();
        try {
            SelectItem[] results = this.getItems(context, method, value);
            if (results == null) {
                response.setStatus(204);
                return;
            }
            sb.append("<items>");
            for (int i = 0; i < results.length; ++i) {
                sb.append("<item>");
                SelectItem item = results[i];
                sb.append("<value>");
                if (item.getValue() != null) {
                    sb.append(item.getValue().toString());
                }
                sb.append("</value>");
                sb.append("<label>");
                sb.append(item.getLabel());
                sb.append("</label>");
                sb.append("<description>");
                sb.append(item.getDescription());
                sb.append("</description>");
                sb.append("</item>");
            }
            sb.append("</items>");
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().write(sb.toString());
            event.getFacesContext().responseComplete();
            return;
        }
        catch (EvaluationException ee) {
            ee.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private SelectItem[] getItems(FacesContext context, String methodExpr, String selectValue) {
        if (methodExpr == null) {
            return null;
        }
        if (UIComponentTag.isValueReference((String)methodExpr)) {
            Class[] argTypes = new Class[]{FacesContext.class, String.class};
            MethodBinding vb = context.getApplication().createMethodBinding(methodExpr, argTypes);
            Object[] args = new Object[]{context, selectValue};
            SelectItem[] result = (SelectItem[])vb.invoke(context, args);
            return result;
        }
        throw new FacesException("Method binding expression '" + methodExpr + "' is not an expression");
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }
}

