/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.popupcalendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class SqlUtilDateConverter
implements Converter {
    private static String isoDatePattern = "yyyy-MM-dd";
    private static SimpleDateFormat isoDateFormat = new SimpleDateFormat(isoDatePattern);

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return java.sql.Date.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException("Error parsing value '" + value + "'", (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return isoDateFormat.format(date);
        }
        throw new ConverterException("Unexpected type: " + value.getClass().getName());
    }
}

