/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public abstract class LookupSensitiveAction
extends BasicAction
implements LookupListener {
    private Lookup lookup;
    private Class[] watch;
    private static Logger UILOG;
    private Lookup.Result[] results;
    private boolean needsRefresh = true;
    private boolean initialized = false;
    private static boolean refreshing;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$util$LookupListener;

    public LookupSensitiveAction(Icon icon, Lookup lookup, Class[] watch) {
        super(null, icon);
        if (lookup == null) {
            lookup = Utilities.actionsGlobalContext();
        }
        this.lookup = lookup;
        this.watch = watch;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)"Cannot be called outside EQ!");
        }
        this.results = new Lookup.Result[this.watch.length];
        for (int i = 0; i < this.watch.length; ++i) {
            this.results[i] = this.lookup.lookup(new Lookup.Template(this.watch[i]));
            this.results[i].allItems();
            LookupListener resultListener = (LookupListener)WeakListeners.create((Class)(class$org$openide$util$LookupListener == null ? LookupSensitiveAction.class$("org.openide.util.LookupListener") : class$org$openide$util$LookupListener), (EventListener)this, (Object)this.results[i]);
            this.results[i].addLookupListener(resultListener);
        }
        this.initialized = true;
    }

    public Object getValue(String key) {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.getValue(key);
    }

    public boolean isEnabled() {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.isEnabled();
    }

    public final void actionPerformed(ActionEvent e) {
        boolean isKey;
        this.init();
        if (UILOG.isLoggable(Level.FINE) && !(isKey = e.getSource() instanceof JMenuItem ? false : !(e.getSource() instanceof JButton))) {
            LogRecord r = new LogRecord(Level.FINE, "UI_ACTION_BUTTON_PRESS");
            r.setResourceBundle(NbBundle.getBundle((Class)LookupSensitiveAction.class));
            r.setParameters(new Object[]{e.getSource(), e.getSource().getClass().getName(), this, this.getClass().getName(), this.getValue("Name")});
            r.setLoggerName(UILOG.getName());
            UILOG.log(r);
        }
        this.actionPerformed(this.lookup);
    }

    protected final Lookup getLookup() {
        return this.lookup;
    }

    private void doRefresh() {
        refreshing = true;
        this.refresh(this.lookup);
        refreshing = false;
        this.needsRefresh = false;
    }

    protected abstract void actionPerformed(Lookup var1);

    protected abstract void refresh(Lookup var1);

    public void resultChanged(LookupEvent e) {
        if (refreshing) {
            return;
        }
        if (this.getPropertyChangeListeners().length == 0) {
            this.needsRefresh = true;
        } else {
            this.doRefresh();
        }
    }

    static {
        $assertionsDisabled = !LookupSensitiveAction.class.desiredAssertionStatus();
        UILOG = Logger.getLogger("org.netbeans.ui.actions");
        refreshing = false;
    }
}

