/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.wizard.ConnectionWizardPanel3;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class ConnectionPanel3
extends JPanel {
    private ConnectionWizardPanel3 wizardPanel;
    private Class[] parameters;
    private ParametersPicker[] pickers;
    private boolean valid = false;
    private ChangeListener paramsChangeListener = null;
    private JLabel paramLabel;
    private JTextField previewField;
    private JLabel previewLabel;
    private JTabbedPane parameterTabs;

    public ConnectionPanel3(ConnectionWizardPanel3 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        ResourceBundle bundle = NbBundle.getBundle(ConnectionPanel3.class);
        this.setName(bundle.getString("CTL_CW_Step3_Title"));
        this.paramsChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ConnectionPanel3.this.updatePreview();
            }
        };
        this.paramLabel.setText(bundle.getString("CTL_CW_ParamTabs"));
        this.paramLabel.setDisplayedMnemonic(bundle.getString("CTL_CW_ParamTabs_Mnemonic").charAt(0));
        this.previewLabel.setText(bundle.getString("CTL_CW_GeneratedPreview"));
        this.previewLabel.setDisplayedMnemonic(bundle.getString("CTL_CW_GeneratedPreview_Mnemonic").charAt(0));
        this.previewField.setText(bundle.getString("CTL_CW_Preview"));
        this.previewField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_Preview"));
        this.parameterTabs.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_ParamTabs"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_ConnectionPanel3"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 300);
    }

    void setMethod(Method m) {
        this.parameterTabs.removeChangeListener(this.paramsChangeListener);
        this.parameterTabs.removeAll();
        this.parameters = m.getParameterTypes();
        this.pickers = new ParametersPicker[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.pickers[i] = new ParametersPicker(this.wizardPanel.getFormModel(), this.parameters[i]);
            this.pickers[i].addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    ConnectionPanel3.this.updatePreview();
                }
            });
            this.pickers[i].setBorder(new EmptyBorder(6, 6, 5, 5));
            this.parameterTabs.addTab(Utilities.getShortClassName((Class)this.parameters[i]), null, this.pickers[i], this.parameters[i].getName());
        }
        this.valid = this.isValid();
        this.parameterTabs.addChangeListener(this.paramsChangeListener);
        this.updatePreview();
    }

    String getParametersText() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.pickers.length; ++i) {
            buf.append(this.pickers[i].getText());
            if (i == this.pickers.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    Object[] getParameters() {
        try {
            Object[] values = new Object[this.pickers.length];
            for (int i = 0; i < this.pickers.length; ++i) {
                values[i] = this.pickers[i].getPropertyValue();
            }
            return values;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getPreviewText() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.pickers.length; ++i) {
            buf.append(this.pickers[i].getPreviewText());
            if (i == this.pickers.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private void updatePreview() {
        this.previewField.setText(this.getPreviewText());
        boolean now = this.isFilled();
        if (now != this.valid) {
            this.valid = now;
            this.wizardPanel.fireStateChanged();
        }
    }

    boolean isFilled() {
        for (int i = 0; i < this.pickers.length; ++i) {
            if (this.pickers[i].isFilled()) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.paramLabel = new JLabel();
        this.parameterTabs = new JTabbedPane();
        this.previewLabel = new JLabel();
        this.previewField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.paramLabel.setText("jLabel2");
        this.paramLabel.setLabelFor(this.parameterTabs);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.parameterTabs, gridBagConstraints);
        this.previewLabel.setText("jLabel1");
        this.previewLabel.setLabelFor(this.previewField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.previewLabel, gridBagConstraints);
        this.previewField.setEditable(false);
        this.previewField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.previewField, gridBagConstraints);
    }
}

