/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

class ChooseBeansWizardPanel
implements WizardDescriptor.Panel {
    private File[] currentFiles;
    private Map libraryNameMap;
    private List markedBeans;
    private List allBeans;
    private String sourceType;
    private BeanSelector beanSelector;
    private JLabel noBeansLabel;
    private EventListenerList listenerList;

    ChooseBeansWizardPanel() {
    }

    public Component getComponent() {
        if (this.markedBeans == null && (this.allBeans == null || this.allBeans.size() == 0)) {
            String messageKey;
            if ("jar".equals(this.sourceType)) {
                messageKey = "MSG_NoBeanInJAR";
            } else if ("library".equals(this.sourceType)) {
                messageKey = "MSG_NoBeanInLibrary";
            } else if ("project".equals(this.sourceType)) {
                messageKey = "MSG_NoBeanInProject";
            } else {
                throw new IllegalArgumentException();
            }
            this.noBeansLabel = new JLabel(PaletteUtils.getBundleString(messageKey));
            this.noBeansLabel.setPreferredSize(new Dimension(400, 300));
            this.noBeansLabel.setVerticalAlignment(1);
            this.noBeansLabel.setName(PaletteUtils.getBundleString("CTL_NoBeans_Caption"));
            this.noBeansLabel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            return this.noBeansLabel;
        }
        if (this.beanSelector == null) {
            this.beanSelector = new BeanSelector();
            this.beanSelector.setName(PaletteUtils.getBundleString("CTL_SelectBeans_Caption"));
            this.beanSelector.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.markedBeans != null || this.allBeans != null) {
                this.beanSelector.setBeans(this.markedBeans, this.allBeans);
            }
            Listener listener = new Listener();
            this.beanSelector.list.addListSelectionListener(listener);
            this.beanSelector.radio1.addActionListener(listener);
            this.beanSelector.radio2.addActionListener(listener);
        }
        return this.beanSelector;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        return this.beanSelector != null && this.beanSelector.getSelectedBeans().size() > 0;
    }

    public void readSettings(Object settings) {
        AddToPaletteWizard wizard = (AddToPaletteWizard)((Object)settings);
        this.sourceType = wizard.getSourceType();
        File[] jarFiles = wizard.getJARFiles();
        if (this.currentFiles != null && this.currentFiles.length == jarFiles.length) {
            for (int i = 0; i < jarFiles.length && jarFiles[i].equals(this.currentFiles[i]); ++i) {
                if (i + 1 != jarFiles.length) continue;
                return;
            }
        }
        this.currentFiles = jarFiles;
        this.libraryNameMap = wizard.libraryNameMap;
        this.allBeans = null;
        this.markedBeans = BeanInstaller.findJavaBeansInJar(jarFiles);
        if (this.markedBeans != null) {
            if (this.libraryNameMap != null) {
                ChooseBeansWizardPanel.remapLibraryNames(this.markedBeans, this.libraryNameMap);
            }
            Collections.sort(this.markedBeans);
        } else {
            this.allBeans = BeanInstaller.findJavaBeans(jarFiles);
            if (this.libraryNameMap != null) {
                ChooseBeansWizardPanel.remapLibraryNames(this.allBeans, this.libraryNameMap);
            }
            Collections.sort(this.allBeans);
        }
        if (this.beanSelector != null) {
            this.beanSelector.setBeans(this.markedBeans, this.allBeans);
        }
    }

    public void storeSettings(Object settings) {
        if (this.beanSelector != null) {
            List itemList = this.beanSelector.getSelectedBeans();
            BeanInstaller.ItemInfo[] itemArray = new BeanInstaller.ItemInfo[itemList.size()];
            itemList.toArray(itemArray);
            ((AddToPaletteWizard)((Object)settings)).setSelectedBeans(itemArray);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    private static void remapLibraryNames(List beans, Map map) {
        int n = beans.size();
        for (int i = 0; i < n; ++i) {
            BeanInstaller.ItemInfo ii = (BeanInstaller.ItemInfo)beans.get(i);
            ii.source = (String)map.get(ii.source);
        }
    }

    class Listener
    implements ListSelectionListener,
    ActionListener {
        Listener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ChooseBeansWizardPanel.this.fireStateChanged();
        }

        public void actionPerformed(ActionEvent ev) {
            if ("SHOW MARKED".equals(ev.getActionCommand())) {
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.markedBeans);
            } else if ("SHOW ALL".equals(ev.getActionCommand())) {
                if (ChooseBeansWizardPanel.this.allBeans == null) {
                    ChooseBeansWizardPanel.this.allBeans = BeanInstaller.findJavaBeans(ChooseBeansWizardPanel.this.currentFiles);
                    if (ChooseBeansWizardPanel.this.libraryNameMap != null) {
                        ChooseBeansWizardPanel.remapLibraryNames(ChooseBeansWizardPanel.this.allBeans, ChooseBeansWizardPanel.this.libraryNameMap);
                        ChooseBeansWizardPanel.this.libraryNameMap = null;
                    }
                    Collections.sort(ChooseBeansWizardPanel.this.allBeans);
                }
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.allBeans);
            }
        }
    }

    private static class ItemInfoRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public ItemInfoRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name = ((BeanInstaller.ItemInfo)value).classname;
            this.setToolTipText(name);
            int i = name.lastIndexOf(46);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            this.setText(name);
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    static class BeanSelector
    extends JPanel {
        JList list;
        JRadioButton radio1;
        JRadioButton radio2;

        BeanSelector() {
            this.setLayout(new GridBagLayout());
            JLabel label1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label1, (String)PaletteUtils.getBundleString("CTL_SelectBeans"));
            label1.setLabelFor(this.list);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)label1, gridBagConstraints);
            this.list = new JList();
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(0);
            this.list.setCellRenderer(new ItemInfoRenderer());
            this.list.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_CTL_SelectBeans"));
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(this.list);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)scrollPane, gridBagConstraints);
            this.radio1 = new JRadioButton();
            this.radio1.setActionCommand("SHOW MARKED");
            Mnemonics.setLocalizedText((AbstractButton)this.radio1, (String)PaletteUtils.getBundleString("CTL_ShowMarked"));
            this.radio1.setToolTipText(PaletteUtils.getBundleString("HINT_ShowMarked"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio1, gridBagConstraints);
            this.radio2 = new JRadioButton();
            this.radio2.setActionCommand("SHOW ALL");
            Mnemonics.setLocalizedText((AbstractButton)this.radio2, (String)PaletteUtils.getBundleString("CTL_ShowAllClasses"));
            this.radio2.setToolTipText(PaletteUtils.getBundleString("HINT_ShowAllClasses"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio2, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radio1);
            buttonGroup.add(this.radio2);
            this.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_SelectBeansDialog"));
        }

        void setBeans(List markedBeans, List allBeans) {
            if (markedBeans == null) {
                this.radio1.setEnabled(false);
            } else {
                this.radio1.setEnabled(true);
                this.radio1.setSelected(true);
                this.setDisplayedBeans(markedBeans);
            }
            if (allBeans != null && markedBeans == null) {
                this.radio2.setSelected(true);
                this.setDisplayedBeans(allBeans);
            }
        }

        void setDisplayedBeans(final List beans) {
            this.list.setModel(new AbstractListModel(){

                public int getSize() {
                    return beans.size();
                }

                public Object getElementAt(int i) {
                    return beans.get(i);
                }
            });
        }

        List getSelectedBeans() {
            Object[] sel = this.list.getSelectedValues();
            ArrayList<Object> al = new ArrayList<Object>(sel.length);
            for (int i = 0; i < sel.length; ++i) {
                al.add(sel[i]);
            }
            return al;
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }
}

