/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.netbeans.modules.form.FormDataLoader;
import org.netbeans.modules.form.FormDataNode;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;

public class FormDataObject
extends JavaDataObject {
    private transient FormEditorSupport formEditor;
    private transient OpenEdit openEdit;
    FileEntry formEntry;
    static final long serialVersionUID = -975322003627854168L;

    public FormDataObject(FileObject ffo, FileObject jfo, FormDataLoader loader) throws DataObjectExistsException {
        super(jfo, (MultiFileLoader)loader);
        this.formEntry = (FileEntry)this.registerEntry(ffo);
        this.init();
    }

    private void init() {
        this.getCookieSet().add(new Class[]{OpenCookie.class, EditCookie.class}, (CookieSet.Factory)this);
    }

    public Node.Cookie createCookie(Class klass) {
        if (OpenCookie.class.equals((Object)klass) || EditCookie.class.equals((Object)klass)) {
            if (this.openEdit == null) {
                this.openEdit = new OpenEdit();
            }
            return this.openEdit;
        }
        return super.createCookie(klass);
    }

    public FileObject getFormFile() {
        return this.formEntry.getFile();
    }

    public boolean isReadOnly() {
        FileObject javaFO = this.getPrimaryFile();
        FileObject formFO = this.formEntry.getFile();
        return !javaFO.canWrite() || !formFO.canWrite();
    }

    public boolean formFileReadOnly() {
        return !this.formEntry.getFile().canWrite();
    }

    protected JavaEditor createJavaEditor() {
        if (this.formEditor == null) {
            this.formEditor = new FormEditorSupport(this.getPrimaryEntry(), this);
        }
        return this.formEditor;
    }

    public FormEditorSupport getFormEditorSupport() {
        return (FormEditorSupport)this.getJavaEditor();
    }

    public FormEditorSupport getFormEditor() {
        return this.getFormEditorSupport();
    }

    FileEntry getFormEntry() {
        return this.formEntry;
    }

    protected Node createNodeDelegate() {
        FormDataNode node = new FormDataNode(this);
        return node;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.init();
    }

    private class OpenEdit
    implements OpenCookie,
    EditCookie {
        private OpenEdit() {
        }

        public void open() {
            FormDataObject.this.getFormEditorSupport().openFormEditor(true);
        }

        public void edit() {
            FormDataObject.this.getFormEditorSupport().open();
        }
    }
}

