/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;

public class MultiDataContainer
implements DataObject.Container,
PropertyChangeListener {
    public static final String PROP_CONTAINERS = "containers";
    public static final String PROP_CONTENTS = "contents";
    private static final DataObject[] EMPTY_CHILDREN = new DataObject[0];
    DataObject[] children;
    Collection contents;
    DataFilter filter;
    boolean refreshChildren;
    Map nestedContainers;
    Map containerContents;
    PropertyChangeSupport propSupport;

    public MultiDataContainer() {
        this(DataFilter.ALL);
    }

    public MultiDataContainer(DataFilter filter) {
        this(Collections.EMPTY_LIST, filter);
    }

    public MultiDataContainer(Collection sourceContainers, DataFilter filter) {
        this.contents = sourceContainers;
        this.filter = filter;
        this.children = EMPTY_CHILDREN;
        this.refreshChildren = true;
        this.nestedContainers = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Collection containers) {
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            DataObject.Container cont;
            if (((Object)this.contents).equals(containers)) {
                return;
            }
            Iterator it = this.contents.iterator();
            while (it.hasNext()) {
                cont = (DataObject.Container)it.next();
                cont.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.contents = Collections.unmodifiableCollection(containers);
            it = this.contents.iterator();
            while (it.hasNext()) {
                cont = (DataObject.Container)it.next();
                cont.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.invalidateChildren();
        }
        this.fireContentsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateChildren() {
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            this.refreshChildren = true;
        }
    }

    private void fireContentsChange() {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange(PROP_CONTENTS, null, null);
        this.fireChildrenChange();
    }

    private void fireChildrenChange() {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange("children", null, null);
    }

    public Collection getContents() {
        return this.contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject[] getChildren() {
        if (this.refreshChildren) {
            MultiDataContainer multiDataContainer = this;
            synchronized (multiDataContainer) {
                this.refreshChildren = false;
                this.refreshData();
            }
        }
        return this.children;
    }

    public Map getContainers() {
        return this.nestedContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshData() {
        HashSet knownKeys = new HashSet(31);
        LinkedList newChildren = new LinkedList();
        HashMap newContainers = new HashMap(31);
        int rejected = 0;
        Iterator it = this.getContents().iterator();
        while (it.hasNext()) {
            rejected += this.addContainer(newContainers, knownKeys, newChildren, (DataObject.Container)it.next());
        }
        boolean containersChanged = false;
        Iterator it2 = newContainers.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry en = it2.next();
            Object k = en.getKey();
            Collection sources = (Collection)en.getValue();
            MultiDataContainer nested = (MultiDataContainer)this.nestedContainers.get(k);
            if (nested == null) {
                System.err.println("creating nested container for " + k);
                nested = this.createContainer(sources);
                containersChanged = true;
            } else {
                nested.setContents(sources);
            }
            en.setValue(nested);
        }
        if (this.nestedContainers != null) {
            it2 = this.nestedContainers.keySet().iterator();
            while (!containersChanged && it2.hasNext()) {
                containersChanged &= newContainers.containsKey(it2.next());
            }
        } else {
            containersChanged |= !newContainers.isEmpty();
        }
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            this.nestedContainers = newContainers;
            this.children = newChildren.toArray(new DataObject[newChildren.size()]);
        }
        if (containersChanged) {
            this.propSupport.firePropertyChange(PROP_CONTAINERS, null, null);
        }
    }

    private int addContainer(Map containers, Set presentKeys, Collection contents, DataObject.Container folder) {
        System.err.println("addContainer: " + folder);
        DataObject[] children = folder.getChildren();
        int rejected = 0;
        for (int i = 0; i < children.length; ++i) {
            DataObject obj;
            DataObject o = obj = children[i];
            Object key = this.createKey(obj);
            if (!this.filter.acceptDataObject(obj)) {
                System.err.println("addContainer: " + obj + " was rejected. ");
                ++rejected;
                continue;
            }
            if (this.isContainer(obj)) {
                System.err.println("got container: " + obj + " with key " + key);
                LinkedList<DataObject> c = (LinkedList<DataObject>)containers.get(key);
                if (c == null) {
                    c = new LinkedList<DataObject>();
                    containers.put(key, c);
                    System.err.println("new container");
                }
                c.add(obj);
                continue;
            }
            if (!presentKeys.add(key)) continue;
            contents.add(o);
        }
        return rejected;
    }

    public DataFilter getFilter() {
        return this.filter;
    }

    public MultiDataContainer createContainer(Collection initialSources) {
        return new MultiDataContainer(initialSources, this.getFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) throws IllegalArgumentException {
        if (l == null) {
            throw new IllegalArgumentException("eee");
        }
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            if (this.propSupport == null) {
                this.propSupport = new PropertyChangeSupport(this);
            }
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    protected Object createKey(DataObject d) {
        return d.getName();
    }

    protected boolean isContainer(DataObject d) {
        return d.getCookie(DataObject.Container.class) != null;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(l);
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("children".equals(event.getPropertyName())) {
            this.invalidateChildren();
            this.fireChildrenChange();
        }
    }
}

