/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.APIAccess;
import org.netbeans.modules.masterfs.Cache;
import org.netbeans.modules.masterfs.ExLocalFileSystem;
import org.netbeans.modules.masterfs.InternalMountSupport;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SyncSection;
import org.netbeans.modules.masterfs.Utils;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.providers.MountSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

final class MountTable
implements InternalMountSupport {
    private static final Map res2fsMap = Collections.synchronizedMap(new HashMap());
    private static final MountTable instance = new MountTable();
    static final MountSupport mountSupport = APIAccess.DEFAULT.createMountSupport(instance);

    static MountTable getDefault() {
        return instance;
    }

    private MountTable() {
    }

    public void mount(final String mountPointPath, final FileSystem mount) throws IOException {
        final boolean syncNeeded = !(mount instanceof ExLocalFileSystem);
        final String normName = ResourcePath.getNormalizedPath(mountPointPath);
        MasterFileSystem.getDefault().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (syncNeeded) {
                    SyncSection.getDefault().enterExclusiveSection();
                    try {
                        MountTable.this.mountIt(normName, mount, mountPointPath);
                    }
                    finally {
                        SyncSection.getDefault().finishExclusiveSection();
                    }
                } else {
                    MountTable.this.mountIt(normName, mount, mountPointPath);
                }
            }
        });
        mount.addFileStatusListener((FileStatusListener)MasterFileSystem.getDefault());
        mount.addNotify();
    }

    private void mountIt(String normName, FileSystem mount, String mountPointPath) throws IOException {
        FileSystem oldFs = res2fsMap.put(normName, mount);
        if (oldFs != null) {
            this.handleAlreadyMounted(oldFs, mount, normName);
        } else {
            MountTable.refreshAfterMount(this.getMountEnumeration(mountPointPath));
        }
    }

    public void unmount(final FileSystem mount) throws IOException {
        MasterFileSystem.getDefault().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                SyncSection.getDefault().enterExclusiveSection();
                try {
                    if (!MountTable.this.removeFileSystem(mount)) {
                        String errMsg = Utils.formatString("EXC_CannotUnMount", new Object[]{mount.getDisplayName()});
                        throw new IOException(errMsg);
                    }
                }
                finally {
                    SyncSection.getDefault().finishExclusiveSection();
                }
            }
        });
        mount.removeFileStatusListener((FileStatusListener)MasterFileSystem.getDefault());
        mount.removeNotify();
    }

    FileObject resolveBestDelegate(String resourcePath) {
        return this.resolveDelegate(resourcePath, 0);
    }

    FileObject resolveSecondDelegate(String resourcePath) {
        return this.resolveDelegate(resourcePath, 1);
    }

    void unmount(String mountPointPath) throws IOException {
        FileSystem fs = this.getMountedFileSystem(mountPointPath);
        if (fs != null) {
            MountTable.getDefault().unmount(fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration geAllFileSystems() {
        ArrayList<FileSystem> qE = new ArrayList<FileSystem>();
        Collection values = res2fsMap.values();
        SyncSection.getDefault().enterSection();
        try {
            Map map = res2fsMap;
            synchronized (map) {
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem)it.next();
                    if (fs == null) continue;
                    qE.add(fs);
                }
            }
        }
        finally {
            SyncSection.getDefault().finishSection();
        }
        return Collections.enumeration(qE);
    }

    boolean isMounted(FileSystem mount) {
        ResourcePath resource = this.findResourcePath(mount);
        FileSystem fsTest = (FileSystem)res2fsMap.get(resource.getNormalizedPath());
        return mount == fsTest;
    }

    private ResourcePath findResourcePath(FileSystem fs) {
        File f = FileUtil.toFile((FileObject)fs.getRoot());
        return Utils.getResource(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject resolveDelegate(String resourcePath, int delegateLevel) {
        FileObject retVal;
        FileSystem fs;
        Object f;
        String bestMountPoint = "";
        LinkedList<String> retValList = new LinkedList<String>();
        if (WriteLockUtils.hasActiveLockFileSigns(resourcePath = ResourcePath.getNormalizedPath(resourcePath)) && WriteLockUtils.hasActiveLockFileSigns(((File)(f = new ResourcePath(resourcePath).getFile())).getAbsolutePath())) {
            return null;
        }
        f = res2fsMap;
        synchronized (f) {
            ArrayList sortedList = new ArrayList(res2fsMap.keySet());
            Collections.sort(sortedList);
            Iterator it = sortedList.iterator();
            while (it.hasNext()) {
                boolean isMountPoint;
                String mountPoint = (String)it.next();
                if (!resourcePath.startsWith(mountPoint) || mountPoint.length() <= bestMountPoint.length()) continue;
                boolean bl = isMountPoint = mountPoint.length() == resourcePath.length() || resourcePath.charAt(mountPoint.length()) == '/';
                if (!isMountPoint && !new ResourcePath(mountPoint).isRoot()) continue;
                bestMountPoint = mountPoint;
                retValList.addLast(bestMountPoint);
            }
            if (retValList.size() == 0) {
                return null;
            }
            int idx = retValList.size() - (delegateLevel + 1);
            if (idx < 0) {
                idx = 0;
            }
            bestMountPoint = (String)retValList.get(idx);
            fs = (FileSystem)res2fsMap.get(bestMountPoint);
        }
        if (fs instanceof FileBasedFileSystem) {
            File f2 = new ResourcePath(resourcePath).getFile();
            retVal = fs.findResource(f2.getAbsolutePath());
        } else {
            retVal = fs.findResource(resourcePath.substring(bestMountPoint.length()));
        }
        return retVal;
    }

    private static void refreshAfterMount(Enumeration changeList) {
        LinkedHashSet<MasterFileObject> toReset = new LinkedHashSet<MasterFileObject>();
        while (changeList.hasMoreElements()) {
            MasterFileObject hfo = (MasterFileObject)((Object)changeList.nextElement());
            MountTable.refreshAfterMount(hfo);
            toReset.add(hfo);
        }
        MountTable.resetAfterMount(toReset);
        MasterFileSystem masterFs = MasterFileSystem.getDefault();
        masterFs.fireFileStatus(new FileStatusEvent((FileSystem)masterFs, toReset, true, true));
    }

    static void refreshAfterMount(MasterFileObject hfo) {
        FileObject oldDelegate = hfo.getDelegate().get();
        if (oldDelegate == null) {
            return;
        }
        FileObject newDelegate = MountTable.getDefault().resolveBestDelegate(hfo.getResource().getNormalizedPath());
        if (oldDelegate == newDelegate) {
            return;
        }
        MasterFileObject.refreshAfterMount(newDelegate, oldDelegate, hfo);
    }

    private static void resetAfterMount(Set toReset) {
        Iterator it = toReset.iterator();
        while (it.hasNext()) {
            MasterFileObject hfo = (MasterFileObject)((Object)it.next());
            hfo.getDelegate().reset(hfo.getResource());
        }
    }

    static void renameCachedFileObjects(String oldName, String newName) {
        Enumeration en = Cache.getDefault().getAll();
        while (en.hasMoreElements()) {
            MasterFileObject fo = (MasterFileObject)((Object)en.nextElement());
            String oldResPath = fo.getResource().getNormalizedPath();
            if (oldResPath.startsWith(newName) || !oldResPath.startsWith(oldName)) continue;
            ResourcePath newResPath = new ResourcePath(newName + oldResPath.substring(oldName.length()));
            fo.setResource(newResPath);
            Cache.getDefault().replace(oldResPath, fo);
        }
    }

    private Enumeration getMountEnumeration(String mountPointPath) {
        class Mnt
        implements Enumerations.Processor {
            private final /* synthetic */ String val$mountPointPath;

            Mnt(String string) {
                this.val$mountPointPath = string;
            }

            public Object process(Object o, Collection ignore) {
                MasterFileObject hfo = (MasterFileObject)((Object)o);
                String normalizedMountPoint = ResourcePath.getNormalizedPath(this.val$mountPointPath);
                String normalizedResourcePath = hfo.getResource().getNormalizedPath();
                if (normalizedResourcePath.startsWith(normalizedMountPoint) && hfo.isValid()) {
                    return o;
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)Cache.getDefault().getAll(), (Enumerations.Processor)new Mnt(mountPointPath));
    }

    private static Enumeration getUnMountEnumeration(FileSystem fs2Umount) {
        class UnMnt
        implements Enumerations.Processor {
            private final /* synthetic */ FileSystem val$fs2Umount;

            UnMnt(FileSystem fileSystem) {
                this.val$fs2Umount = fileSystem;
            }

            public Object process(Object o, Collection ignore) {
                FileSystem delgFs;
                MasterFileObject hfo = (MasterFileObject)((Object)o);
                if (hfo != null && hfo.isValid() && (delgFs = hfo.getDelegateFileSystem()) == this.val$fs2Umount) {
                    return o;
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)Cache.getDefault().getAll(), (Enumerations.Processor)new UnMnt(fs2Umount));
    }

    FileSystem getMountedFileSystem(String resName) {
        resName = ResourcePath.getNormalizedPath(resName);
        FileSystem fsTest = (FileSystem)res2fsMap.get(resName);
        return fsTest;
    }

    private void handleAlreadyMounted(FileSystem originalFs, FileSystem newFs, String name) throws IOException {
        res2fsMap.put(name, originalFs);
    }

    private boolean removeFileSystem(FileSystem fs) {
        Iterator it = res2fsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FileSystem fsValue = (FileSystem)entry.getValue();
            if (fsValue != fs) continue;
            it.remove();
            MountTable.refreshAfterMount(MountTable.getUnMountEnumeration(fs));
            return true;
        }
        return false;
    }
}

