/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddDriverDialog;
import org.netbeans.modules.db.explorer.infos.DriverListNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class CustomizeDriverAction
extends DatabaseAction {
    static final long serialVersionUID = -109193000951395612L;
    private Dialog dialog;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DriverListNodeInfo;

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DriverNodeInfo info = (DriverNodeInfo)activatedNodes[0].getCookie(DriverNodeInfo.class);
        return info == null || !info.getURL().equals("sun.jdbc.odbc.JdbcOdbcDriver");
    }

    public void performAction(Node[] activatedNodes) {
        final Node[] n = activatedNodes;
        boolean drvIndex = false;
        final DriverNodeInfo info = (DriverNodeInfo)n[0].getCookie(DriverNodeInfo.class);
        if (info == null) {
            return;
        }
        JDBCDriver drv = info.getJDBCDriver();
        if (drv == null) {
            return;
        }
        final AddDriverDialog dlgPanel = new AddDriverDialog(drv);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == DialogDescriptor.OK_OPTION) {
                    String displayName = dlgPanel.getDisplayName();
                    List drvLoc = dlgPanel.getDriverLocation();
                    String drvClass = dlgPanel.getDriverClass();
                    StringBuffer err = new StringBuffer();
                    if (drvLoc.size() < 1) {
                        err.append(DatabaseAction.bundle().getString("AddDriverDialog_MissingFile"));
                    }
                    if (drvClass == null || drvClass.equals("")) {
                        if (err.length() > 0) {
                            err.append(", ");
                        }
                        err.append(DatabaseAction.bundle().getString("AddDriverDialog_MissingClass"));
                    }
                    if (err.length() > 0) {
                        String message = MessageFormat.format(DatabaseAction.bundle().getString("AddDriverDialog_ErrorMessage"), err.toString());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
                        return;
                    }
                    CustomizeDriverAction.this.closeDialog();
                    if (displayName == null || displayName.equals("")) {
                        displayName = drvClass;
                    }
                    try {
                        String oldName = info.getJDBCDriver().getName();
                        info.delete();
                        JDBCDriverManager.getDefault().addDriver(JDBCDriver.create(oldName, displayName, drvClass, drvLoc.toArray(new URL[drvLoc.size()])));
                    }
                    catch (IOException exc) {
                    }
                    catch (DatabaseException exc) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                DriverListNodeInfo info = (DriverListNodeInfo)n[0].getCookie(class$org$netbeans$modules$db$explorer$infos$DriverListNodeInfo == null ? (class$org$netbeans$modules$db$explorer$infos$DriverListNodeInfo = CustomizeDriverAction.class$("org.netbeans.modules.db.explorer.infos.DriverListNodeInfo")) : class$org$netbeans$modules$db$explorer$infos$DriverListNodeInfo);
                                if (info != null) {
                                    info.refreshChildren();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)dlgPanel, CustomizeDriverAction.bundle().getString("AddDriverDialogTitle"), true, actionListener);
        Object[] closingOptions = new Object[]{DialogDescriptor.CANCEL_OPTION};
        descriptor.setClosingOptions(closingOptions);
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        this.dialog.setVisible(true);
    }

    private void closeDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }
}

