/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class DatabaseTypePropertyEditor
implements PropertyEditor {
    private int[] constants;
    private String[] names;
    private int index;
    private String name;
    private PropertyChangeSupport support;

    public DatabaseTypePropertyEditor() {
        ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        this.support = new PropertyChangeSupport(this);
        this.constants = new int[]{2003, -5, -2, -7, 2004, 1, 2005, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 2, 7, 2006, 5, 92, 93, -6, -3, 12, 1111};
        this.names = new String[]{bundle.getString("SQL_ARRAY"), bundle.getString("SQL_BIGINT"), bundle.getString("SQL_BINARY"), bundle.getString("SQL_BIT"), bundle.getString("SQL_BLOB"), bundle.getString("SQL_CHAR"), bundle.getString("SQL_CLOB"), bundle.getString("SQL_DATE"), bundle.getString("SQL_DECIMAL"), bundle.getString("SQL_DISTINCT"), bundle.getString("SQL_DOUBLE"), bundle.getString("SQL_FLOAT"), bundle.getString("SQL_INTEGER"), bundle.getString("SQL_JAVA_OBJECT"), bundle.getString("SQL_LONGVARBINARY"), bundle.getString("SQL_LONGVARCHAR"), bundle.getString("SQL_NUMERIC"), bundle.getString("SQL_REAL"), bundle.getString("SQL_REF"), bundle.getString("SQL_SMALLINT"), bundle.getString("SQL_TIME"), bundle.getString("SQL_TIMESTAMP"), bundle.getString("SQL_TINYINT"), bundle.getString("SQL_VARBINARY"), bundle.getString("SQL_VARCHAR"), bundle.getString("SQL_OTHER")};
    }

    public DatabaseTypePropertyEditor(int[] types, String[] titles) {
        this.support = new PropertyChangeSupport(this);
        this.constants = types;
        this.names = titles;
    }

    public Object getValue() {
        return new Integer(this.constants[this.index]);
    }

    public void setValue(Object object) {
        int i;
        Integer type;
        ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        try {
            type = new Integer(object.toString());
        }
        catch (NumberFormatException exc) {
            String message = MessageFormat.format(bundle.getString("EXC_CannotOperateWith"), object.toString());
            throw new IllegalArgumentException(message);
        }
        int ii = type;
        int k = this.constants.length;
        for (i = 0; i < k && this.constants[i] != ii; ++i) {
        }
        if (i == k) {
            switch (ii) {
                case -7: {
                    this.name = bundle.getString("SQL_BIT");
                    break;
                }
                case -6: {
                    this.name = bundle.getString("SQL_TINYINT");
                    break;
                }
                case 5: {
                    this.name = bundle.getString("SQL_SMALLINT");
                    break;
                }
                case 4: {
                    this.name = bundle.getString("SQL_INTEGER");
                    break;
                }
                case -5: {
                    this.name = bundle.getString("SQL_BIGINT");
                    break;
                }
                case 6: {
                    this.name = bundle.getString("SQL_FLOAT");
                    break;
                }
                case 7: {
                    this.name = bundle.getString("SQL_REAL");
                    break;
                }
                case 8: {
                    this.name = bundle.getString("SQL_DOUBLE");
                    break;
                }
                case 2: {
                    this.name = bundle.getString("SQL_NUMERIC");
                    break;
                }
                case 3: {
                    this.name = bundle.getString("SQL_DECIMAL");
                    break;
                }
                case 1: {
                    this.name = bundle.getString("SQL_CHAR");
                    break;
                }
                case 12: {
                    this.name = bundle.getString("SQL_VARCHAR");
                    break;
                }
                case -1: {
                    this.name = bundle.getString("SQL_LONGVARCHAR");
                    break;
                }
                case 91: {
                    this.name = bundle.getString("SQL_DATE");
                    break;
                }
                case 92: {
                    this.name = bundle.getString("SQL_TIME");
                    break;
                }
                case 93: {
                    this.name = bundle.getString("SQL_TIMESTAMP");
                    break;
                }
                case -2: {
                    this.name = bundle.getString("SQL_BINARY");
                    break;
                }
                case -3: {
                    this.name = bundle.getString("SQL_VARBINARY");
                    break;
                }
                case -4: {
                    this.name = bundle.getString("SQL_LONGVARBINARY");
                    break;
                }
                case 0: {
                    this.name = bundle.getString("SQL_NULL");
                    break;
                }
                case 1111: {
                    this.name = bundle.getString("SQL_OTHER");
                    break;
                }
                case 2000: {
                    this.name = bundle.getString("SQL_JAVA_OBJECT");
                    break;
                }
                case 2001: {
                    this.name = bundle.getString("SQL_DISTINCT");
                    break;
                }
                case 2002: {
                    this.name = bundle.getString("SQL_STRUCT");
                    break;
                }
                case 2003: {
                    this.name = bundle.getString("SQL_ARRAY");
                    break;
                }
                case 2004: {
                    this.name = bundle.getString("SQL_BLOB");
                    break;
                }
                case 2005: {
                    this.name = bundle.getString("SQL_CLOB");
                    break;
                }
                case 2006: {
                    this.name = bundle.getString("SQL_REF");
                    break;
                }
                default: {
                    this.name = bundle.getString("SQL_UNKNOWN");
                }
            }
            this.index = 0;
        } else {
            this.index = i;
            this.name = this.names[i];
        }
        this.support.firePropertyChange(null, null, null);
    }

    public String getAsText() {
        return this.name;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int i;
        int k = this.names.length;
        for (i = 0; i < k && !this.names[i].equals(string); ++i) {
        }
        if (i == k) {
            String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotFindAsText"), string);
            throw new IllegalArgumentException(message);
        }
        this.index = i;
        this.name = this.names[i];
    }

    public String getJavaInitializationString() {
        return "" + this.index;
    }

    public String[] getTags() {
        return this.names;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

